/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.SGlyph;

public class CGlyph
extends Glyph {
    public static short PRIMARY_GLYPH_ONLY = 0;
    public static short ALL_GLYPHS = 1;
    short compSensit = ALL_GLYPHS;
    Glyph pGlyph;
    SGlyph[] sGlyphs;

    public CGlyph(Glyph glyph, SGlyph[] sGlyphArray) {
        this.setPrimaryGlyph(glyph);
        if (sGlyphArray != null && sGlyphArray.length > 0) {
            this.sGlyphs = sGlyphArray;
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].g.moveTo(this.pGlyph.vx + this.sGlyphs[i].xoffset, this.pGlyph.vy + this.sGlyphs[i].yoffset);
                this.sGlyphs[i].g.setCGlyph(this);
            }
        }
    }

    public void initCams(int n) {
    }

    public void addCamera(int n) {
    }

    public void removeCamera(int n) {
    }

    public void resetMouseIn(int n) {
    }

    public void move(long l, long l2) {
        this.vx += l;
        this.vy += l2;
        this.pGlyph.move(l, l2);
        if (this.sGlyphs != null) {
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].g.move(l, l2);
            }
        }
        this.propagateMove(l, l2);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void moveTo(long l, long l2) {
        this.propagateMove(l - this.vx, l2 - this.vy);
        this.pGlyph.moveTo(l, l2);
        if (this.sGlyphs != null) {
            double d = -this.getOrient();
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long l3 = Math.round((double)this.sGlyphs[i].xoffset * Math.cos(d) + (double)this.sGlyphs[i].yoffset * Math.sin(d));
                    long l4 = Math.round((double)this.sGlyphs[i].yoffset * Math.cos(d) - (double)this.sGlyphs[i].xoffset * Math.sin(d));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + l3, this.pGlyph.vy + l4);
                    continue;
                }
                this.sGlyphs[i].g.moveTo(l + this.sGlyphs[i].xoffset, l2 + this.sGlyphs[i].yoffset);
            }
        }
        this.vx = this.pGlyph.vx;
        this.vy = this.pGlyph.vy;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getOrient() {
        if (this.pGlyph != null) {
            return this.pGlyph.getOrient();
        }
        return 0.0f;
    }

    public void orientTo(float f) {
        try {
            this.pGlyph.orientTo(f);
            if (this.sGlyphs != null) {
                double d = -f;
                for (int i = 0; i < this.sGlyphs.length; ++i) {
                    if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_ANGLE_ONLY) {
                        this.sGlyphs[i].g.orientTo(f + this.sGlyphs[i].aoffset);
                    }
                    if (this.sGlyphs[i].rotationPolicy != SGlyph.FULL_ROTATION && this.sGlyphs[i].rotationPolicy != SGlyph.ROTATION_POSITION_ONLY) continue;
                    long l = Math.round((double)this.sGlyphs[i].xoffset * Math.cos(d) + (double)this.sGlyphs[i].yoffset * Math.sin(d));
                    long l2 = Math.round((double)this.sGlyphs[i].yoffset * Math.cos(d) - (double)this.sGlyphs[i].xoffset * Math.sin(d));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + l, this.pGlyph.vy + l2);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        if (this.pGlyph != null) {
            return this.pGlyph.getSize();
        }
        return 0.0f;
    }

    public void sizeTo(float f) {
        if (this.sGlyphs != null) {
            float f2 = f / this.getSize();
            double d = -this.getOrient();
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].xoffset = Math.round((float)this.sGlyphs[i].xoffset * f2);
                this.sGlyphs[i].yoffset = Math.round((float)this.sGlyphs[i].yoffset * f2);
                if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long l = Math.round((double)this.sGlyphs[i].xoffset * Math.cos(d) + (double)this.sGlyphs[i].yoffset * Math.sin(d));
                    long l2 = Math.round((double)this.sGlyphs[i].yoffset * Math.cos(d) - (double)this.sGlyphs[i].xoffset * Math.sin(d));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + l, this.pGlyph.vy + l2);
                } else {
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + this.sGlyphs[i].xoffset, this.pGlyph.vy + this.sGlyphs[i].yoffset);
                }
                if (this.sGlyphs[i].sizePolicy != SGlyph.RESIZE) continue;
                this.sGlyphs[i].g.reSize(f2);
            }
        }
        this.pGlyph.sizeTo(f);
    }

    public void reSize(float f) {
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return false;
    }

    public int mouseInOut(int n, int n2, int n3) {
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
    }

    void textDraw(Graphics2D graphics2D, int n) {
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
    }

    public void setSensitivity(short s) {
        if (s != this.compSensit) {
            if (s == PRIMARY_GLYPH_ONLY && this.sGlyphs != null) {
                for (int i = 0; i < this.sGlyphs.length; ++i) {
                    this.sGlyphs[i].g.setSensitivity(false);
                }
            } else if (s == ALL_GLYPHS && this.sGlyphs != null) {
                for (int i = 0; i < this.sGlyphs.length; ++i) {
                    this.sGlyphs[i].g.setSensitivity(true);
                }
            }
            this.compSensit = s;
        }
    }

    public void setPrimaryGlyph(Glyph glyph) {
        this.pGlyph = glyph;
        glyph.setCGlyph(this);
        this.vx = this.pGlyph.vx;
        this.vy = this.pGlyph.vy;
    }

    public void addSecondaryGlyph(Glyph glyph, long l, long l2) {
        if (this.sGlyphs == null) {
            this.sGlyphs = new SGlyph[1];
            this.sGlyphs[0] = new SGlyph(glyph, l, l2);
            this.sGlyphs[0].g.moveTo(this.pGlyph.vx + this.sGlyphs[0].xoffset, this.pGlyph.vy + this.sGlyphs[0].yoffset);
        } else {
            SGlyph[] sGlyphArray = new SGlyph[this.sGlyphs.length + 1];
            System.arraycopy(this.sGlyphs, 0, sGlyphArray, 0, this.sGlyphs.length);
            sGlyphArray[sGlyphArray.length - 1] = new SGlyph(glyph, l, l2);
            this.sGlyphs = sGlyphArray;
            this.sGlyphs[this.sGlyphs.length - 1].g.moveTo(this.pGlyph.vx + this.sGlyphs[this.sGlyphs.length - 1].xoffset, this.pGlyph.vy + this.sGlyphs[this.sGlyphs.length - 1].yoffset);
        }
        glyph.setCGlyph(this);
    }

    public void addSecondaryGlyph(SGlyph sGlyph) {
        if (this.sGlyphs == null) {
            this.sGlyphs = new SGlyph[1];
            this.sGlyphs[0] = sGlyph;
            this.sGlyphs[0].g.moveTo(this.pGlyph.vx + this.sGlyphs[0].xoffset, this.pGlyph.vy + this.sGlyphs[0].yoffset);
            this.sGlyphs[0].g.setCGlyph(this);
        } else {
            SGlyph[] sGlyphArray = new SGlyph[this.sGlyphs.length + 1];
            System.arraycopy(this.sGlyphs, 0, sGlyphArray, 0, this.sGlyphs.length);
            sGlyphArray[sGlyphArray.length - 1] = sGlyph;
            this.sGlyphs = sGlyphArray;
            this.sGlyphs[this.sGlyphs.length - 1].g.moveTo(this.pGlyph.vx + this.sGlyphs[this.sGlyphs.length - 1].xoffset, this.pGlyph.vy + this.sGlyphs[this.sGlyphs.length - 1].yoffset);
            this.sGlyphs[this.sGlyphs.length - 1].g.setCGlyph(this);
        }
    }

    public void removeSecondaryGlyph(Glyph glyph) {
        if (this.sGlyphs != null) {
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                if (this.sGlyphs[i].g != glyph) continue;
                glyph.setCGlyph(null);
                SGlyph[] sGlyphArray = new SGlyph[this.sGlyphs.length - 1];
                System.arraycopy(this.sGlyphs, 0, sGlyphArray, 0, i);
                System.arraycopy(this.sGlyphs, i + 1, sGlyphArray, i, this.sGlyphs.length - i - 1);
                this.sGlyphs = sGlyphArray;
                break;
            }
            if (this.sGlyphs.length == 0) {
                this.sGlyphs = null;
            }
        }
    }

    public SGlyph getSGlyph(Glyph glyph) {
        SGlyph sGlyph = null;
        if (this.sGlyphs != null) {
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                if (this.sGlyphs[i].g != glyph) continue;
                sGlyph = this.sGlyphs[i];
                break;
            }
        }
        return sGlyph;
    }

    public SGlyph[] getSecondaryGlyphs() {
        return this.sGlyphs;
    }
}

