/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.tests;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NavPanel
extends JFrame
implements ActionListener {
    VirtualSpaceManager vsm;
    JPanel transPanel;
    JPanel zoomPanel;
    int translationMode = 2;
    int zoomMode = 5;
    long translationTime = 500L;
    long zoomTime = 1000L;
    JButton upBt;
    JButton riBt;
    JButton doBt;
    JButton leBt;
    JButton hoBt;
    JButton zoomBt;
    JButton unzoomBt;
    JButton modeBt;
    View v;

    public NavPanel(VirtualSpaceManager virtualSpaceManager, View view) {
        this.vsm = virtualSpaceManager;
        this.transPanel = new JPanel();
        this.zoomPanel = new JPanel();
        this.transPanel.setSize(200, 100);
        this.zoomPanel.setSize(100, 100);
        this.transPanel.setLayout(new BorderLayout());
        this.zoomPanel.setLayout(new GridLayout(3, 1));
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 2));
        container.add(this.transPanel);
        container.add(this.zoomPanel);
        this.upBt = new JButton(new ImageIcon("images/Up16b.gif"));
        this.upBt.addActionListener(this);
        this.transPanel.add("North", this.upBt);
        this.riBt = new JButton(new ImageIcon("images/Forward16b.gif"));
        this.riBt.addActionListener(this);
        this.transPanel.add("East", this.riBt);
        this.doBt = new JButton(new ImageIcon("images/Down16b.gif"));
        this.doBt.addActionListener(this);
        this.transPanel.add("South", this.doBt);
        this.leBt = new JButton(new ImageIcon("images/Back16b.gif"));
        this.leBt.addActionListener(this);
        this.transPanel.add("West", this.leBt);
        this.hoBt = new JButton(new ImageIcon("images/Home16b.gif"));
        this.hoBt.addActionListener(this);
        this.transPanel.add("Center", this.hoBt);
        this.zoomBt = new JButton(new ImageIcon("images/ZoomIn16b.gif"));
        this.zoomBt.addActionListener(this);
        this.zoomPanel.add(this.zoomBt);
        this.unzoomBt = new JButton(new ImageIcon("images/ZoomOut16b.gif"));
        this.unzoomBt.addActionListener(this);
        this.zoomPanel.add(this.unzoomBt);
        this.modeBt = new JButton("Source");
        this.modeBt.addActionListener(this);
        this.zoomPanel.add(this.modeBt);
        this.v = view;
        this.setTitle("Navigation");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        this.setLocation(752, 300);
        this.setSize(300, 125);
        this.setVisible(true);
    }

    public void switchMode() {
        if (this.modeBt.getText().equals("matching")) {
            this.vsm.getActiveView().setActiveLayer(0);
            this.modeBt.setText(" source ");
        } else {
            this.vsm.getActiveView().setActiveLayer(1);
            this.modeBt.setText("matching");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.upBt) {
            this.vsm.animator.createCameraAnimation(this.translationTime, this.translationMode, new LongPoint(0L, -100L), this.vsm.getActiveView().getActiveCamera().getID());
        } else if (jButton == this.riBt) {
            this.vsm.animator.createCameraAnimation(this.translationTime, this.translationMode, new LongPoint(-100L, 0L), this.vsm.getActiveView().getActiveCamera().getID());
        } else if (jButton == this.leBt) {
            this.vsm.animator.createCameraAnimation(this.translationTime, this.translationMode, new LongPoint(100L, 0L), this.vsm.getActiveView().getActiveCamera().getID());
        } else if (jButton == this.doBt) {
            this.vsm.animator.createCameraAnimation(this.translationTime, this.translationMode, new LongPoint(0L, 100L), this.vsm.getActiveView().getActiveCamera().getID());
        } else if (jButton == this.hoBt) {
            Camera camera = this.vsm.getActiveView().getActiveCamera();
            this.vsm.animator.createCameraAnimation(this.translationTime, this.translationMode, new LongPoint(-camera.posx, -camera.posy), camera.getID());
        } else if (jButton == this.zoomBt) {
            this.vsm.animator.createCameraAnimation(this.zoomTime, this.zoomMode, new Float(-50.0f), this.vsm.getActiveView().getActiveCamera().getID());
        } else if (jButton == this.unzoomBt) {
            this.vsm.animator.createCameraAnimation(this.zoomTime, this.zoomMode, new Float(50.0f), this.vsm.getActiveView().getActiveCamera().getID());
        } else if (jButton == this.modeBt) {
            this.switchMode();
        } else {
            System.err.println("Error : Navigation : unknown command");
        }
    }
}

