/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.svg;

import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VSegment;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.EventHandlerTest2;
import com.xerox.VTM.svg.PathSegment;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class SVGTest2 {
    VirtualSpaceManager vsm;
    AppEventHandler eh;
    String xmlFile;
    String vsp = "src";

    SVGTest2(String string) {
        this.xmlFile = string;
        this.vsm = new VirtualSpaceManager();
        this.initSVGTest();
    }

    public void initSVGTest() {
        this.vsm.addVirtualSpace("src");
        this.vsm.setDebug(true);
        this.eh = new EventHandlerTest2(this);
        this.vsm.addCamera("src");
        Vector<Camera> vector = new Vector<Camera>();
        vector.add(this.vsm.getVirtualSpace("src").getCamera(0));
        this.vsm.addView(vector, "Source", 800, 600, false, true);
        this.vsm.getView("Source").setEventHandler(this.eh);
        this.load();
    }

    void load() {
        Document document = SVGTest2.parse(this.xmlFile);
        SVGReader.load(document, this.vsm, "src");
        VSegment vSegment = new VSegment(0L, 0L, 0.0f, 10000L, 0L, Color.yellow);
        this.vsm.addGlyph(vSegment, "src");
        vSegment = new VSegment(0L, 0L, 0.0f, 0L, 10000L, Color.yellow);
        this.vsm.addGlyph(vSegment, "src");
    }

    public static Document parse(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            return document;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    void displaySVG(Document document) {
        Object object;
        Element element = document.getDocumentElement();
        if (element.hasAttribute("width") && element.hasAttribute("height")) {
            object = element.getAttribute("width");
            String string = element.getAttribute("height");
            try {
                long l = -new Long(((String)object).substring(0, ((String)object).length() - 2)).longValue() / 2L;
                long l2 = -new Long(string.substring(0, string.length() - 2)).longValue() / 2L;
                SVGReader.setPositionOffset(l, l2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        object = element.getElementsByTagName("g").item(0).getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node.getNodeType() != 1) continue;
            this.processSVG1711Node((Element)node);
        }
        SVGReader.setPositionOffset(0L, 0L);
    }

    void processSVG1711Node(Element element) {
        if (element.getAttribute("class").equals("node")) {
            NodeList nodeList = element.getElementsByTagName("ellipse");
            if (nodeList.getLength() > 0) {
                VEllipse vEllipse = SVGReader.createEllipse((Element)nodeList.item(0));
                Element element2 = (Element)element.getElementsByTagName("text").item(0);
                VText vText = SVGReader.createText(element2, this.vsm);
                this.vsm.addGlyph(vEllipse, this.vsp);
                this.vsm.addGlyph(vText, this.vsp);
            } else {
                nodeList = element.getElementsByTagName("polygon");
                if (nodeList.getLength() > 0) {
                    Element element3;
                    VRectangleOr vRectangleOr = SVGReader.createRectangleFromPolygon((Element)nodeList.item(0));
                    VText vText = null;
                    if (vRectangleOr != null) {
                        this.vsm.addGlyph(vRectangleOr, this.vsp);
                    }
                    if ((element3 = (Element)element.getElementsByTagName("text").item(0)) != null) {
                        vText = SVGReader.createText(element3, this.vsm);
                        this.vsm.addGlyph(vText, this.vsp);
                    }
                } else {
                    System.err.println("Error: processSVG1711Node: unknown tag in " + element);
                }
            }
        } else if (element.getAttribute("class").equals("edge")) {
            String string = ((Element)element.getElementsByTagName("path").item(0)).getAttribute("d");
            Element element4 = (Element)element.getElementsByTagName("polygon").item(0);
            Vector vector = new Vector();
            SVGReader.translateSVGPolygon(element4.getAttribute("points"), vector);
            LongPoint longPoint = (LongPoint)vector.firstElement();
            long l = longPoint.x;
            long l2 = longPoint.x;
            long l3 = longPoint.y;
            long l4 = longPoint.y;
            for (int i = 1; i < vector.size(); ++i) {
                longPoint = (LongPoint)vector.elementAt(i);
                if (longPoint.x < l) {
                    l = longPoint.x;
                }
                if (longPoint.x > l2) {
                    l2 = longPoint.x;
                }
                if (longPoint.y < l3) {
                    l3 = longPoint.y;
                }
                if (longPoint.y <= l4) continue;
                l4 = longPoint.y;
            }
            VPath vPath = SVGReader.createPath(string, new VPath());
            vPath = SVGTest2.invertPath((l + l2) / 2L, (l3 + l4) / 2L, vPath);
            this.vsm.addGlyph(vPath, this.vsp);
            PathIterator pathIterator = vPath.getJava2DPathIterator();
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(fArray);
                pathIterator.next();
            }
            double d = 0.0;
            Point2D point2D = SVGTest2.computeStepValue(fArray[2], -fArray[3], fArray[4], -fArray[5]);
            if (point2D.getX() == 0.0) {
                d = 0.0;
                if (point2D.getY() < 0.0) {
                    d = Math.PI;
                }
            } else {
                d = Math.atan(point2D.getY() / point2D.getX());
                d = point2D.getX() < 0.0 ? (d += 1.5707963267948966) : (d -= 1.5707963267948966);
            }
            VTriangleOr vTriangleOr = new VTriangleOr((l2 + l) / 2L, -(l4 + l3) / 2L, 0.0f, Math.max(l2 - l, l4 - l3) / 2L, Color.black, (float)d);
            this.vsm.addGlyph(vTriangleOr, this.vsp);
            VText vText = SVGReader.createText((Element)element.getElementsByTagName("text").item(0), this.vsm);
            this.vsm.addGlyph(vText, this.vsp);
        }
    }

    public static Point2D computeStepValue(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        int n;
        int n2 = d3 >= d ? 1 : -1;
        int n3 = n = d4 >= d2 ? 1 : -1;
        if (d3 == d) {
            d6 = 0.0;
            d5 = n;
        } else {
            double d7 = (d4 - d2) / (d3 - d);
            if (Math.abs(d7) > 1.0) {
                d6 = (double)n2 / Math.abs(d7);
                d5 = n;
            } else {
                d6 = n2;
                d5 = (double)n * Math.abs(d7);
            }
        }
        return new Point2D.Double(d6, d5);
    }

    static VPath invertPath(long l, long l2, VPath vPath) {
        double d;
        double d2;
        double d3;
        double d4;
        PathIterator pathIterator = vPath.getJava2DPathIterator();
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        pathIterator.next();
        if (n == 0) {
            d4 = dArray[0];
            d3 = dArray[1];
        } else {
            d4 = 0.0;
            d3 = 0.0;
        }
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(dArray);
            pathIterator.next();
        }
        if (n == 3) {
            d2 = dArray[4];
            d = dArray[5];
        } else if (n == 2) {
            d2 = dArray[2];
            d = dArray[3];
        } else if (n == 1) {
            d2 = dArray[0];
            d = dArray[1];
        } else if (n == 4) {
            d2 = d4;
            d = d3;
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        double d5 = Math.sqrt(Math.pow((double)l - d4, 2.0) + Math.pow((double)l2 - d3, 2.0));
        double d6 = Math.sqrt(Math.pow((double)l - d2, 2.0) + Math.pow((double)l2 - d, 2.0));
        if (d5 < d6) {
            pathIterator = vPath.getJava2DPathIterator();
            Vector<PathSegment> vector = new Vector<PathSegment>();
            while (!pathIterator.isDone()) {
                n = pathIterator.currentSegment(dArray);
                vector.add(new PathSegment(dArray, n));
                pathIterator.next();
            }
            VPath vPath2 = new VPath();
            PathSegment pathSegment = (PathSegment)vector.elementAt(vector.size() - 1);
            if (pathSegment.getType() == 3) {
                vPath2.jump((long)pathSegment.cds[4], (long)pathSegment.cds[5], true);
            } else if (pathSegment.getType() == 0) {
                vPath2.jump((long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
            } else if (pathSegment.getType() == 2) {
                vPath2.jump((long)pathSegment.cds[2], (long)pathSegment.cds[3], true);
            } else if (pathSegment.getType() == 1) {
                vPath2.jump((long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
            }
            for (int i = vector.size() - 1; i > 0; --i) {
                pathSegment = (PathSegment)vector.elementAt(i);
                PathSegment pathSegment2 = (PathSegment)vector.elementAt(i - 1);
                if (pathSegment.getType() == 3) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.addCbCurve((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                        continue;
                    }
                    if (pathSegment2.getType() == 0) {
                        vPath2.addCbCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                        continue;
                    }
                    if (pathSegment2.getType() == 2) {
                        vPath2.addCbCurve((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                        continue;
                    }
                    if (pathSegment2.getType() != 1) continue;
                    vPath2.addCbCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    continue;
                }
                if (pathSegment.getType() == 0) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.jump((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], true);
                        continue;
                    }
                    if (pathSegment2.getType() == 0) {
                        vPath2.jump((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                        continue;
                    }
                    if (pathSegment2.getType() == 2) {
                        vPath2.jump((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], true);
                        continue;
                    }
                    if (pathSegment2.getType() != 1) continue;
                    vPath2.jump((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                    continue;
                }
                if (pathSegment.getType() == 2) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.addQdCurve((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], (long)pathSegment.cds[4], (long)pathSegment.cds[5], true);
                        continue;
                    }
                    if (pathSegment2.getType() == 0) {
                        vPath2.addQdCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                        continue;
                    }
                    if (pathSegment2.getType() == 2) {
                        vPath2.addQdCurve((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], (long)pathSegment.cds[2], (long)pathSegment.cds[3], true);
                        continue;
                    }
                    if (pathSegment2.getType() != 1) continue;
                    vPath2.addQdCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    continue;
                }
                if (pathSegment.getType() != 1) continue;
                if (pathSegment2.getType() == 3) {
                    vPath2.addSegment((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], true);
                    continue;
                }
                if (pathSegment2.getType() == 0) {
                    vPath2.addSegment((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                    continue;
                }
                if (pathSegment2.getType() == 2) {
                    vPath2.addSegment((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], true);
                    continue;
                }
                if (pathSegment2.getType() != 1) continue;
                vPath2.addSegment((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
            }
            return vPath2;
        }
        return vPath;
    }

    public static void main(String[] stringArray) {
        SVGTest2 sVGTest2 = new SVGTest2(stringArray[0]);
    }
}

