/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class VText
extends Glyph {
    public static short TEXT_ANCHOR_START = 0;
    public static short TEXT_ANCHOR_MIDDLE = 1;
    public static short TEXT_ANCHOR_END = (short)2;
    private short text_anchor = TEXT_ANCHOR_START;
    AffineTransform at;
    ProjText[] pc;
    boolean zoomSensitive = true;

    public VText(String string) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.sensit = false;
        this.text = string;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VText(long l, long l2, float f, Color color, String string) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.sensit = false;
        this.text = string;
        this.setColor(color);
        this.setBorderColor(Color.black);
    }

    public VText(long l, long l2, float f, Color color, String string, short s) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.sensit = false;
        this.text = string;
        this.setColor(color);
        this.setBorderColor(Color.black);
        this.text_anchor = s;
    }

    public void initCams(int n) {
        this.pc = new ProjText[n];
        for (int i = 0; i < n; ++i) {
            this.pc[i] = new ProjText();
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjText[] projTextArray = this.pc;
                this.pc = new ProjText[projTextArray.length + 1];
                for (int i = 0; i < projTextArray.length; ++i) {
                    this.pc[i] = projTextArray[i];
                }
                this.pc[this.pc.length - 1] = new ProjText();
            } else {
                System.err.println("VText:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjText[1];
            this.pc[0] = new ProjText();
        } else {
            System.err.println("VText:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public void sizeTo(float f) {
    }

    public void reSize(float f) {
    }

    public void orientTo(float f) {
    }

    public float getSize() {
        return 1.0f;
    }

    public float getOrient() {
        return this.orient;
    }

    public void setZoomSensitive(boolean bl) {
        if (this.zoomSensitive != bl) {
            this.zoomSensitive = bl;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    public boolean drawMe(long l, long l2, long l3, long l4, int n) {
        if (this.vx >= l3 && this.vx <= l && this.vy >= l4 && this.vy <= l2) {
            return true;
        }
        if (this.text_anchor == TEXT_ANCHOR_START) {
            return this.vx <= l && this.vx + (long)this.pc[n].cw >= l3 && this.vy <= l2 && this.vy + (long)this.pc[n].ch >= l4;
        }
        if (this.text_anchor == TEXT_ANCHOR_MIDDLE) {
            return this.vx - (long)(this.pc[n].cw / 2) <= l && this.vx + (long)(this.pc[n].cw / 2) >= l3 && this.vy <= l2 && this.vy + (long)this.pc[n].ch >= l4;
        }
        return this.vx - (long)this.pc[n].cw <= l && this.vx >= l3 && this.vy <= l2 && this.vy + (long)this.pc[n].ch >= l4;
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return false;
    }

    public int mouseInOut(int n, int n2, int n3) {
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        graphics2D.setColor(this.color);
        if (this.coef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            if (this.font != null) {
                graphics2D.setFont(this.font);
                if (!this.pc[n3].valid) {
                    Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D);
                    this.pc[n3].cw = (int)rectangle2D.getWidth();
                    this.pc[n3].ch = (int)rectangle2D.getHeight();
                    this.pc[n3].valid = true;
                }
                this.at = this.text_anchor == TEXT_ANCHOR_START ? AffineTransform.getTranslateInstance(this.pc[n3].cx, this.pc[n3].cy) : (this.text_anchor == TEXT_ANCHOR_MIDDLE ? AffineTransform.getTranslateInstance((float)this.pc[n3].cx - (float)this.pc[n3].cw * this.coef / 2.0f, this.pc[n3].cy) : AffineTransform.getTranslateInstance((float)this.pc[n3].cx - (float)this.pc[n3].cw * this.coef, this.pc[n3].cy));
                if (this.zoomSensitive) {
                    this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
                }
                graphics2D.setTransform(this.at);
                try {
                    graphics2D.drawString(this.text, 0.0f, 0.0f);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                graphics2D.setFont(VirtualSpaceManager.getMainFont());
            } else {
                if (!this.pc[n3].valid) {
                    Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D);
                    this.pc[n3].cw = (int)rectangle2D.getWidth();
                    this.pc[n3].ch = (int)rectangle2D.getHeight();
                    this.pc[n3].valid = true;
                }
                this.at = this.text_anchor == TEXT_ANCHOR_START ? AffineTransform.getTranslateInstance(this.pc[n3].cx, this.pc[n3].cy) : (this.text_anchor == TEXT_ANCHOR_MIDDLE ? AffineTransform.getTranslateInstance((float)this.pc[n3].cx - (float)this.pc[n3].cw * this.coef / 2.0f, this.pc[n3].cy) : AffineTransform.getTranslateInstance((float)this.pc[n3].cx - (float)this.pc[n3].cw * this.coef, this.pc[n3].cy));
                if (this.zoomSensitive) {
                    this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
                }
                graphics2D.setTransform(this.at);
                try {
                    graphics2D.drawString(this.text, 0.0f, 0.0f);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.invalidate();
    }

    public void invalidate() {
        try {
            for (int i = 0; i < this.pc.length; ++i) {
                this.pc[i].valid = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public LongPoint getBounds(int n) {
        return new LongPoint(this.pc[n].cw, this.pc[n].ch);
    }

    public boolean validBounds(int n) {
        return this.pc[n].valid;
    }

    public void setSpecialFont(Font font) {
        super.setSpecialFont(font);
        this.invalidate();
    }

    public void setTextAnchor(short s) {
        this.text_anchor = s;
    }

    public short getTextAnchor() {
        return this.text_anchor;
    }
}

