/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjSegment;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VSegment
extends Glyph
implements RectangularShape {
    long vw;
    long vh;
    ProjSegment[] pc;

    public VSegment() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.orient = 0.0f;
        this.size = 10.0f;
        this.computeEdges();
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VSegment(long l, long l2, float f, long l3, long l4, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vw = l3;
        this.vh = l4;
        this.computeSize();
        this.setColor(color);
        this.setBorderColor(Color.black);
    }

    public VSegment(long l, long l2, float f, float f2, float f3, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.orient = f3;
        this.size = f2;
        this.computeEdges();
        this.setColor(color);
        this.setBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjSegment[n];
        for (int i = 0; i < n; ++i) {
            this.pc[i] = new ProjSegment();
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjSegment[] projSegmentArray = this.pc;
                this.pc = new ProjSegment[projSegmentArray.length + 1];
                for (int i = 0; i < projSegmentArray.length; ++i) {
                    this.pc[i] = projSegmentArray[i];
                }
                this.pc[this.pc.length - 1] = new ProjSegment();
            } else {
                System.err.println("VSegment:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjSegment[1];
            this.pc[0] = new ProjSegment();
        } else {
            System.err.println("VSegment:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
        this.orient = f;
        this.computeEdges();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
        if (this.vw != 0L) {
            this.orient = (float)Math.atan((float)this.vh / (float)this.vw);
        } else {
            float f = this.orient = this.vh > 0L ? 1.5707964f : -1.5707964f;
        }
        if (this.orient < 0.0f) {
            this.orient = this.vh > 0L ? (float)Math.PI - this.orient : -this.orient;
        } else if (this.orient > 0.0f) {
            this.orient = this.vh > 0L ? (float)Math.PI * 2 - this.orient : (float)Math.PI - this.orient;
        } else if (this.orient == 0.0f && this.vw < 0L) {
            this.orient = (float)Math.PI;
        }
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    public void sizeTo(float f) {
        this.size = f;
        this.computeEdges();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float f) {
        this.size *= f;
        this.computeEdges();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidth(long l) {
        this.vw = l;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHeight(long l) {
        this.vh = l;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidthHeight(long l, long l2) {
        this.vw = l;
        this.vh = l2;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    void computeEdges() {
        this.vw = Math.round((double)this.size * Math.cos(this.orient));
        this.vh = Math.round((double)this.size * Math.sin(this.orient));
    }

    public boolean coordInside(int n, int n2, int n3) {
        return false;
    }

    public int mouseInOut(int n, int n2, int n3) {
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cw = Math.round((float)this.vw * this.coef);
        this.pc[n].ch = Math.round((float)this.vh * this.coef);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cw) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].ch - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].ch + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cw) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].ch - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].ch + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        graphics2D.setColor(this.color);
        if (this.stroke != null) {
            graphics2D.setStroke(this.stroke);
            graphics2D.drawLine(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, this.pc[n3].cx + this.pc[n3].cw, this.pc[n3].cy + this.pc[n3].ch);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.drawLine(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, this.pc[n3].cx + this.pc[n3].cw, this.pc[n3].cy + this.pc[n3].ch);
        }
        this.textDraw(graphics2D, n3);
    }
}

