/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjEllipse;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VEllipse
extends Glyph
implements RectangularShape {
    long vw;
    long vh;
    float ar;
    ProjEllipse[] pc;

    public VEllipse() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.vw = 10L;
        this.vh = 10L;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
        this.computeSize();
    }

    public VEllipse(long l, long l2, float f, long l3, long l4, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vw = l3;
        this.vh = l4;
        this.orient = 0.0f;
        this.setColor(color);
        this.setBorderColor(Color.black);
        this.computeSize();
    }

    public void initCams(int n) {
        this.pc = new ProjEllipse[n];
        for (int i = 0; i < n; ++i) {
            this.pc[i] = new ProjEllipse();
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjEllipse[] projEllipseArray = this.pc;
                this.pc = new ProjEllipse[projEllipseArray.length + 1];
                for (int i = 0; i < projEllipseArray.length; ++i) {
                    this.pc[i] = projEllipseArray[i];
                }
                this.pc[this.pc.length - 1] = new ProjEllipse();
            } else {
                System.err.println("VEllipse:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjEllipse[1];
            this.pc[0] = new ProjEllipse();
        } else {
            System.err.println("VEllipse:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return 0.0f;
    }

    public void orientTo(float f) {
    }

    void computeSize() {
        this.size = Math.max(this.vw, this.vh);
        this.ar = (float)this.vw / (float)this.vh;
    }

    public float getSize() {
        return this.size;
    }

    public void sizeTo(float f) {
        this.size = f;
        if (this.vw >= this.vh) {
            this.vw = (long)this.size;
            this.vh = (long)((float)this.vw / this.ar);
        } else {
            this.vh = (long)this.size;
            this.vw = (long)((float)this.vh * this.ar);
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidth(long l) {
        this.vw = l;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHeight(long l) {
        this.vh = l;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    public void reSize(float f) {
        this.size *= f;
        if (this.vw >= this.vh) {
            this.vw = (long)this.size;
            this.vh = (long)((float)this.vw / this.ar);
        } else {
            this.vh = (long)this.size;
            this.vw = (long)((float)this.vh * this.ar);
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return this.pc[n3].ellipse.contains(n, n2);
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cvw = (float)this.vw * this.coef;
        this.pc[n].cvh = (float)this.vh * this.coef;
        this.pc[n].ellipse.setFrame((float)this.pc[n].cx - (float)this.vw * this.coef, (float)this.pc[n].cy - (float)this.vh * this.coef, 2.0f * this.pc[n].cvw, 2.0f * this.pc[n].cvh);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && (float)this.textWidth < 2.0f * this.pc[n].cvw) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy - this.pc[n].cvh - 4.0f);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy + this.pc[n].cvh + (float)this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while ((float)this.textWidth > 2.0f * this.pc[n].cvw) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy - this.pc[n].cvh - 4.0f);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy + this.pc[n].cvh + (float)this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].ellipse.getBounds().width > 2 && this.pc[n3].ellipse.getBounds().height > 2) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fill(this.pc[n3].ellipse);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.draw(this.pc[n3].ellipse);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.draw(this.pc[n3].ellipse);
                }
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }
}

