/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjCircle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VCircle
extends Glyph {
    long vr;
    ProjCircle[] pc;

    public VCircle() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.vr = 10L;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VCircle(long l, long l2, float f, long l3, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vr = l3;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(color);
        this.setBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjCircle[n];
        for (int i = 0; i < n; ++i) {
            this.pc[i] = new ProjCircle();
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjCircle[] projCircleArray = this.pc;
                this.pc = new ProjCircle[projCircleArray.length + 1];
                for (int i = 0; i < projCircleArray.length; ++i) {
                    this.pc[i] = projCircleArray[i];
                }
                this.pc[this.pc.length - 1] = new ProjCircle();
            } else {
                System.err.println("VCircle:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjCircle[1];
            this.pc[0] = new ProjCircle();
        } else {
            System.err.println("VCircle:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
    }

    public void orientToNS(float f) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vr;
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vr = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float f) {
        this.size *= f;
        this.vr = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long l, long l2, int n) {
        return Math.sqrt(Math.pow(l - (long)this.pc[n].cx, 2.0) + Math.pow(l2 - (long)this.pc[n].cy, 2.0)) <= (double)this.pc[n].cr && Math.sqrt(Math.pow(this.pc[n].cx, 2.0) + Math.pow(l2 - (long)this.pc[n].cy, 2.0)) <= (double)this.pc[n].cr && Math.sqrt(Math.pow(l - (long)this.pc[n].cx, 2.0) + Math.pow(this.pc[n].cy, 2.0)) <= (double)this.pc[n].cr && Math.sqrt(Math.pow(this.pc[n].cx, 2.0) + Math.pow(this.pc[n].cy, 2.0)) <= (double)this.pc[n].cr;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return Math.sqrt(Math.pow(n - this.pc[n3].cx, 2.0) + Math.pow(n2 - this.pc[n3].cy, 2.0)) <= (double)this.pc[n3].cr;
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cr = Math.round((float)this.vr * this.coef);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cr) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cr - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cr + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cr) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cr - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cr + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cr > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillOval(this.pc[n3].cx - this.pc[n3].cr, this.pc[n3].cy - this.pc[n3].cr, 2 * this.pc[n3].cr, 2 * this.pc[n3].cr);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.drawOval(this.pc[n3].cx - this.pc[n3].cr, this.pc[n3].cy - this.pc[n3].cr, 2 * this.pc[n3].cr, 2 * this.pc[n3].cr);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.drawOval(this.pc[n3].cx - this.pc[n3].cr, this.pc[n3].cy - this.pc[n3].cr, 2 * this.pc[n3].cr, 2 * this.pc[n3].cr);
                }
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }
}

