/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VCirShape
extends Glyph {
    Color shapeColor;
    Color shapebColor;
    boolean paintShapeBorder = true;
    boolean shapeFilled = true;
    long vs;
    ProjShape[] pc;
    float[] vertices;

    public VCirShape(float[] fArray) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.vs = 10L;
        this.vertices = fArray;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
        this.setShapeColor(Color.red);
        this.setShapebColor(Color.black);
    }

    public VCirShape(long l, long l2, float f, long l3, float[] fArray, Color color, Color color2, float f2) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vs = l3;
        this.vertices = fArray;
        this.computeSize();
        this.orient = f2;
        this.setColor(color);
        this.setBorderColor(this.bColor);
        this.setShapeColor(color2);
        this.setShapebColor(this.bColor);
    }

    public void initCams(int n) {
        this.pc = new ProjShape[n];
        for (int i = 0; i < n; ++i) {
            this.pc[i] = new ProjShape();
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjShape[] projShapeArray = this.pc;
                this.pc = new ProjShape[projShapeArray.length + 1];
                for (int i = 0; i < projShapeArray.length; ++i) {
                    this.pc[i] = projShapeArray[i];
                }
                this.pc[this.pc.length - 1] = new ProjShape();
            } else {
                System.err.println("VCirShape:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjShape[1];
            this.pc[0] = new ProjShape();
        } else {
            System.err.println("VCirShape:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
        this.orient = f;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float f) {
        this.size *= f;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Color getShapeColor() {
        return this.shapeColor;
    }

    public Color getShapebColor() {
        return this.shapebColor;
    }

    public boolean getShapeFillStatus() {
        return this.shapeFilled;
    }

    public boolean fillsView(long l, long l2, int n) {
        return Math.sqrt(Math.pow(l - (long)this.pc[n].cx, 2.0) + Math.pow(l2 - (long)this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs && Math.sqrt(Math.pow(this.pc[n].cx, 2.0) + Math.pow(l2 - (long)this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs && Math.sqrt(Math.pow(l - (long)this.pc[n].cx, 2.0) + Math.pow(this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs && Math.sqrt(Math.pow(this.pc[n].cx, 2.0) + Math.pow(this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return Math.sqrt(Math.pow(n - this.pc[n3].cx, 2.0) + Math.pow(n2 - this.pc[n3].cy, 2.0)) <= (double)this.pc[n3].cs;
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cs = Math.round((float)this.vs * this.coef);
        int[] nArray = new int[this.vertices.length];
        int[] nArray2 = new int[this.vertices.length];
        float f = this.orient;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            nArray[i] = (int)Math.round((double)this.pc[n].cx + (double)this.pc[n].cs * Math.cos(f) * (double)this.vertices[i]);
            nArray2[i] = (int)Math.round((double)this.pc[n].cy - (double)this.pc[n].cs * Math.sin(f) * (double)this.vertices[i]);
            f = (float)((double)f + Math.PI * 2 / (double)this.vertices.length);
        }
        nArray[this.vertices.length - 1] = (int)Math.round((double)this.pc[n].cx + (double)this.pc[n].cs * Math.cos(f) * (double)this.vertices[this.vertices.length - 1]);
        nArray2[this.vertices.length - 1] = (int)Math.round((double)this.pc[n].cy - (double)this.pc[n].cs * Math.sin(f) * (double)this.vertices[this.vertices.length - 1]);
        this.pc[n].p = new Polygon(nArray, nArray2, this.vertices.length);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cs) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cs) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cs > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillOval(this.pc[n3].cx - this.pc[n3].cs, this.pc[n3].cy - this.pc[n3].cs, 2 * this.pc[n3].cs, 2 * this.pc[n3].cs);
            }
            if (this.paintBorder) {
                graphics2D.setColor(this.borderColor);
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.drawOval(this.pc[n3].cx - this.pc[n3].cs, this.pc[n3].cy - this.pc[n3].cs, 2 * this.pc[n3].cs, 2 * this.pc[n3].cs);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.drawOval(this.pc[n3].cx - this.pc[n3].cs, this.pc[n3].cy - this.pc[n3].cs, 2 * this.pc[n3].cs, 2 * this.pc[n3].cs);
                }
            }
            if (this.shapeFilled) {
                graphics2D.setColor(this.shapeColor);
                graphics2D.fillPolygon(this.pc[n3].p);
            }
            if (this.paintShapeBorder) {
                graphics2D.setColor(this.shapebColor);
                graphics2D.drawPolygon(this.pc[n3].p);
            }
            graphics2D.setColor(this.borderColor);
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public void setShapeColor(Color color) {
        this.shapeColor = color;
    }

    public void setShapebColor(Color color) {
        this.shapebColor = color;
    }

    public void setShapeFill(boolean bl) {
        this.shapeFilled = bl;
    }

    public void setPaintBorder(boolean bl) {
        this.paintShapeBorder = bl;
    }
}

