/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import java.util.Vector;
import net.claribole.zvtm.glyphs.CGlyph;

public abstract class Glyph {
    Long ID;
    public long vx;
    public long vy;
    public float vz;
    float size;
    float orient = 0.0f;
    boolean selected = false;
    boolean visible = true;
    boolean sensit = true;
    String text;
    int fontSizePolicy = 1;
    int textPos = 0;
    int textWidth;
    int textHeight;
    public static float fontSize = VirtualSpaceManager.getMainFont().getSize2D();
    Font font;
    Object owner;
    String type = "";
    CGlyph cGlyph = null;
    Vector dependants;
    public float coef = 1.0f;
    public VirtualSpaceManager vsm;
    public Color color;
    public Color borderColor;
    public Color selectedColor;
    public Color mouseInsideColor;
    public Color bColor = Color.black;
    protected float[] HSV = new float[3];
    protected float[] HSVb = new float[3];
    BasicStroke stroke = null;
    boolean dashedContour = false;
    float[] dash1 = new float[]{5.0f};
    float strokeWidth = 1.0f;
    boolean paintBorder = true;
    boolean filled = true;
    Vector stickedGlyphs;
    public Object stickedTo;

    public void setSensitivity(boolean bl) {
        this.sensit = bl;
    }

    public boolean isSensitive() {
        return this.sensit;
    }

    public void setCGlyph(CGlyph cGlyph) {
        this.cGlyph = cGlyph;
    }

    public CGlyph getCGlyph() {
        return this.cGlyph;
    }

    public void addDependant(Glyph glyph) {
        if (this.dependants == null) {
            this.dependants = new Vector();
        }
        this.dependants.add(glyph);
    }

    public void removeDependant(Glyph glyph) {
        if (this.dependants != null) {
            this.dependants.remove(glyph);
        }
        if (this.dependants.isEmpty()) {
            this.dependants = null;
        }
    }

    public Vector getDependants() {
        return this.dependants;
    }

    public void setDashed(boolean bl) {
        this.dashedContour = bl;
        this.stroke = this.dashedContour ? new BasicStroke(this.strokeWidth, 0, 0, 10.0f, this.dash1, 0.0f) : (this.strokeWidth == 1.0f ? null : new BasicStroke(this.strokeWidth));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setStrokeWidth(float f) {
        this.strokeWidth = f;
        this.stroke = this.dashedContour ? new BasicStroke(this.strokeWidth, 0, 0, 10.0f, this.dash1, 0.0f) : (this.strokeWidth == 1.0f ? null : new BasicStroke(this.strokeWidth));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke != null) {
            this.stroke = basicStroke;
        } else {
            basicStroke = null;
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setPaintBorder(boolean bl) {
        if (bl != this.paintBorder) {
            this.paintBorder = bl;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean getPaintBorderStatus() {
        return this.paintBorder;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public void setMouseInsideColor(Color color) {
        this.mouseInsideColor = color;
    }

    public void select(boolean bl) {
        this.selected = bl;
        this.borderColor = bl ? (this.selectedColor != null ? this.selectedColor : this.color) : this.bColor;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setFill(boolean bl) {
        if (bl != this.filled) {
            this.filled = bl;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean getFillStatus() {
        return this.filled;
    }

    public abstract void draw(Graphics2D var1, int var2, int var3, int var4, Stroke var5, AffineTransform var6);

    public abstract void project(Camera var1, ViewPanel var2);

    public void move(long l, long l2) {
        this.vx += l;
        this.vy += l2;
        this.propagateMove(l, l2);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void moveTo(long l, long l2) {
        this.propagateMove(l - this.vx, l2 - this.vy);
        this.vx = l;
        this.vy = l2;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void propagateMove(long l, long l2) {
        if (this.stickedGlyphs != null) {
            Enumeration enumeration = this.stickedGlyphs.elements();
            while (enumeration.hasMoreElements()) {
                ((Glyph)enumeration.nextElement()).move(l, l2);
            }
        }
    }

    public abstract float getSize();

    public abstract void sizeTo(float var1);

    public abstract void reSize(float var1);

    public abstract float getOrient();

    public abstract void orientTo(float var1);

    public abstract void initCams(int var1);

    public abstract void addCamera(int var1);

    public abstract void removeCamera(int var1);

    public abstract boolean coordInside(int var1, int var2, int var3);

    public abstract void resetMouseIn(int var1);

    public boolean drawMe(long l, long l2, long l3, long l4, int n) {
        if (this.vx >= l3 && this.vx <= l && this.vy >= l4 && this.vy <= l2) {
            return true;
        }
        return (float)this.vx - this.size <= (float)l && (float)this.vx + this.size >= (float)l3 && (float)this.vy - this.size <= (float)l2 && (float)this.vy + this.size >= (float)l4;
    }

    public abstract boolean fillsView(long var1, long var3, int var5);

    public abstract int mouseInOut(int var1, int var2, int var3);

    public void setColor(Color color) {
        this.color = color;
        this.HSV = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.HSVb = Color.RGBtoHSB(this.borderColor.getRed(), this.borderColor.getGreen(), this.borderColor.getBlue(), new float[3]);
        this.bColor = this.borderColor;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHSVColor(float f, float f2, float f3) {
        this.HSV[0] = f;
        if (this.HSV[0] > 1.0f) {
            this.HSV[0] = 1.0f;
        } else if (this.HSV[0] < 0.0f) {
            this.HSV[0] = 0.0f;
        }
        this.HSV[1] = f2;
        if (this.HSV[1] > 1.0f) {
            this.HSV[1] = 1.0f;
        } else if (this.HSV[1] < 0.0f) {
            this.HSV[1] = 0.0f;
        }
        this.HSV[2] = f3;
        if (this.HSV[2] > 1.0f) {
            this.HSV[2] = 1.0f;
        } else if (this.HSV[2] < 0.0f) {
            this.HSV[2] = 0.0f;
        }
        this.color = Color.getHSBColor(this.HSV[0], this.HSV[1], this.HSV[2]);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addHSVColor(float f, float f2, float f3) {
        this.HSV[0] = this.HSV[0] + f;
        if (this.HSV[0] > 1.0f) {
            this.HSV[0] = 1.0f;
        } else if (this.HSV[0] < 0.0f) {
            this.HSV[0] = 0.0f;
        }
        this.HSV[1] = this.HSV[1] + f2;
        if (this.HSV[1] > 1.0f) {
            this.HSV[1] = 1.0f;
        } else if (this.HSV[1] < 0.0f) {
            this.HSV[1] = 0.0f;
        }
        this.HSV[2] = this.HSV[2] + f3;
        if (this.HSV[2] > 1.0f) {
            this.HSV[2] = 1.0f;
        } else if (this.HSV[2] < 0.0f) {
            this.HSV[2] = 0.0f;
        }
        this.color = Color.getHSBColor(this.HSV[0], this.HSV[1], this.HSV[2]);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHSVbColor(float f, float f2, float f3) {
        this.HSVb[0] = f;
        if (this.HSVb[0] > 1.0f) {
            this.HSVb[0] = 1.0f;
        } else if (this.HSVb[0] < 0.0f) {
            this.HSVb[0] = 0.0f;
        }
        this.HSVb[1] = f2;
        if (this.HSVb[1] > 1.0f) {
            this.HSVb[1] = 1.0f;
        } else if (this.HSVb[1] < 0.0f) {
            this.HSVb[1] = 0.0f;
        }
        this.HSVb[2] = f3;
        if (this.HSVb[2] > 1.0f) {
            this.HSVb[2] = 1.0f;
        } else if (this.HSVb[2] < 0.0f) {
            this.HSVb[2] = 0.0f;
        }
        this.bColor = this.borderColor = Color.getHSBColor(this.HSVb[0], this.HSVb[1], this.HSVb[2]);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addHSVbColor(float f, float f2, float f3) {
        this.HSVb[0] = this.HSVb[0] + f;
        if (this.HSVb[0] > 1.0f) {
            this.HSVb[0] = 1.0f;
        } else if (this.HSVb[0] < 0.0f) {
            this.HSVb[0] = 0.0f;
        }
        this.HSVb[1] = this.HSVb[1] + f2;
        if (this.HSVb[1] > 1.0f) {
            this.HSVb[1] = 1.0f;
        } else if (this.HSVb[1] < 0.0f) {
            this.HSVb[1] = 0.0f;
        }
        this.HSVb[2] = this.HSVb[2] + f3;
        if (this.HSVb[2] > 1.0f) {
            this.HSVb[2] = 1.0f;
        } else if (this.HSVb[2] < 0.0f) {
            this.HSVb[2] = 0.0f;
        }
        this.bColor = this.borderColor = Color.getHSBColor(this.HSVb[0], this.HSVb[1], this.HSVb[2]);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float[] getHSVColor() {
        return this.HSV;
    }

    public float[] getHSVbColor() {
        return this.HSVb;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColorb() {
        return this.borderColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setSpecialFont(Font font) {
        if (font != null) {
            this.font = font;
            fontSize = this.font.getSize2D();
        } else {
            this.font = null;
            fontSize = VirtualSpaceManager.getMainFont().getSize2D();
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return VirtualSpaceManager.getMainFont();
    }

    public boolean usesSpecialFont() {
        return this.font != null;
    }

    public void setFontSizePolicy(int n) {
        this.fontSizePolicy = n;
        if (this.fontSizePolicy < -1 || this.fontSizePolicy > 2) {
            this.fontSizePolicy = 1;
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setTextPos(int n) {
        this.textPos = n;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Long getID() {
        return this.ID;
    }

    public void setID(Long l) {
        this.ID = l;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setVSM(VirtualSpaceManager virtualSpaceManager) {
        this.vsm = virtualSpaceManager;
    }

    public void stick(Glyph glyph) {
        if (this.stickedGlyphs == null) {
            this.stickedGlyphs = new Vector();
            this.stickedGlyphs.add(glyph);
            glyph.stickedTo = this;
        } else if (!this.stickedGlyphs.contains(glyph)) {
            this.stickedGlyphs.add(glyph);
            glyph.stickedTo = this;
        } else if (this.vsm.debugModeON()) {
            System.err.println("Warning: trying to stick Glyph " + glyph + " to Glyph " + this + " while they are already sticked.");
        }
    }

    public void unstick(Glyph glyph) {
        if (this.stickedGlyphs != null) {
            this.stickedGlyphs.remove(glyph);
            if (this.stickedGlyphs.isEmpty()) {
                this.stickedGlyphs = null;
            }
            glyph.stickedTo = null;
        }
    }

    public Vector getStickedGlyphs() {
        if (this.stickedGlyphs == null) {
            return new Vector();
        }
        return this.stickedGlyphs;
    }

    public LongPoint getLocation() {
        return new LongPoint(this.vx, this.vy);
    }

    public String toString() {
        return new String(super.toString() + " Glyph ID " + this.ID + " pos (" + this.vx + "," + this.vy + "," + this.vz + ") " + this.type);
    }
}

