/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JLabel;

public abstract class View {
    Vector cameras;
    public VCursor mouse;
    ViewPanel panel;
    boolean detectMultipleFullFills;
    JLabel statusBar;
    String name;
    VirtualSpaceManager parent;
    boolean notifyMouseMoved = false;

    void initCameras(Vector vector) {
        this.cameras = vector;
        for (int i = 0; i < this.cameras.size(); ++i) {
            ((Camera)vector.elementAt(i)).setOwningView(this);
        }
    }

    public abstract void destroyView();

    public abstract Container getFrame();

    public abstract void requestFocus();

    public void setCursorIcon(int n) {
        this.panel.setAWTCursor(n);
    }

    public void setEventHandler(AppEventHandler appEventHandler) {
        this.panel.setEventHandler(appEventHandler);
    }

    public void setNotifyMouseMoved(boolean bl) {
        this.notifyMouseMoved = bl;
    }

    public boolean getNotifyMouseMoved() {
        return this.notifyMouseMoved;
    }

    public void setStatusBarText(String string) {
        if (this.statusBar != null) {
            if (string.equals("")) {
                this.statusBar.setText(" ");
            } else {
                this.statusBar.setText(string);
            }
        }
    }

    public void setStatusBarFont(Font font) {
        if (this.statusBar != null) {
            this.statusBar.setFont(font);
        }
    }

    public void setStatusBarForeground(Color color) {
        if (this.statusBar != null) {
            this.statusBar.setForeground(color);
        }
    }

    public void setDetectMultiFills(boolean bl) {
        this.detectMultipleFullFills = bl;
    }

    public boolean getDetectMultiFills() {
        return this.detectMultipleFullFills;
    }

    public long[] getVisibleRegion(Camera camera) {
        long[] lArray = new long[4];
        if (this.cameras.contains(camera)) {
            float f = (camera.focal + camera.altitude) / camera.focal;
            lArray[0] = (long)((float)camera.posx - (float)(this.panel.getSize().width / 2) * f);
            lArray[1] = (long)((float)camera.posy + (float)(this.panel.getSize().height / 2) * f);
            lArray[2] = (long)((float)camera.posx + (float)(this.panel.getSize().width / 2) * f);
            lArray[3] = (long)((float)camera.posy - (float)(this.panel.getSize().height / 2) * f);
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        View view = this;
        synchronized (view) {
            BufferedImage bufferedImage2 = this.panel.getImage();
            if (bufferedImage2 != null) {
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(bufferedImage2, null, 0, 0);
            }
        }
        return bufferedImage;
    }

    public void setActiveLayer(int n) {
        this.mouse.resetGlyphsUnderMouseList(((Camera)this.cameras.elementAt((int)n)).parentSpace, ((Camera)this.cameras.elementAt(n)).getIndex());
        this.panel.activeLayer = n;
    }

    public int getActiveLayer() {
        return this.panel.activeLayer;
    }

    public void updateFont() {
        this.panel.updateFont = true;
    }

    public void setAntialiasing(boolean bl) {
        if (bl != this.panel.antialias) {
            this.panel.antialias = bl;
            this.panel.updateAntialias = true;
        }
    }

    public boolean getAntialiasing() {
        return this.panel.antialias;
    }

    public Camera getCameraNumber(int n) {
        if (this.cameras.size() > n) {
            return (Camera)this.cameras.elementAt(n);
        }
        return null;
    }

    public Camera getActiveCamera() {
        return this.panel.cams[this.panel.activeLayer];
    }

    void destroyCamera(Camera camera) {
        block0: for (int i = 0; i < this.panel.cams.length; ++i) {
            if (this.panel.cams[i] != camera) continue;
            this.panel.cams[i] = null;
            if (i != this.panel.activeLayer) break;
            for (int j = 0; j < this.panel.cams.length; ++j) {
                if (this.panel.cams[j] == null) continue;
                this.panel.activeLayer = j;
                break block0;
            }
            break;
        }
        this.cameras.remove(camera);
    }

    public void setBackgroundColor(Color color) {
        this.panel.backColor = color;
    }

    public Color getBackgroundColor() {
        return this.panel.backColor;
    }

    public abstract boolean isSelected();

    public abstract void setTitle(String var1);

    public abstract void setLocation(int var1, int var2);

    public abstract void setSize(int var1, int var2);

    public abstract void setResizable(boolean var1);

    public abstract void setVisible(boolean var1);

    public abstract void toFront();

    public abstract void toBack();

    public void setRefreshRate(int n) {
        this.panel.setRefreshRate(n);
    }

    public int getRefreshRate() {
        return this.panel.getRefreshRate();
    }

    public void setRepaintPolicy(boolean bl) {
        this.panel.alwaysRepaintMe = bl;
        if (bl) {
            this.panel.active = true;
        } else if (!this.isSelected() && !this.panel.inside) {
            this.panel.active = false;
        }
    }

    public void setBlank(Color color) {
        if (color == null) {
            this.panel.blankColor = null;
            this.panel.notBlank = true;
            this.repaintNow();
        } else {
            this.panel.blankColor = color;
            this.panel.notBlank = false;
            this.repaintNow();
        }
    }

    public Color isBlank() {
        if (!this.panel.notBlank) {
            return this.panel.blankColor;
        }
        return null;
    }

    public abstract void goFullScreen(boolean var1, DisplayMode var2);

    public abstract boolean isFullScreen();

    public void setComputeMouseOverListPolicy(boolean bl) {
        this.panel.computeListAtEachRepaint = bl;
    }

    public void activate() {
        this.parent.setActiveView(this);
        this.panel.active = true;
        if (this.panel.evH != null) {
            this.panel.evH.viewActivated(this);
        }
    }

    public void deactivate() {
        if (!this.panel.alwaysRepaintMe && !this.panel.inside) {
            this.panel.active = false;
        }
        if (this.panel.evH != null) {
            this.panel.evH.viewDeactivated(this);
        }
    }

    void iconify() {
        this.panel.active = false;
        if (this.panel.evH != null) {
            this.panel.evH.viewIconified(this);
        }
    }

    void deiconify() {
        this.panel.active = true;
        if (this.panel.evH != null) {
            this.panel.evH.viewDeiconified(this);
        }
    }

    protected void close() {
        if (this.panel.evH != null) {
            this.panel.evH.viewClosing(this);
        }
    }

    void repaintNow() {
        this.panel.repaintNow = true;
        this.panel.newRequest = true;
    }

    public Graphics getGraphicsContext() {
        return this.panel.g2;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

