/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class SwingWorkerParam
implements Runnable {
    private Object value;
    private Thread thread;
    private Vector param;
    private Runnable doFinished;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct(Vector var1);

    public void finished() {
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setValue(this.construct(this.param));
        }
        finally {
            this.threadVar.clear();
        }
        SwingUtilities.invokeLater(this.doFinished);
    }

    public SwingWorkerParam(Vector vector) {
        this.param = vector;
        this.doFinished = new Runnable(){

            public void run() {
                SwingWorkerParam.this.finished();
            }
        };
        Thread thread = new Thread(this);
        this.threadVar = new ThreadVar(thread);
        thread.start();
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

