/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class StdViewPanel
extends ViewPanel
implements Runnable {
    BufferedImage buffImg;

    protected BufferedImage getImage() {
        return this.buffImg;
    }

    public StdViewPanel(Vector vector, View view) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (StdViewPanel.this.isShowing()) {
                    StdViewPanel.this.start();
                } else {
                    StdViewPanel.this.stop();
                }
            }
        });
        this.parent = view;
        this.cams = new Camera[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.cams[i] = (Camera)vector.get(i);
        }
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.start();
        this.setAWTCursor(-1);
        if (this.parent.parent.debug) {
            System.out.println("View refresh time set to " + this.frameTime + "ms");
        }
    }

    public void start() {
        Dimension dimension = this.getSize();
        this.runView = new Thread(this);
        this.runView.setPriority(5);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.getSize().width <= 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep " + interruptedException);
                }
                return;
            }
        }
        Graphics graphics = null;
        Graphics graphics2 = null;
        Dimension dimension = this.getSize();
        while (this.runView == thread) {
            Serializable serializable;
            if (this.notBlank) {
                if (this.active) {
                    if (this.repaintNow) {
                        block86: {
                            try {
                                this.repaintNow = false;
                                this.updateMouseOnly = false;
                                this.d1 = System.currentTimeMillis();
                                serializable = this.getSize();
                                if (serializable.width != dimension.width || serializable.height != dimension.height) {
                                    this.buffImg = null;
                                    if (graphics2 != null) {
                                        graphics2.dispose();
                                        graphics2 = null;
                                    }
                                    if (this.parent.parent.debug) {
                                        System.out.println("Resizing JPanel: (" + dimension.width + "x" + dimension.height + ") -> (" + serializable.width + "x" + serializable.height + ")");
                                    }
                                    dimension = serializable;
                                    this.updateAntialias = true;
                                    this.updateFont = true;
                                }
                                if (this.buffImg == null) {
                                    this.buffImg = (BufferedImage)this.createImage(serializable.width, serializable.height);
                                    this.updateAntialias = true;
                                    this.updateFont = true;
                                }
                                if (graphics2 == null) {
                                    graphics2 = this.buffImg.createGraphics();
                                    this.updateAntialias = true;
                                    this.updateFont = true;
                                }
                                if (this.updateFont) {
                                    graphics2.setFont(VirtualSpaceManager.mainFont);
                                    this.updateFont = false;
                                }
                                if (this.updateAntialias) {
                                    if (this.antialias) {
                                        ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    } else {
                                        ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                                    }
                                    this.updateAntialias = false;
                                }
                                graphics = graphics2;
                                this.standardStroke = ((Graphics2D)graphics).getStroke();
                                this.standardTransform = ((Graphics2D)graphics).getTransform();
                                StdViewPanel stdViewPanel = this;
                                synchronized (stdViewPanel) {
                                    graphics.setPaintMode();
                                    ((Graphics2D)graphics).setBackground(this.backColor);
                                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                                    for (int i = 0; i < this.cams.length; ++i) {
                                        if (this.cams[i] == null || !this.cams[i].enabled || !this.cams[i].eager && !this.cams[i].shouldRepaint()) continue;
                                        this.camIndex = this.cams[i].getIndex();
                                        Vector vector = this.cams[i].parentSpace.drawnList;
                                        synchronized (vector) {
                                            this.cams[i].parentSpace.drawnList.removeAllElements();
                                            this.uncoef = (this.cams[i].focal + this.cams[i].altitude) / this.cams[i].focal;
                                            this.viewW = this.getSize().width;
                                            this.viewH = this.getSize().height;
                                            this.viewWHu = (long)((float)this.cams[i].posx + (float)(this.getSize().width / 2) * this.uncoef);
                                            this.viewHHu = (long)((float)this.cams[i].posy + (float)(this.getSize().height / 2) * this.uncoef);
                                            this.viewWLu = (long)((float)this.cams[i].posx - (float)(this.getSize().width / 2) * this.uncoef);
                                            this.viewHLu = (long)((float)this.cams[i].posy - (float)(this.getSize().height / 2) * this.uncoef);
                                            if (this.parent.detectMultipleFullFills) {
                                                int n;
                                                Enumeration enumeration = this.cams[i].parentSpace.getVisibleGlyphs().elements();
                                                while (enumeration.hasMoreElements()) {
                                                    this.gl = (Glyph)enumeration.nextElement();
                                                    if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                                    this.cams[i].parentSpace.drawnList.add(this.gl);
                                                    this.gl.project(this.cams[i], this);
                                                }
                                                this.drawnGlyphs = this.cams[i].parentSpace.getDrawnGlyphs();
                                                this.beginAt = 0;
                                                for (n = this.drawnGlyphs.size() - 1; n >= 0; --n) {
                                                    if (!((Glyph)this.drawnGlyphs.elementAt(n)).fillsView(this.viewW, this.viewH, this.cams[i].getIndex())) continue;
                                                    this.beginAt = n;
                                                    break;
                                                }
                                                for (n = this.beginAt; n < this.drawnGlyphs.size(); ++n) {
                                                    this.gl = (Glyph)this.drawnGlyphs.elementAt(n);
                                                    if (!this.gl.isVisible()) continue;
                                                    this.gl.draw((Graphics2D)graphics, serializable.width, serializable.height, this.cams[i].getIndex(), this.standardStroke, this.standardTransform);
                                                }
                                            } else {
                                                Enumeration enumeration = this.cams[i].parentSpace.getVisibleGlyphs().elements();
                                                while (enumeration.hasMoreElements()) {
                                                    this.gl = (Glyph)enumeration.nextElement();
                                                    if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                                    Glyph glyph = this.gl;
                                                    synchronized (glyph) {
                                                        this.gl.project(this.cams[i], this);
                                                        if (this.gl.isVisible()) {
                                                            this.gl.draw((Graphics2D)graphics, serializable.width, serializable.height, this.cams[i].getIndex(), this.standardStroke, this.standardTransform);
                                                        }
                                                    }
                                                    this.cams[i].parentSpace.drawnList.add(this.gl);
                                                }
                                            }
                                            continue;
                                        }
                                    }
                                    if (this.inside) {
                                        block85: {
                                            try {
                                                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                                if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                                    this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                                                }
                                            }
                                            catch (NullPointerException nullPointerException) {
                                                if (!this.parent.parent.debug) break block85;
                                                System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                                            }
                                        }
                                        graphics.setColor(this.parent.mouse.color);
                                        if (this.drawDrag) {
                                            graphics.drawLine(this.origDragx, this.origDragy, this.parent.mouse.mx, this.parent.mouse.my);
                                        }
                                        if (this.drawRect) {
                                            graphics.drawRect(Math.min(this.origDragx, this.parent.mouse.mx), Math.min(this.origDragy, this.parent.mouse.my), Math.max(this.origDragx, this.parent.mouse.mx) - Math.min(this.origDragx, this.parent.mouse.mx), Math.max(this.origDragy, this.parent.mouse.my) - Math.min(this.origDragy, this.parent.mouse.my));
                                        }
                                        if (this.drawOval) {
                                            if (this.circleOnly) {
                                                graphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx));
                                            } else {
                                                graphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragy - this.parent.mouse.my), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragy - this.parent.mouse.my));
                                            }
                                        }
                                        if (this.drawVTMcursor) {
                                            StdViewPanel stdViewPanel2 = this;
                                            synchronized (stdViewPanel2) {
                                                graphics.setXORMode(this.backColor);
                                                this.parent.mouse.draw((Graphics2D)graphics);
                                                this.oldX = this.parent.mouse.mx;
                                                this.oldY = this.parent.mouse.my;
                                            }
                                        }
                                    }
                                    if (graphics == graphics2) {
                                        this.repaint();
                                    }
                                    this.d2 = System.currentTimeMillis();
                                    this.timeToSleep = (long)this.frameTime - this.d2 + this.d1;
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (!this.parent.parent.debug) break block86;
                                System.err.println("viewpanel.run (probably due to buffImg.createGraphics()) " + nullPointerException);
                            }
                        }
                        try {
                            Thread.sleep(this.timeToSleep > 10L ? this.timeToSleep : 10L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.parent.parent.debug) {
                                System.err.println("viewpanel.run.runview.sleep2 " + interruptedException);
                            }
                            return;
                        }
                    }
                    if (this.updateMouseOnly) {
                        block87: {
                            this.updateMouseOnly = false;
                            this.d1 = System.currentTimeMillis();
                            try {
                                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                    this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (!this.parent.parent.debug) break block87;
                                System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                            }
                        }
                        if (this.drawVTMcursor) {
                            serializable = this;
                            synchronized (serializable) {
                                block88: {
                                    try {
                                        graphics.setXORMode(this.backColor);
                                        graphics.setColor(this.parent.mouse.color);
                                        graphics.drawLine(this.oldX - 10, this.oldY, this.oldX + 10, this.oldY);
                                        graphics.drawLine(this.oldX, this.oldY - 10, this.oldX, this.oldY + 10);
                                        graphics.drawLine(this.parent.mouse.mx - 10, this.parent.mouse.my, this.parent.mouse.mx + 10, this.parent.mouse.my);
                                        graphics.drawLine(this.parent.mouse.mx, this.parent.mouse.my - 10, this.parent.mouse.mx, this.parent.mouse.my + 10);
                                        this.oldX = this.parent.mouse.mx;
                                        this.oldY = this.parent.mouse.my;
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        if (!this.parent.parent.debug) break block88;
                                        System.err.println("viewpanel.run.runview.drawVTMcursor " + nullPointerException);
                                    }
                                }
                            }
                        }
                        this.repaint();
                        this.d2 = System.currentTimeMillis();
                        this.timeToSleep = (long)this.frameTime - this.d2 + this.d1;
                        try {
                            Thread.sleep(this.timeToSleep > 10L ? this.timeToSleep : 10L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.parent.parent.debug) {
                                System.err.println("viewpanel.run.runview.sleep3 " + interruptedException);
                            }
                            return;
                        }
                    }
                    try {
                        Thread.sleep(this.frameTime + 20);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.parent.parent.debug) {
                            System.err.println("viewpanel.run.runview.sleep4 " + interruptedException);
                        }
                        return;
                    }
                }
                try {
                    Thread.sleep(this.deactiveTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.parent.parent.debug) {
                        System.err.println("viewpanel.run.runview.sleep5 " + interruptedException);
                    }
                    return;
                }
            }
            serializable = this.getSize();
            if (serializable.width != dimension.width || serializable.height != dimension.height) {
                this.buffImg = null;
                if (graphics2 != null) {
                    graphics2.dispose();
                    graphics2 = null;
                }
                if (this.parent.parent.debug) {
                    System.out.println("Resizing JPanel in blank mode: (" + dimension.width + "x" + dimension.height + ") -> (" + serializable.width + "x" + serializable.height + ")");
                }
                dimension = serializable;
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (this.buffImg == null) {
                this.buffImg = (BufferedImage)this.createImage(serializable.width, serializable.height);
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (graphics2 == null) {
                graphics2 = this.buffImg.createGraphics();
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (this.updateFont) {
                graphics2.setFont(VirtualSpaceManager.mainFont);
                this.updateFont = false;
            }
            if (this.updateAntialias) {
                if (this.antialias) {
                    ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                this.updateAntialias = false;
            }
            graphics = graphics2;
            this.standardStroke = ((Graphics2D)graphics).getStroke();
            this.standardTransform = ((Graphics2D)graphics).getTransform();
            graphics.setPaintMode();
            graphics.setColor(this.blankColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.repaint();
            try {
                Thread.sleep(this.deactiveTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep5 " + interruptedException);
                }
                return;
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        StdViewPanel stdViewPanel = this;
        synchronized (stdViewPanel) {
            this.g2 = (Graphics2D)graphics;
            if (this.buffImg != null) {
                this.g2.drawImage(this.buffImg, null, 0, 0);
            }
        }
    }
}

