/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimParams;
import com.xerox.VTM.engine.CAnimation;
import com.xerox.VTM.engine.CTransZoom;
import com.xerox.VTM.engine.CTranslation;
import com.xerox.VTM.engine.CZoom;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.GAnimation;
import com.xerox.VTM.engine.GCbCurveCtrl;
import com.xerox.VTM.engine.GColoration;
import com.xerox.VTM.engine.GColorationPRR;
import com.xerox.VTM.engine.GCurveCtrl;
import com.xerox.VTM.engine.GQdCurveCtrl;
import com.xerox.VTM.engine.GResize;
import com.xerox.VTM.engine.GResizePRR;
import com.xerox.VTM.engine.GRotate;
import com.xerox.VTM.engine.GRotatePRR;
import com.xerox.VTM.engine.GTranslation;
import com.xerox.VTM.engine.GTranslationPRR;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.PolarCoords;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VCbCurve;
import com.xerox.VTM.glyphs.VQdCurve;
import java.util.Hashtable;
import java.util.Vector;
import net.claribole.zvtm.engine.AnimationListener;

public class AnimManager
implements Runnable {
    public static short GL_TRANS_LIN = 0;
    public static short GL_TRANS_PAR = 1;
    public static short GL_TRANS_SIG = (short)2;
    public static short GL_SZ_LIN = (short)3;
    public static short GL_SZ_PAR = (short)4;
    public static short GL_SZ_SIG = (short)5;
    public static short GL_ROT_LIN = (short)6;
    public static short GL_ROT_PAR = (short)7;
    public static short GL_ROT_SIG = (short)8;
    public static short GL_COLOR_SIG = (short)9;
    public static short GL_CP_TRANS_LIN = 0;
    public static short GL_CP_TRANS_PAR = 1;
    public static short GL_CP_TRANS_SIG = (short)2;
    public static short CA_TRANS_LIN = 0;
    public static short CA_TRANS_PAR = 1;
    public static short CA_TRANS_SIG = (short)2;
    public static short CA_ALT_LIN = (short)3;
    public static short CA_ALT_PAR = (short)4;
    public static short CA_ALT_SIG = (short)5;
    public static short CA_ALT_TRANS_SIG = (short)6;
    public static String GL_TRANS = "pos";
    public static String GL_SZ = "sz";
    public static String GL_ROT = "or";
    public static String GL_COLOR = "col";
    public static String GL_CTRL = "ctrl";
    public static String CA_TRANS = "pos";
    public static String CA_ALT = "sz";
    public static String CA_BOTH = "both";
    VirtualSpaceManager vsm;
    Thread runAnim;
    boolean started = false;
    int frameTime;
    boolean shouldRepaint = false;
    int sigFactor = 4;
    Vector animCameraBag;
    Vector animGlyphBag;
    Hashtable pendingGAnims;
    Hashtable pendingCAnims;
    Hashtable animatedGlyphs;
    Hashtable animatedCameras;
    public long Xspeed;
    public long Yspeed;
    public long Aspeed;
    Camera activeCam;
    AnimationListener animListener = null;
    private boolean notifyCameraAnim = false;

    public AnimManager(VirtualSpaceManager virtualSpaceManager) {
        this.vsm = virtualSpaceManager;
        this.animCameraBag = new Vector();
        this.animGlyphBag = new Vector();
        this.pendingGAnims = new Hashtable();
        this.pendingCAnims = new Hashtable();
        this.animatedGlyphs = new Hashtable();
        this.animatedCameras = new Hashtable();
        this.frameTime = 20;
        this.Xspeed = 0L;
        this.Yspeed = 0L;
        this.Aspeed = 0L;
    }

    public void start() {
        this.started = true;
        this.runAnim = new Thread(this);
        this.runAnim.setPriority(5);
        this.runAnim.start();
    }

    public synchronized void stop() {
        this.started = false;
        this.runAnim = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.vsm.activeView == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                if (this.vsm.debug) {
                    System.err.println("animmanager.run.sleep0 " + interruptedException);
                }
                return;
            }
        }
        while (this.runAnim == thread) {
            int n;
            block24: {
                try {
                    this.activeCam = this.vsm.getActiveCamera();
                    if (this.Xspeed != 0L) {
                        this.activeCam.posx -= this.Xspeed;
                        this.shouldRepaint = true;
                        this.notifyCameraAnim = true;
                    }
                    if (this.Yspeed != 0L) {
                        this.activeCam.posy -= this.Yspeed;
                        this.shouldRepaint = true;
                        this.notifyCameraAnim = true;
                    }
                    if (this.Aspeed != 0L) {
                        this.activeCam.altitudeOffset(-this.Aspeed);
                        this.shouldRepaint = true;
                        this.notifyCameraAnim = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (!this.vsm.debug) break block24;
                    System.err.println("animmanager.run.activecam " + nullPointerException);
                }
            }
            for (n = 0; n < this.animCameraBag.size(); ++n) {
                block25: {
                    CAnimation cAnimation = (CAnimation)this.animCameraBag.get(n);
                    try {
                        cAnimation.animate();
                    }
                    catch (NullPointerException nullPointerException) {
                        if (!this.vsm.debug) break block25;
                        System.err.println("animmanager.run.camera anim stopped " + nullPointerException);
                    }
                }
                this.shouldRepaint = true;
                this.notifyCameraAnim = true;
            }
            for (n = 0; n < this.animGlyphBag.size(); ++n) {
                GAnimation gAnimation = (GAnimation)this.animGlyphBag.get(n);
                try {
                    if (!gAnimation.animate()) continue;
                    this.shouldRepaint = true;
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    if (!this.vsm.debug) continue;
                    System.err.println("animmanager.run.glyph anim stopped " + nullPointerException);
                }
            }
            if (this.shouldRepaint) {
                this.vsm.repaintNow();
                this.shouldRepaint = false;
            }
            if (this.animListener != null && this.notifyCameraAnim) {
                AnimManager animManager = this;
                synchronized (animManager) {
                    this.animListener.cameraMoved();
                    this.notifyCameraAnim = false;
                }
            }
            try {
                Thread.sleep(this.frameTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.vsm.debug) {
                    System.err.println("animmanager.run.sleep " + interruptedException);
                }
                return;
            }
        }
    }

    public void setAnimationListener(AnimationListener animationListener) {
        this.animListener = animationListener;
    }

    public AnimationListener getAnimationListener() {
        return this.animListener;
    }

    private void newGlyphAnim(long l, int n, Object object, Long l2, int n2) {
        Glyph glyph = this.vsm.getGlyph(l2);
        switch (n) {
            case 0: {
                Object object2;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[0] == 1) {
                    this.putAsPendingGAnimation(l2, GL_TRANS, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[0] = 1;
                } else {
                    object2 = new int[]{0, 0, 0, 0};
                    object2[0] = true;
                    this.animatedGlyphs.put(l2, object2);
                }
                object2 = n2 == 0 ? new GTranslation(glyph, this, l) : new GTranslationPRR(glyph, this, l, n2);
                long l3 = glyph.vx;
                long l4 = glyph.vy;
                long l5 = ((LongPoint)object).x;
                long l6 = ((LongPoint)object).y;
                double d = Math.round(l / (long)this.frameTime);
                double d2 = (double)l5 / d;
                double d3 = (double)l6 / d;
                ((GTranslation)object2).steps = new LongPoint[(int)d];
                int n3 = 0;
                while ((double)n3 < d - 1.0) {
                    ((GTranslation)object2).steps[n3] = new LongPoint((long)((double)l3 + (double)n3 * d2), (long)((double)l4 + (double)n3 * d3));
                    ++n3;
                }
                ((GTranslation)object2).steps[(int)d - 1] = new LongPoint(l3 + l5, l4 + l6);
                this.animGlyphBag.add(object2);
                ((GTranslation)object2).start();
                break;
            }
            case 1: {
                Object object3;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[0] == 1) {
                    this.putAsPendingGAnimation(l2, GL_TRANS, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[0] = 1;
                } else {
                    object3 = new int[]{0, 0, 0, 0};
                    object3[0] = true;
                    this.animatedGlyphs.put(l2, object3);
                }
                object3 = n2 == 0 ? new GTranslation(glyph, this, l) : new GTranslationPRR(glyph, this, l, n2);
                long l7 = glyph.vx;
                long l8 = glyph.vy;
                long l9 = ((LongPoint)object).x;
                long l10 = ((LongPoint)object).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((GTranslation)object3).steps = new LongPoint[(int)d];
                int n4 = 0;
                while ((double)n4 < d - 1.0) {
                    double d4 = Math.pow((double)(n4 + 1) / d, 4.0);
                    long l11 = Math.round((double)l9 * d4);
                    long l12 = Math.round((double)l10 * d4);
                    ((GTranslation)object3).steps[n4++] = new LongPoint(l7 + l11, l8 + l12);
                }
                ((GTranslation)object3).steps[(int)d - 1] = new LongPoint(l7 + l9, l8 + l10);
                this.animGlyphBag.add(object3);
                ((GTranslation)object3).start();
                break;
            }
            case 2: {
                Object object4;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[0] == 1) {
                    this.putAsPendingGAnimation(l2, GL_TRANS, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[0] = 1;
                } else {
                    object4 = new int[]{0, 0, 0, 0};
                    object4[0] = true;
                    this.animatedGlyphs.put(l2, object4);
                }
                object4 = n2 == 0 ? new GTranslation(glyph, this, l) : new GTranslationPRR(glyph, this, l, n2);
                long l13 = glyph.vx;
                long l14 = glyph.vy;
                long l15 = ((LongPoint)object).x;
                long l16 = ((LongPoint)object).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((GTranslation)object4).steps = new LongPoint[(int)d];
                int n5 = 0;
                while ((double)n5 < d - 1.0) {
                    double d5 = this.computeSigmoid(this.sigFactor, (double)(n5 + 1) / d);
                    long l17 = Math.round((double)l15 * d5);
                    long l18 = Math.round((double)l16 * d5);
                    ((GTranslation)object4).steps[n5++] = new LongPoint(l13 + l17, l14 + l18);
                }
                ((GTranslation)object4).steps[(int)d - 1] = new LongPoint(l13 + l15, l14 + l16);
                this.animGlyphBag.add(object4);
                ((GTranslation)object4).start();
                break;
            }
            case 3: {
                Object object5;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[1] == 1) {
                    this.putAsPendingGAnimation(l2, GL_SZ, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[1] = 1;
                } else {
                    object5 = new int[]{0, 0, 0, 0};
                    object5[1] = true;
                    this.animatedGlyphs.put(l2, object5);
                }
                object5 = n2 == 0 ? new GResize(glyph, this, l) : new GResizePRR(glyph, this, l, n2);
                float f = glyph.getSize();
                float f2 = ((Float)object).floatValue() * f;
                float f3 = Math.round(l / (long)this.frameTime);
                float f4 = (f2 - f) / f3;
                ((GResize)object5).steps = new float[(int)f3];
                int n6 = 0;
                while ((float)n6 < f3 - 1.0f) {
                    ((GResize)object5).steps[n6] = f + (float)n6 * f4;
                    ++n6;
                }
                ((GResize)object5).steps[(int)f3 - 1] = f2;
                this.animGlyphBag.add(object5);
                ((GResize)object5).start();
                break;
            }
            case 4: {
                Object object6;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[1] == 1) {
                    this.putAsPendingGAnimation(l2, GL_SZ, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[1] = 1;
                } else {
                    object6 = new int[]{0, 0, 0, 0};
                    object6[1] = true;
                    this.animatedGlyphs.put(l2, object6);
                }
                object6 = n2 == 0 ? new GResize(glyph, this, l) : new GResizePRR(glyph, this, l, n2);
                float f = glyph.getSize();
                float f5 = ((Float)object).floatValue() * f;
                float f6 = Math.round(l / (long)this.frameTime);
                ((GResize)object6).steps = new float[(int)f6];
                int n7 = 0;
                while ((float)n7 < f6 - 1.0f) {
                    float f7 = (float)Math.pow((float)(n7 + 1) / f6, 4.0);
                    float f8 = (f5 - f) * f7;
                    ((GResize)object6).steps[n7] = f + f8;
                    ++n7;
                }
                ((GResize)object6).steps[(int)f6 - 1] = f5;
                this.animGlyphBag.add(object6);
                ((GResize)object6).start();
                break;
            }
            case 5: {
                Object object7;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[1] == 1) {
                    this.putAsPendingGAnimation(l2, GL_SZ, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[1] = 1;
                } else {
                    object7 = new int[]{0, 0, 0, 0};
                    object7[1] = true;
                    this.animatedGlyphs.put(l2, object7);
                }
                object7 = n2 == 0 ? new GResize(glyph, this, l) : new GResizePRR(glyph, this, l, n2);
                float f = glyph.getSize();
                float f9 = ((Float)object).floatValue() * f;
                float f10 = Math.round(l / (long)this.frameTime);
                ((GResize)object7).steps = new float[(int)f10];
                int n8 = 0;
                while ((float)n8 < f10 - 1.0f) {
                    float f11 = (float)this.computeSigmoid(this.sigFactor, (float)(n8 + 1) / f10);
                    float f12 = (f9 - f) * f11;
                    ((GResize)object7).steps[n8] = f + f12;
                    ++n8;
                }
                ((GResize)object7).steps[(int)f10 - 1] = f9;
                this.animGlyphBag.add(object7);
                ((GResize)object7).start();
                break;
            }
            case 6: {
                Object object8;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[2] == 1) {
                    this.putAsPendingGAnimation(l2, GL_ROT, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[2] = 1;
                } else {
                    object8 = new int[]{0, 0, 0, 0};
                    object8[2] = true;
                    this.animatedGlyphs.put(l2, object8);
                }
                object8 = n2 == 0 ? new GRotate(glyph, this, l) : new GRotatePRR(glyph, this, l, n2);
                float f = glyph.getOrient();
                float f13 = ((Float)object).floatValue() + f;
                float f14 = Math.round(l / (long)this.frameTime);
                float f15 = (f13 - f) / f14;
                ((GRotate)object8).steps = new float[(int)f14];
                int n9 = 0;
                while ((float)n9 < f14 - 1.0f) {
                    ((GRotate)object8).steps[n9] = f + (float)n9 * f15;
                    ++n9;
                }
                if ((double)Math.abs(f13) >= Math.PI * 2) {
                    f13 %= (float)Math.PI * 2;
                }
                ((GRotate)object8).steps[(int)f14 - 1] = f13;
                this.animGlyphBag.add(object8);
                ((GRotate)object8).start();
                break;
            }
            case 7: {
                Object object9;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[2] == 1) {
                    this.putAsPendingGAnimation(l2, GL_ROT, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[2] = 1;
                } else {
                    object9 = new int[]{0, 0, 0, 0};
                    object9[2] = true;
                    this.animatedGlyphs.put(l2, object9);
                }
                object9 = n2 == 0 ? new GRotate(glyph, this, l) : new GRotatePRR(glyph, this, l, n2);
                float f = glyph.getOrient();
                float f16 = ((Float)object).floatValue() + f;
                float f17 = Math.round(l / (long)this.frameTime);
                ((GRotate)object9).steps = new float[(int)f17];
                int n10 = 0;
                while ((float)n10 < f17 - 1.0f) {
                    float f18 = (float)Math.pow((float)(n10 + 1) / f17, 4.0);
                    float f19 = (f16 - f) * f18;
                    ((GRotate)object9).steps[n10] = f + f19;
                    ++n10;
                }
                if ((double)Math.abs(f16) >= Math.PI * 2) {
                    f16 %= (float)Math.PI * 2;
                }
                ((GRotate)object9).steps[(int)f17 - 1] = f16;
                this.animGlyphBag.add(object9);
                ((GRotate)object9).start();
                break;
            }
            case 8: {
                Object object10;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[2] == 1) {
                    this.putAsPendingGAnimation(l2, GL_ROT, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[2] = 1;
                } else {
                    object10 = new int[]{0, 0, 0, 0};
                    object10[2] = true;
                    this.animatedGlyphs.put(l2, object10);
                }
                object10 = n2 == 0 ? new GRotate(glyph, this, l) : new GRotatePRR(glyph, this, l, n2);
                float f = glyph.getOrient();
                float f20 = ((Float)object).floatValue() + f;
                float f21 = Math.round(l / (long)this.frameTime);
                ((GRotate)object10).steps = new float[(int)f21];
                int n11 = 0;
                while ((float)n11 < f21 - 1.0f) {
                    float f22 = (float)this.computeSigmoid(this.sigFactor, (float)(n11 + 1) / f21);
                    float f23 = (f20 - f) * f22;
                    ((GRotate)object10).steps[n11] = f + f23;
                    ++n11;
                }
                if ((double)Math.abs(f20) >= Math.PI * 2) {
                    f20 %= (float)Math.PI * 2;
                }
                ((GRotate)object10).steps[(int)f21 - 1] = f20;
                this.animGlyphBag.add(object10);
                ((GRotate)object10).start();
                break;
            }
            case 9: {
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[3] == 1) {
                    this.putAsPendingGAnimation(l2, GL_COLOR, l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[3] = 1;
                } else {
                    int[] nArray = new int[]{0, 0, 0, 0};
                    nArray[3] = 1;
                    this.animatedGlyphs.put(l2, nArray);
                }
                boolean bl = (Boolean)((Vector)object).elementAt(3);
                GColoration gColoration = n2 == 0 ? new GColoration(glyph, this, l, bl) : new GColorationPRR(glyph, this, l, bl, n2);
                float[] fArray = !bl ? glyph.getHSVColor() : glyph.getHSVbColor();
                float[] fArray2 = new float[3];
                for (int i = 0; i < 3; ++i) {
                    fArray2[i] = ((Float)((Vector)object).elementAt(i)).floatValue();
                }
                double d = Math.round(l / (long)this.frameTime);
                double d6 = (double)fArray2[0] / d;
                double d7 = (double)fArray2[1] / d;
                double d8 = (double)fArray2[2] / d;
                gColoration.steps = new float[(int)d][3];
                int n12 = 0;
                while ((double)n12 < d - 1.0) {
                    gColoration.steps[n12][0] = fArray[0] + (float)n12 * (float)d6;
                    gColoration.steps[n12][1] = fArray[1] + (float)n12 * (float)d7;
                    gColoration.steps[n12][2] = fArray[2] + (float)n12 * (float)d8;
                    ++n12;
                }
                gColoration.steps[(int)d - 1][0] = fArray[0] + fArray2[0];
                gColoration.steps[(int)d - 1][1] = fArray[1] + fArray2[1];
                gColoration.steps[(int)d - 1][2] = fArray[2] + fArray2[2];
                this.animGlyphBag.add(gColoration);
                gColoration.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createGlyphAnimation : unknown animation type");
            }
        }
    }

    public void createGlyphAnimation(long l, int n, Object object, Long l2) {
        this.newGlyphAnim(l, n, object, l2, 0);
    }

    public void createGlyphAnimation(long l, int n, int n2, Object object, Long l2) {
        this.newGlyphAnim(l, n2, object, l2, n);
    }

    private void putAsPendingGAnimation(Long l, String string, long l2, int n, Object object) {
        if (this.pendingGAnims.containsKey(l)) {
            Hashtable hashtable = (Hashtable)this.pendingGAnims.get(l);
            Vector vector = hashtable.containsKey(string) ? (Vector)hashtable.get(string) : new Vector();
            vector.add(new AnimParams(l2, n, object));
            hashtable.put(string, vector);
        } else {
            Vector<AnimParams> vector = new Vector<AnimParams>();
            vector.add(new AnimParams(l2, n, object));
            Hashtable<String, Vector<AnimParams>> hashtable = new Hashtable<String, Vector<AnimParams>>();
            hashtable.put(string, vector);
            this.pendingGAnims.put(l, hashtable);
        }
    }

    synchronized void killGAnim(GAnimation gAnimation, String string) {
        Object object;
        Long l = gAnimation.target.getID();
        this.animGlyphBag.remove(gAnimation);
        if (this.animatedGlyphs.containsKey(l)) {
            object = (int[])this.animatedGlyphs.get(l);
            if (string == GL_TRANS) {
                object[0] = 0;
            } else if (string == GL_SZ) {
                object[1] = false;
            } else if (string == GL_ROT) {
                object[2] = false;
            } else if (string == GL_COLOR) {
                object[3] = false;
            }
            if (this.allValuesEqualZero((int[])object)) {
                this.animatedGlyphs.remove(l);
            }
        }
        if (this.pendingGAnims.containsKey(l) && ((Hashtable)(object = (Object)((Hashtable)this.pendingGAnims.get(l)))).containsKey(string)) {
            Vector vector = (Vector)((Hashtable)object).get(string);
            AnimParams animParams = (AnimParams)vector.elementAt(0);
            vector.removeElementAt(0);
            if (vector.isEmpty()) {
                ((Hashtable)object).remove(string);
            }
            this.createGlyphAnimation(animParams.duration, animParams.type, animParams.data, l);
            if (((Hashtable)object).isEmpty()) {
                this.pendingGAnims.remove(l);
            }
        }
    }

    public void interruptGlyphAnimation(Glyph glyph, String string, boolean bl, boolean bl2) {
        GAnimation gAnimation = null;
        for (int i = 0; i < this.animGlyphBag.size(); ++i) {
            GAnimation gAnimation2 = (GAnimation)this.animGlyphBag.elementAt(i);
            if (gAnimation2.target != glyph || gAnimation2.type != string) continue;
            gAnimation = gAnimation2;
            break;
        }
        if (gAnimation != null) {
            if (bl) {
                Hashtable hashtable;
                if (bl2) {
                    gAnimation.conclude();
                }
                if (this.pendingGAnims.containsKey(glyph.getID()) && (hashtable = (Hashtable)this.pendingGAnims.get(glyph.getID())).containsKey(string)) {
                    hashtable.remove(string);
                    if (hashtable.isEmpty()) {
                        this.pendingGAnims.remove(glyph.getID());
                    }
                }
            } else if (bl2) {
                gAnimation.conclude();
            }
            if (string == GL_CTRL) {
                this.killCurveAnim((GCurveCtrl)gAnimation);
            } else {
                this.killGAnim(gAnimation, string);
            }
        }
    }

    public void createQdCurveCtrlPtAnimation(long l, int n, Object object, Long l2) {
        Glyph glyph = this.vsm.getGlyph(l2);
        if (glyph instanceof VQdCurve) {
            if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2)).length < 5) {
                this.animatedGlyphs.put(l2, this.addElementsToIntArray((int[])this.animatedGlyphs.get(l2), 1));
            }
            if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[4] == 1) {
                this.putAsPendingGAnimation(l2, GL_CTRL, l, n, object);
            } else {
                Object object2;
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[4] = 1;
                } else {
                    object2 = new int[]{0, 0, 0, 0, 0};
                    object2[4] = true;
                    this.animatedGlyphs.put(l2, object2);
                }
                object2 = new GQdCurveCtrl((VQdCurve)glyph, this, l);
                long l3 = ((VQdCurve)glyph).getCtrlPointRadius();
                float f = ((VQdCurve)glyph).getCtrlPointAngle();
                long l4 = ((PolarCoords)object).r;
                float f2 = ((PolarCoords)object).theta;
                double d = Math.round(l / (long)this.frameTime);
                ((GQdCurveCtrl)object2).steps = new PolarCoords[(int)d];
                switch (n) {
                    case 0: {
                        double d2 = (double)l4 / d;
                        double d3 = (double)f2 / d;
                        int n2 = 0;
                        while ((double)n2 < d - 1.0) {
                            ((GQdCurveCtrl)object2).steps[n2] = new PolarCoords((long)((double)l3 + (double)n2 * d2), (float)((double)f + (double)n2 * d3));
                            ++n2;
                        }
                        ((GQdCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l4, f + f2);
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 1: {
                        int n3 = 0;
                        while ((double)n3 < d - 1.0) {
                            double d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                            ((GQdCurveCtrl)object2).steps[n3++] = new PolarCoords(l3 + Math.round((double)l4 * d4), (float)((double)f + (double)f2 * d4));
                        }
                        ((GQdCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l4, f + f2);
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        while ((double)n4 < d - 1.0) {
                            double d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                            ((GQdCurveCtrl)object2).steps[n4++] = new PolarCoords(l3 + Math.round((double)l4 * d5), (float)((double)f + (double)f2 * d5));
                        }
                        ((GQdCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l4, f + f2);
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createQdCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createQdCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    public void createCbCurveCtrlPtAnimation(long l, int n, Object object, Long l2) {
        Glyph glyph = this.vsm.getGlyph(l2);
        if (glyph instanceof VCbCurve) {
            if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2)).length < 6) {
                this.animatedGlyphs.put(l2, this.addElementsToIntArray((int[])this.animatedGlyphs.get(l2), 2));
            }
            if (this.animatedGlyphs.containsKey(l2) && (((int[])this.animatedGlyphs.get(l2))[4] == 1 || ((int[])this.animatedGlyphs.get(l2))[5] == 1)) {
                this.putAsPendingGAnimation(l2, GL_CTRL, l, n, object);
            } else {
                Object object2;
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[4] = 1;
                } else {
                    object2 = new int[]{0, 0, 0, 0, 0};
                    object2[4] = true;
                    this.animatedGlyphs.put(l2, object2);
                }
                object2 = new GCbCurveCtrl((VCbCurve)glyph, this, l);
                long l3 = ((VCbCurve)glyph).getCtrlPointRadius1();
                float f = ((VCbCurve)glyph).getCtrlPointAngle1();
                long l4 = ((VCbCurve)glyph).getCtrlPointRadius2();
                float f2 = ((VCbCurve)glyph).getCtrlPointAngle2();
                long l5 = ((PolarCoords)((Vector)object).elementAt((int)0)).r;
                float f3 = ((PolarCoords)((Vector)object).elementAt((int)0)).theta;
                long l6 = ((PolarCoords)((Vector)object).elementAt((int)1)).r;
                float f4 = ((PolarCoords)((Vector)object).elementAt((int)1)).theta;
                double d = Math.round(l / (long)this.frameTime);
                switch (n) {
                    case 0: {
                        int n2;
                        double d2;
                        double d3;
                        if (l5 != 0L || f3 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps = new PolarCoords[(int)d];
                            d3 = (double)l5 / d;
                            d2 = (double)f3 / d;
                            n2 = 0;
                            while ((double)n2 < d - 1.0) {
                                ((GCbCurveCtrl)object2).steps[n2] = new PolarCoords((long)((double)l3 + (double)n2 * d3), (float)((double)f + (double)n2 * d2));
                                ++n2;
                            }
                            ((GCbCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l5, f + f3);
                        } else {
                            ((GCbCurveCtrl)object2).steps = null;
                        }
                        if (l6 != 0L || f4 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps2 = new PolarCoords[(int)d];
                            d3 = (double)l6 / d;
                            d2 = (double)f4 / d;
                            n2 = 0;
                            while ((double)n2 < d - 1.0) {
                                ((GCbCurveCtrl)object2).steps2[n2] = new PolarCoords((long)((double)l4 + (double)n2 * d3), (float)((double)f2 + (double)n2 * d2));
                                ++n2;
                            }
                            ((GCbCurveCtrl)object2).steps2[(int)d - 1] = new PolarCoords(l4 + l6, f2 + f4);
                        } else {
                            ((GCbCurveCtrl)object2).steps2 = null;
                        }
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 1: {
                        double d4;
                        int n3;
                        if (l5 != 0L || f3 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps = new PolarCoords[(int)d];
                            n3 = 0;
                            while ((double)n3 < d - 1.0) {
                                d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                                ((GCbCurveCtrl)object2).steps[n3++] = new PolarCoords(l3 + Math.round((double)l5 * d4), f + (float)((double)f3 * d4));
                            }
                            ((GCbCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l5, f + f3);
                        } else {
                            ((GCbCurveCtrl)object2).steps = null;
                        }
                        if (l6 != 0L || f4 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps2 = new PolarCoords[(int)d];
                            n3 = 0;
                            while ((double)n3 < d - 1.0) {
                                d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                                ((GCbCurveCtrl)object2).steps2[n3++] = new PolarCoords(l4 + Math.round((double)l6 * d4), (float)((double)f2 + (double)f4 * d4));
                            }
                            ((GCbCurveCtrl)object2).steps2[(int)d - 1] = new PolarCoords(l4 + l6, f2 + f4);
                        } else {
                            ((GCbCurveCtrl)object2).steps2 = null;
                        }
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 2: {
                        double d5;
                        int n4;
                        if (l5 != 0L || f3 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps = new PolarCoords[(int)d];
                            n4 = 0;
                            while ((double)n4 < d - 1.0) {
                                d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                                ((GCbCurveCtrl)object2).steps[n4++] = new PolarCoords(l3 + Math.round((double)l5 * d5), (float)((double)f + (double)f3 * d5));
                            }
                            ((GCbCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l5, f + f3);
                        } else {
                            ((GCbCurveCtrl)object2).steps = null;
                        }
                        if (l6 != 0L || f4 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps2 = new PolarCoords[(int)d];
                            n4 = 0;
                            while ((double)n4 < d - 1.0) {
                                d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                                ((GCbCurveCtrl)object2).steps2[n4++] = new PolarCoords(l4 + Math.round((double)l6 * d5), (float)((double)f2 + (double)f4 * d5));
                            }
                            ((GCbCurveCtrl)object2).steps2[(int)d - 1] = new PolarCoords(l4 + l6, f2 + f4);
                        } else {
                            ((GCbCurveCtrl)object2).steps2 = null;
                        }
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    void killCurveAnim(GCurveCtrl gCurveCtrl) {
        Object object;
        Long l = gCurveCtrl.target.getID();
        this.animGlyphBag.remove(gCurveCtrl);
        if (this.animatedGlyphs.containsKey(l)) {
            object = (int[])this.animatedGlyphs.get(l);
            object[4] = 0;
            if (this.allValuesEqualZero((int[])object)) {
                this.animatedGlyphs.remove(l);
            }
        }
        if (this.pendingGAnims.containsKey(l) && ((Hashtable)(object = (Object)((Hashtable)this.pendingGAnims.get(l)))).containsKey(GL_CTRL)) {
            Glyph glyph;
            Vector vector = (Vector)((Hashtable)object).get(GL_CTRL);
            AnimParams animParams = (AnimParams)vector.elementAt(0);
            vector.removeElementAt(0);
            if (vector.isEmpty()) {
                ((Hashtable)object).remove(GL_CTRL);
            }
            if ((glyph = this.vsm.getGlyph(l)) instanceof VQdCurve) {
                this.createQdCurveCtrlPtAnimation(animParams.duration, animParams.type, animParams.data, l);
            } else if (glyph instanceof VCbCurve) {
                this.createCbCurveCtrlPtAnimation(animParams.duration, animParams.type, animParams.data, l);
            }
        }
    }

    public void createCameraAnimation(long l, int n, Object object, Integer n2) {
        Camera camera = this.vsm.getCamera(n2);
        switch (n) {
            case 0: {
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[0] == 1) {
                    this.putAsPendingCAnimation(n2, CA_TRANS, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                } else {
                    int[] nArray = new int[]{1, 0};
                    this.animatedCameras.put(n2, nArray);
                }
                double d = Math.round(l / (long)this.frameTime);
                if (!(d > 0.0)) break;
                CTranslation cTranslation = new CTranslation(camera, this, l);
                long l2 = camera.posx;
                long l3 = camera.posy;
                long l4 = ((LongPoint)object).x;
                long l5 = ((LongPoint)object).y;
                double d2 = (double)l4 / d;
                double d3 = (double)l5 / d;
                cTranslation.steps = new LongPoint[(int)d];
                int n3 = 0;
                while ((double)n3 < d - 1.0) {
                    cTranslation.steps[n3] = new LongPoint((long)((double)l2 + (double)n3 * d2), (long)((double)l3 + (double)n3 * d3));
                    ++n3;
                }
                cTranslation.steps[(int)d - 1] = new LongPoint(l2 + l4, l3 + l5);
                this.animCameraBag.add(cTranslation);
                cTranslation.start();
                break;
            }
            case 1: {
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[0] == 1) {
                    this.putAsPendingCAnimation(n2, CA_TRANS, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                } else {
                    int[] nArray = new int[]{1, 0};
                    this.animatedCameras.put(n2, nArray);
                }
                double d = Math.round((double)(l / (long)this.frameTime));
                if (!(d > 0.0)) break;
                CTranslation cTranslation = new CTranslation(camera, this, l);
                long l6 = camera.posx;
                long l7 = camera.posy;
                long l8 = ((LongPoint)object).x;
                long l9 = ((LongPoint)object).y;
                cTranslation.steps = new LongPoint[(int)d];
                int n4 = 0;
                while ((double)n4 < d - 1.0) {
                    double d4 = Math.pow((double)(n4 + 1) / d, 4.0);
                    long l10 = Math.round((double)l8 * d4);
                    long l11 = Math.round((double)l9 * d4);
                    cTranslation.steps[n4++] = new LongPoint(l6 + l10, l7 + l11);
                }
                cTranslation.steps[(int)d - 1] = new LongPoint(l6 + l8, l7 + l9);
                this.animCameraBag.add(cTranslation);
                cTranslation.start();
                break;
            }
            case 2: {
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[0] == 1) {
                    this.putAsPendingCAnimation(n2, CA_TRANS, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                } else {
                    int[] nArray = new int[]{1, 0};
                    this.animatedCameras.put(n2, nArray);
                }
                double d = Math.round((double)(l / (long)this.frameTime));
                if (!(d > 0.0)) break;
                CTranslation cTranslation = new CTranslation(camera, this, l);
                long l12 = camera.posx;
                long l13 = camera.posy;
                long l14 = ((LongPoint)object).x;
                long l15 = ((LongPoint)object).y;
                cTranslation.steps = new LongPoint[(int)d];
                int n5 = 0;
                while ((double)n5 < d - 1.0) {
                    double d5 = this.computeSigmoid(this.sigFactor, (double)(n5 + 1) / d);
                    long l16 = Math.round((double)l14 * d5);
                    long l17 = Math.round((double)l15 * d5);
                    cTranslation.steps[n5++] = new LongPoint(l12 + l16, l13 + l17);
                }
                cTranslation.steps[(int)d - 1] = new LongPoint(l12 + l14, l13 + l15);
                this.animCameraBag.add(cTranslation);
                cTranslation.start();
                break;
            }
            case 3: {
                float f;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[1] == 1) {
                    this.putAsPendingCAnimation(n2, CA_ALT, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    int[] nArray = new int[]{0, 1};
                    this.animatedCameras.put(n2, nArray);
                }
                int n6 = Math.round(l / (long)this.frameTime);
                if (n6 <= 0) break;
                CZoom cZoom = new CZoom(camera, this, l);
                float f2 = camera.altitude;
                float f3 = ((Float)object).floatValue();
                double d = f3 / (float)n6;
                cZoom.steps = new float[n6];
                for (int i = 0; i < n6 - 1; ++i) {
                    f = (float)((double)f2 + (double)i * d);
                    if (f < (float)this.vsm.zoomFloor) {
                        f = this.vsm.zoomFloor;
                    }
                    cZoom.steps[i] = f;
                }
                f = f2 + f3;
                if (f < (float)this.vsm.zoomFloor) {
                    f = this.vsm.zoomFloor;
                }
                cZoom.steps[n6 - 1] = f;
                this.animCameraBag.add(cZoom);
                cZoom.start();
                break;
            }
            case 4: {
                float f;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[1] == 1) {
                    this.putAsPendingCAnimation(n2, CA_ALT, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    int[] nArray = new int[]{0, 1};
                    this.animatedCameras.put(n2, nArray);
                }
                double d = Math.round((double)(l / (long)this.frameTime));
                if (!(d > 0.0)) break;
                CZoom cZoom = new CZoom(camera, this, l);
                float f4 = camera.altitude;
                float f5 = ((Float)object).floatValue();
                cZoom.steps = new float[(int)d];
                int n7 = 0;
                while ((double)n7 < d - 1.0) {
                    double d6 = Math.pow((double)(n7 + 1) / d, 4.0);
                    float f6 = f5 * (float)d6;
                    f = f4 + f6;
                    if (f < (float)this.vsm.zoomFloor) {
                        f = this.vsm.zoomFloor;
                    }
                    cZoom.steps[n7++] = f;
                }
                f = f4 + f5;
                if (f < (float)this.vsm.zoomFloor) {
                    f = this.vsm.zoomFloor;
                }
                cZoom.steps[(int)d - 1] = f;
                this.animCameraBag.add(cZoom);
                cZoom.start();
                break;
            }
            case 5: {
                float f;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[1] == 1) {
                    this.putAsPendingCAnimation(n2, CA_ALT, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    int[] nArray = new int[]{0, 1};
                    this.animatedCameras.put(n2, nArray);
                }
                double d = Math.round((double)(l / (long)this.frameTime));
                if (!(d > 0.0)) break;
                CZoom cZoom = new CZoom(camera, this, l);
                float f7 = camera.altitude;
                float f8 = ((Float)object).floatValue();
                cZoom.steps = new float[(int)d];
                int n8 = 0;
                while ((double)n8 < d - 1.0) {
                    double d7 = this.computeSigmoid(this.sigFactor, (double)(n8 + 1) / d);
                    float f9 = f8 * (float)d7;
                    f = f7 + f9;
                    if (f < (float)this.vsm.zoomFloor) {
                        f = this.vsm.zoomFloor;
                    }
                    cZoom.steps[n8++] = f;
                }
                f = f7 + f8;
                if (f < (float)this.vsm.zoomFloor) {
                    f = this.vsm.zoomFloor;
                }
                cZoom.steps[(int)d - 1] = f;
                this.animCameraBag.add(cZoom);
                cZoom.start();
                break;
            }
            case 6: {
                float f;
                if (this.animatedCameras.containsKey(n2) && (((int[])this.animatedCameras.get(n2))[0] == 1 || ((int[])this.animatedCameras.get(n2))[1] == 1)) {
                    this.putAsPendingCAnimation(n2, CA_BOTH, l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    int[] nArray = new int[]{1, 1};
                    this.animatedCameras.put(n2, nArray);
                }
                double d = Math.round((double)(l / (long)this.frameTime));
                if (!(d > 0.0)) break;
                CTransZoom cTransZoom = new CTransZoom(camera, this, l);
                float f10 = camera.altitude;
                long l18 = camera.posx;
                long l19 = camera.posy;
                float f11 = ((Float)((Vector)object).elementAt(0)).floatValue();
                long l20 = ((LongPoint)((Vector)object).elementAt((int)1)).x;
                long l21 = ((LongPoint)((Vector)object).elementAt((int)1)).y;
                cTransZoom.zsteps = new float[(int)d];
                cTransZoom.tsteps = new LongPoint[(int)d];
                int n9 = 0;
                while ((double)n9 < d - 1.0) {
                    double d8 = this.computeSigmoid(this.sigFactor, (double)(n9 + 1) / d);
                    float f12 = f11 * (float)d8;
                    long l22 = Math.round((double)l20 * d8);
                    long l23 = Math.round((double)l21 * d8);
                    f = f10 + f12;
                    if (f < (float)this.vsm.zoomFloor) {
                        f = this.vsm.zoomFloor;
                    }
                    cTransZoom.zsteps[n9] = f;
                    cTransZoom.tsteps[n9++] = new LongPoint(l18 + l22, l19 + l23);
                }
                f = f10 + f11;
                if (f < (float)this.vsm.zoomFloor) {
                    f = this.vsm.zoomFloor;
                }
                cTransZoom.zsteps[(int)d - 1] = f;
                cTransZoom.tsteps[(int)d - 1] = new LongPoint(l18 + l20, l19 + l21);
                this.animCameraBag.add(cTransZoom);
                cTransZoom.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createCameraAnimation : unknown animation type");
            }
        }
    }

    void putAsPendingCAnimation(Integer n, String string, long l, int n2, Object object) {
        if (this.pendingCAnims.containsKey(n)) {
            Hashtable hashtable = (Hashtable)this.pendingCAnims.get(n);
            Vector vector = hashtable.containsKey(string) ? (Vector)hashtable.get(string) : new Vector();
            vector.add(new AnimParams(l, n2, object));
            hashtable.put(string, vector);
        } else {
            Vector<AnimParams> vector = new Vector<AnimParams>();
            vector.add(new AnimParams(l, n2, object));
            Hashtable<String, Vector<AnimParams>> hashtable = new Hashtable<String, Vector<AnimParams>>();
            hashtable.put(string, vector);
            this.pendingCAnims.put(n, hashtable);
        }
    }

    void killCAnim(CAnimation cAnimation, String string) {
        Object object;
        Integer n = cAnimation.target.getID();
        this.animCameraBag.remove(cAnimation);
        if (this.animatedCameras.containsKey(n)) {
            object = (int[])this.animatedCameras.get(n);
            if (string.equals(CA_TRANS)) {
                object[0] = 0;
            } else if (string.equals(CA_ALT)) {
                object[1] = false;
            } else if (string.equals(CA_BOTH)) {
                object[0] = false;
                object[1] = false;
            }
            if (this.allValuesEqualZero((int[])object)) {
                this.animatedCameras.remove(n);
            }
        }
        if (this.pendingCAnims.containsKey(n) && ((Hashtable)(object = (Object)((Hashtable)this.pendingCAnims.get(n)))).containsKey(string)) {
            Vector vector = (Vector)((Hashtable)object).get(string);
            AnimParams animParams = (AnimParams)vector.elementAt(0);
            vector.removeElementAt(0);
            if (vector.isEmpty()) {
                ((Hashtable)object).remove(string);
                if (((Hashtable)object).isEmpty()) {
                    this.pendingCAnims.remove(n);
                }
            }
            this.createCameraAnimation(animParams.duration, animParams.type, animParams.data, n);
        }
    }

    public void interruptCameraAnimation(Camera camera, String string, boolean bl, boolean bl2) {
        CAnimation cAnimation = null;
        for (int i = 0; i < this.animCameraBag.size(); ++i) {
            CAnimation cAnimation2 = (CAnimation)this.animCameraBag.elementAt(i);
            if (cAnimation2.target != camera || cAnimation2.type != string) continue;
            cAnimation = cAnimation2;
            break;
        }
        if (cAnimation != null) {
            if (bl) {
                Hashtable hashtable;
                if (bl2) {
                    cAnimation.conclude();
                }
                if (this.pendingCAnims.containsKey(camera.getID()) && (hashtable = (Hashtable)this.pendingCAnims.get(camera.getID())).containsKey(string)) {
                    hashtable.remove(string);
                    if (hashtable.isEmpty()) {
                        this.pendingCAnims.remove(camera.getID());
                    }
                }
            } else if (bl2) {
                cAnimation.conclude();
            }
            this.killCAnim(cAnimation, string);
        }
    }

    double computeSigmoid(int n, double d) {
        return (Math.atan((double)n * (2.0 * d - 1.0)) / Math.atan(n) + 1.0) / 2.0;
    }

    boolean allValuesEqualZero(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    int[] addElementsToIntArray(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[nArray.length + n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2] = nArray[n2];
        }
        for (n2 = nArray.length; n2 < nArray2.length; ++n2) {
            nArray2[n2] = 0;
        }
        return nArray2;
    }

    private void printHSVArray(float[] fArray) {
        System.out.println(fArray[0] + "," + fArray[1] + "," + fArray[2]);
    }
}

