/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.implementation.model;

import org.w3c.rdf.digest.DigestException;
import org.w3c.rdf.digest.RDFDigestUtil;
import org.w3c.rdf.implementation.model.LiteralImpl;
import org.w3c.rdf.implementation.model.RDFNodeImpl;
import org.w3c.rdf.implementation.model.ResourceImpl;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public final class StatementImpl
implements Statement {
    Resource pred;
    Resource subj;
    RDFNode obj;

    public StatementImpl(Resource resource, Resource resource2, RDFNode rDFNode) {
        this.pred = resource2;
        this.subj = resource;
        this.obj = rDFNode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Statement)) {
            return false;
        }
        Statement statement = (Statement)object;
        try {
            return this.subj.equals(statement.subject()) && this.pred.equals(statement.predicate()) && this.obj.equals(statement.object());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public String getLabel() throws ModelException {
        return this.getURI();
    }

    public String getLocalName() throws ModelException {
        return this.getURI();
    }

    public String getNamespace() {
        return null;
    }

    public String getURI() throws ModelException {
        try {
            return RDFDigestUtil.statementDigestToURI(RDFDigestUtil.getStatementDigest(this));
        }
        catch (DigestException digestException) {
            throw new ModelException(digestException.toString());
        }
    }

    public int hashCode() {
        return (this.subj.hashCode() * 7 + this.pred.hashCode()) * 7 + this.obj.hashCode();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("StatementImpl <subject> <predicate> <object> [literal]");
            System.exit(1);
        }
        RDFNodeImpl rDFNodeImpl = stringArray.length > 3 ? new LiteralImpl(stringArray[2]) : new ResourceImpl(stringArray[2]);
        StatementImpl statementImpl = new StatementImpl(new ResourceImpl(stringArray[0]), new ResourceImpl(stringArray[1]), rDFNodeImpl);
        System.err.println("Statement URI is: " + statementImpl.getURI() + ", hashCode: " + ((Object)statementImpl).hashCode());
    }

    public String node2string(RDFNode rDFNode) {
        try {
            if (rDFNode instanceof Literal) {
                return "literal(\"" + rDFNode.getLabel() + "\")";
            }
            if (rDFNode instanceof Statement) {
                return rDFNode.toString();
            }
            return "\"" + rDFNode.getLabel() + "\"";
        }
        catch (ModelException modelException) {
            return "<EXC: " + modelException + ">";
        }
    }

    public RDFNode object() {
        return this.obj;
    }

    public Resource predicate() {
        return this.pred;
    }

    public Resource subject() {
        return this.subj;
    }

    public String toString() {
        return "triple(" + this.node2string(this.subj) + ", " + this.node2string(this.pred) + ", " + this.node2string(this.obj) + ")";
    }
}

