/*
 * Decompiled with CFR 0.152.
 */
package org.brownell.xml.aelfred2;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.brownell.xml.DefaultHandler;
import org.brownell.xml.aelfred2.XmlParser;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public final class SAXDriver
implements Locator,
Attributes,
XMLReader,
Parser,
AttributeList {
    private final DefaultHandler base = new DefaultHandler();
    private XmlParser parser;
    private EntityResolver entityResolver = this.base;
    private ContentHandler contentHandler = this.base;
    private DTDHandler dtdHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private DeclHandler declHandler = this.base;
    private LexicalHandler lexicalHandler = this.base;
    private String elementName = null;
    private Stack entityStack = new Stack();
    private Vector attributeNames = new Vector();
    private Vector attributeNamespaces = new Vector();
    private Vector attributeLocalNames = new Vector();
    private Vector attributeValues = new Vector();
    private boolean namespaces = true;
    private boolean xmlNames = false;
    private int attributeCount = 0;
    private boolean nspending = false;
    private String[] nsTemp = new String[3];
    private NamespaceSupport prefixStack = new NamespaceSupport();
    private Hashtable features;
    private Hashtable properties;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String HANDLER = "http://xml.org/sax/properties/";

    void attribute(String string, String string2, boolean bl) throws SAXException {
        if (this.attributeCount++ == 0 && this.namespaces) {
            this.prefixStack.pushContext();
        }
        if (string2 != null) {
            if (this.namespaces) {
                int n = string.indexOf(58);
                if (n > 0) {
                    if (n == 5 && string.startsWith("xmlns")) {
                        String string3 = string.substring(n + 1);
                        if (string2.length() == 0) {
                            this.errorHandler.error(new SAXParseException("missing URI in namespace decl attribute: " + string, this));
                        } else {
                            this.prefixStack.declarePrefix(string3, string2);
                            this.contentHandler.startPrefixMapping(string3, string2);
                        }
                        if (!this.xmlNames) {
                            return;
                        }
                        this.nsTemp[0] = "";
                        this.nsTemp[1] = string;
                    } else if (this.prefixStack.processName(string, this.nsTemp, true) == null) {
                        this.nsTemp[0] = "";
                        this.nsTemp[1] = string;
                        this.nspending = true;
                    }
                } else {
                    if ("xmlns".equals(string)) {
                        this.prefixStack.declarePrefix("", string2);
                        this.contentHandler.startPrefixMapping("", string2);
                        if (!this.xmlNames) {
                            return;
                        }
                    }
                    this.nsTemp[0] = "";
                    this.nsTemp[1] = string;
                }
            } else {
                this.nsTemp[1] = "";
                this.nsTemp[0] = "";
            }
            this.attributeNamespaces.addElement(this.nsTemp[0]);
            this.attributeLocalNames.addElement(this.nsTemp[1]);
            this.attributeNames.addElement(string);
            this.attributeValues.addElement(string2);
        }
    }

    void charData(char[] cArray, int n, int n2) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        contentHandler.characters(cArray, n, n2);
    }

    void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.lexicalHandler != this.base) {
            this.lexicalHandler.comment(cArray, n, n2);
        }
    }

    private void deliverDTDEvents() throws SAXException {
        String string;
        String string2;
        String string3;
        String string4;
        Enumeration enumeration;
        if (this.dtdHandler != this.base) {
            enumeration = this.parser.declaredNotations();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                string3 = this.parser.getNotationPublicId(string4);
                string2 = this.parser.getNotationSystemId(string4);
                this.dtdHandler.notationDecl(string4, string3, string2);
            }
        }
        if (this.dtdHandler != this.base || this.declHandler != this.base) {
            enumeration = this.parser.declaredEntities();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                int n = this.parser.getEntityType(string);
                if (string.charAt(0) == '%') continue;
                if (n == 2) {
                    string3 = this.parser.getEntityPublicId(string);
                    string2 = this.parser.getEntitySystemId(string);
                    string4 = this.parser.getEntityNotationName(string);
                    this.dtdHandler.unparsedEntityDecl(string, string3, string2, string4);
                    continue;
                }
                if (n == 3) {
                    string3 = this.parser.getEntityPublicId(string);
                    string2 = this.parser.getEntitySystemId(string);
                    this.declHandler.externalEntityDecl(string, string3, string2);
                    continue;
                }
                if (n != 1 || "lt".equals(string) || "gt".equals(string) || "quot".equals(string) || "apos".equals(string) || "amp".equals(string)) continue;
                this.declHandler.internalEntityDecl(string, this.parser.getEntityValue(string));
            }
        }
        if (this.declHandler != this.base) {
            enumeration = this.parser.declaredElements();
            while (enumeration.hasMoreElements()) {
                String string5 = null;
                string = (String)enumeration.nextElement();
                switch (this.parser.getElementContentType(string)) {
                    case 1: {
                        string5 = "ANY";
                        break;
                    }
                    case 2: {
                        string5 = "EMPTY";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string5 = this.parser.getElementContentModel(string);
                        break;
                    }
                    default: {
                        string5 = null;
                    }
                }
                if (string5 != null) {
                    this.declHandler.elementDecl(string, string5);
                }
                Enumeration enumeration2 = this.parser.declaredAttributes(string);
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    String string6;
                    String string7;
                    String string8 = (String)enumeration2.nextElement();
                    switch (this.parser.getAttributeType(string, string8)) {
                        case 1: {
                            string7 = "CDATA";
                            break;
                        }
                        case 5: {
                            string7 = "ENTITY";
                            break;
                        }
                        case 6: {
                            string7 = "ENTITIES";
                            break;
                        }
                        case 9: {
                            string7 = this.parser.getAttributeEnumeration(string, string8);
                            break;
                        }
                        case 2: {
                            string7 = "ID";
                            break;
                        }
                        case 3: {
                            string7 = "IDREF";
                            break;
                        }
                        case 4: {
                            string7 = "IDREFS";
                            break;
                        }
                        case 7: {
                            string7 = "NMTOKEN";
                            break;
                        }
                        case 8: {
                            string7 = "NMTOKENS";
                            break;
                        }
                        case 10: {
                            string7 = "NOTATION";
                            break;
                        }
                        default: {
                            this.errorHandler.fatalError(new SAXParseException("internal error, att type", this));
                            string7 = null;
                        }
                    }
                    switch (this.parser.getAttributeDefaultValueType(string, string8)) {
                        case 32: {
                            string6 = "#IMPLIED";
                            break;
                        }
                        case 33: {
                            string6 = "#REQUIRED";
                            break;
                        }
                        case 34: {
                            string6 = "#FIXED";
                            break;
                        }
                        case 31: {
                            string6 = null;
                            break;
                        }
                        default: {
                            this.errorHandler.fatalError(new SAXParseException("internal error, att default", this));
                            string6 = null;
                        }
                    }
                    String string9 = this.parser.getAttributeDefaultValue(string, string8);
                    this.declHandler.attributeDecl(string, string8, string7, string6, string9);
                }
            }
        }
    }

    void doctypeDecl(String string, String string2, String string3) throws SAXException {
        LexicalHandler lexicalHandler = this.lexicalHandler;
        lexicalHandler.startDTD(string, string2, string3);
    }

    void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    void endDoctype() throws SAXException {
        this.deliverDTDEvents();
        this.lexicalHandler.endDTD();
    }

    void endDocument() throws SAXException {
    }

    void endElement(String string) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        contentHandler.endElement("", "", string);
        if (!this.namespaces) {
            return;
        }
        Enumeration enumeration = this.prefixStack.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            contentHandler.endPrefixMapping((String)enumeration.nextElement());
        }
        this.prefixStack.popContext();
    }

    void endExternalEntity(String string) throws SAXException {
        this.entityStack.pop();
    }

    void error(String string, String string2, int n, int n2) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, null, string2, n, n2);
        this.errorHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return this.xmlNames;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            return true;
        }
        if (this.features != null && this.features.containsKey(string)) {
            return (Boolean)this.features.get(string);
        }
        throw new SAXNotRecognizedException(string);
    }

    public int getIndex(String string) {
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (this.getQName(n2).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (this.getURI(n2).equals(string) && this.getLocalName(n2).equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getLength() {
        return this.attributeNames.size();
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public String getLocalName(int n) {
        return (String)this.attributeLocalNames.elementAt(n);
    }

    public String getName(int n) {
        return (String)this.attributeNames.elementAt(n);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.lexicalHandler;
        }
        if (this.properties != null && this.properties.containsKey(string)) {
            return this.properties.get(string);
        }
        throw new SAXNotRecognizedException(string);
    }

    public String getPublicId() {
        return null;
    }

    public String getQName(int n) {
        return (String)this.attributeNames.elementAt(n);
    }

    public String getSystemId() {
        return (String)this.entityStack.peek();
    }

    public String getType(int n) {
        switch (this.parser.getAttributeType(this.elementName, this.getQName(n))) {
            case 0: 
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: 
            case 9: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 10: {
                return "NOTATION";
            }
        }
        return null;
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getURI(int n) {
        return (String)this.attributeNamespaces.elementAt(n);
    }

    public String getValue(int n) {
        return (String)this.attributeValues.elementAt(n);
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        contentHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        DefaultHandler defaultHandler = this.base;
        synchronized (defaultHandler) {
            this.parser = new XmlParser();
            this.parser.setHandler(this);
            try {
                try {
                    String string = inputSource.getSystemId();
                    if (string != null) {
                        this.entityStack.push(string);
                    } else {
                        this.entityStack.push("illegal:unknown system ID");
                    }
                    this.parser.doParse(string, inputSource.getPublicId(), inputSource.getCharacterStream(), inputSource.getByteStream(), inputSource.getEncoding());
                }
                catch (SAXException sAXException) {
                    throw sAXException;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SAXException(exception.getMessage(), exception);
                }
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.contentHandler.endDocument();
                this.entityStack.removeAllElements();
                throw throwable;
            }
            this.contentHandler.endDocument();
            this.entityStack.removeAllElements();
        }
    }

    void processingInstruction(String string, String string2) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        contentHandler.processingInstruction(string, string2);
    }

    Object resolveEntity(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.entityResolver.resolveEntity(string, string2);
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            if (inputSource.getEncoding() == null) {
                return inputSource.getByteStream();
            }
            try {
                return new InputStreamReader(inputSource.getByteStream(), inputSource.getEncoding());
            }
            catch (IOException iOException) {
                return inputSource.getByteStream();
            }
        }
        return inputSource.getSystemId();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            contentHandler = this.base;
        }
        this.contentHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            dTDHandler = this.base;
        }
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.contentHandler = new Adapter(documentHandler);
        this.xmlNames = true;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            entityResolver = this.base;
        }
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.base;
        }
        this.errorHandler = errorHandler;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        block6: {
            try {
                boolean bl2 = this.getFeature(string);
                if (bl == bl2) {
                    return;
                }
                if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
                    this.xmlNames = bl;
                    return;
                }
                if ("http://xml.org/sax/features/namespaces".equals(string)) {
                    this.namespaces = bl;
                    return;
                }
                if (this.features == null || !this.features.containsKey(string)) {
                    throw new SAXNotSupportedException(string);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (this.features != null) break block6;
                this.features = new Hashtable(5);
            }
        }
        this.features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setLocale(Locale locale) throws SAXException {
        if ("en".equals(locale.getLanguage())) {
            return;
        }
        throw new SAXException("AElfred only supports English locales.");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        block11: {
            try {
                Object object2 = this.getProperty(string);
                if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
                    if (object == null) {
                        this.declHandler = this.base;
                    } else {
                        if (!(object instanceof DeclHandler)) {
                            throw new SAXNotSupportedException(string);
                        }
                        this.declHandler = (DeclHandler)object;
                    }
                    return;
                }
                if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
                    if (object == null) {
                        this.lexicalHandler = this.base;
                    } else {
                        if (!(object instanceof LexicalHandler)) {
                            throw new SAXNotSupportedException(string);
                        }
                        this.lexicalHandler = (LexicalHandler)object;
                    }
                    return;
                }
                if (this.properties == null || !this.properties.containsKey(string)) {
                    throw new SAXNotSupportedException(string);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (this.properties != null) break block11;
                this.properties = new Hashtable(5);
            }
        }
        this.properties.put(string, object);
    }

    void startCDATA() throws SAXException {
        LexicalHandler lexicalHandler = this.lexicalHandler;
        lexicalHandler.startCDATA();
    }

    void startDocument() throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    void startElement(String string) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        if (this.attributeCount == 0) {
            this.prefixStack.pushContext();
        } else if (this.nspending) {
            int n = 0;
            while (n < this.attributeCount) {
                String string2 = (String)this.attributeNames.elementAt(n);
                if (string2.indexOf(58) > 0) {
                    if (this.prefixStack.processName(string2, this.nsTemp, true) == null) {
                        this.errorHandler.error(new SAXParseException("undeclared attribute prefix in: " + string2, this));
                    } else {
                        this.attributeNamespaces.setElementAt(this.nsTemp[0], n);
                        this.attributeLocalNames.setElementAt(this.nsTemp[1], n);
                    }
                }
                ++n;
            }
            this.nspending = false;
        }
        this.elementName = string;
        if (this.namespaces) {
            if (this.prefixStack.processName(string, this.nsTemp, false) == null) {
                this.errorHandler.error(new SAXParseException("undeclared element prefix in: " + string, this));
                this.nsTemp[1] = "";
                this.nsTemp[0] = "";
            }
            contentHandler.startElement(this.nsTemp[0], this.nsTemp[1], string, this);
        } else {
            contentHandler.startElement("", "", string, this);
        }
        if (this.attributeCount != 0) {
            this.attributeNames.removeAllElements();
            this.attributeNamespaces.removeAllElements();
            this.attributeLocalNames.removeAllElements();
            this.attributeValues.removeAllElements();
            this.attributeCount = 0;
        }
    }

    void startExternalEntity(String string) throws SAXException {
        this.entityStack.push(string);
    }

    private static class Adapter
    implements ContentHandler {
        private DocumentHandler docHandler;

        Adapter(DocumentHandler documentHandler) {
            this.docHandler = documentHandler;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.docHandler.characters(cArray, n, n2);
        }

        public void endDocument() throws SAXException {
            this.docHandler.endDocument();
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.docHandler.endElement(string3);
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.docHandler.ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.docHandler.processingInstruction(string, string2);
        }

        public void setDocumentLocator(Locator locator) {
            this.docHandler.setDocumentLocator(locator);
        }

        public void skippedEntity(String string) {
        }

        public void startDocument() throws SAXException {
            this.docHandler.startDocument();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.docHandler.startElement(string3, (AttributeList)((Object)attributes));
        }

        public void startPrefixMapping(String string, String string2) {
        }
    }
}

