/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.xml.util;

import edu.stanford.db.xml.util.Element;
import edu.stanford.db.xml.util.QName;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.WeakHashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class GenericParser
extends DefaultHandler {
    protected ErrorHandler errorHandler = null;
    protected Locator locator = new LocatorImpl();
    protected InputSource source;
    protected Element current;
    protected Hashtable namespaces = new Hashtable();
    static final String DEFAULT_PARSER = "org.brownell.xml.aelfred2.SAXDriver";
    protected String parserClass = null;
    protected int numInParent = 0;
    protected static WeakHashMap atoms = new WeakHashMap();

    public GenericParser() {
        this(false);
    }

    public GenericParser(boolean bl) {
        this.initXMLParser(bl);
    }

    protected void _endElement(String string, String string2) throws SAXException {
        this.numInParent = this.current.getNumInParent() + 1;
        this.current = this.current.getParent();
    }

    protected void _startElement(String string, String string2, Attributes attributes) throws SAXException {
        Element element = this.createElement();
        element.setName(new QName(string, string2));
        element.setNumInParent(this.numInParent);
        this.numInParent = 1;
        this.addNamespace(string);
        int n = 0;
        while (n < attributes.getLength()) {
            String string3 = attributes.getURI(n);
            this.addNamespace(string3);
            QName qName = new QName(string3, attributes.getLocalName(n));
            String string4 = attributes.getValue(n);
            element.setAttribute(qName, string4);
            ++n;
        }
        if (this.current == null) {
            this.current = element;
        } else {
            this.current.setChild(element);
            element.setParent(this.current);
            this.current = element;
        }
    }

    public void addError(String string) throws SAXException {
        this.errorHandler.error(new SAXParseException(string, this.locator));
    }

    protected void addNamespace(String string) {
        if (!"".equals(string)) {
            this.namespaces.put(string, string);
        }
    }

    public void addWarning(String string) throws SAXException {
        this.errorHandler.warning(new SAXParseException(string, this.locator));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        String string2 = string.trim();
        if (string2.length() > 0 || this.preserveWhiteSpace()) {
            this.current.setValue(string2);
        }
    }

    public static String create(String string) {
        if (string == null) {
            return null;
        }
        WeakReference weakReference = (WeakReference)atoms.get(string);
        if (weakReference == null) {
            atoms.put(string, new WeakReference<String>(string));
        } else {
            Object t = weakReference.get();
            if (t == null) {
                atoms.put(string, new WeakReference<String>(string));
            } else {
                string = (String)t;
            }
        }
        return string;
    }

    protected Element createElement() {
        return new Element();
    }

    public static QName createQName(String string, String string2) {
        return new QName(GenericParser.create(string), GenericParser.create(string2));
    }

    protected XMLReader createXMLReader() {
        return GenericParser.createXMLReader(this.getParserClass());
    }

    public static XMLReader createXMLReader(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (XMLReader)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not instantiate XML parser: " + exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        System.out.println("End element: " + this.current.getName());
        this._endElement(string, string2);
    }

    protected String getDefaultParserClass() {
        return DEFAULT_PARSER;
    }

    public static InputSource getInputSource(String string) throws MalformedURLException, IOException {
        InputStream inputStream = null;
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                uRL = new URL("file", null, string);
            }
            inputStream = uRL.openStream();
        } else {
            inputStream = System.in;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        InputSource inputSource = new InputSource(bufferedReader);
        if (string != null) {
            inputSource.setSystemId(uRL.toString());
        }
        return inputSource;
    }

    public Enumeration getNamespaces() {
        return this.namespaces.keys();
    }

    protected String getParserClass() {
        return this.parserClass;
    }

    protected String getSourceURI() {
        return this.source.getSystemId();
    }

    protected void initXMLParser(boolean bl) {
        block4: {
            try {
                this.parserClass = System.getProperty("org.xml.sax.parser");
                if (this.parserClass == null) {
                    if (bl) {
                        System.err.println("Warning: using the default XML parser (" + this.getDefaultParserClass() + ").\n" + "Override for IBM xml4j is: -Dorg.xml.sax.parser=com.ibm.xml.parser.SAXDriver");
                    }
                    break block4;
                }
                return;
            }
            catch (SecurityException securityException) {
                if (!bl) break block4;
                System.err.println("Warning: could not access system properties, using default XML parser (" + this.getDefaultParserClass() + ").");
            }
        }
        this.parserClass = this.getDefaultParserClass();
    }

    protected boolean preserveWhiteSpace() {
        return false;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        System.err.println("[Warning] ignoring external entity " + string2);
        return new InputSource(new CharArrayReader(new char[0]));
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._startElement(string, string2, attributes);
        System.out.println("Start element: " + this.current.getName());
    }
}

