/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz.applet;

import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.SwingWorker;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.svg.SVGReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.claribole.zvtm.engine.Location;
import org.w3c.IsaViz.applet.IsvAppletEvtHdlr;
import org.w3c.IsaViz.applet.TextViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IsvBrowser
extends JApplet
implements ActionListener,
KeyListener {
    static Font swingFont = new Font("Helvetica", 1, 10);
    static Color resourceColorF = new Color(115, 191, 115);
    static Color resourceColorTB = new Color(66, 105, 66);
    static Color propertyColorB = new Color(90, 89, 206);
    static Color propertyColorT = new Color(90, 89, 206);
    static Color literalColorF = new Color(255, 223, 123);
    static Color literalColorTB = new Color(132, 117, 66);
    float resTBh = 0.33333334f;
    float resTBs = 0.37142858f;
    float resTBv = 0.4117647f;
    float prpTh = 0.6680911f;
    float prpTs = 0.56796116f;
    float prpTv = 0.80784315f;
    float litTBh = 0.12878788f;
    float litTBs = 0.5f;
    float litTBv = 0.5176471f;
    static VirtualSpaceManager vsm;
    static IsvAppletEvtHdlr evt;
    static String rdfVS;
    static String vtmView;
    static int viewWidth;
    static int viewHeight;
    static final int MAX_PREV_LOC = 10;
    static Vector previousLocations;
    static int ANIM_MOVE_LENGTH;
    static short MOVE_UP;
    static short MOVE_DOWN;
    static short MOVE_LEFT;
    static short MOVE_RIGHT;
    static short MOVE_UP_LEFT;
    static short MOVE_UP_RIGHT;
    static short MOVE_DOWN_LEFT;
    static short MOVE_DOWN_RIGHT;
    static JLabel statusBar;
    JButton helpBt;
    JButton aboutBt;
    JButton mvNBt;
    JButton mvNEBt;
    JButton mvEBt;
    JButton mvSEBt;
    JButton mvSBt;
    JButton mvSWBt;
    JButton mvWBt;
    JButton mvNWBt;
    JButton mvHBt;
    JButton zmIBt;
    JButton zmOBt;
    static final String aboutMsg = "IsaViz/ZVTM Browser for RDF Validator v 0.2\nhttp://www.w3.org/2001/11/IsaViz/\n\n\nBased on the ZVTM (http://zvtm.sourceforge.net)\n\nWritten by Emmanuel Pietriga (emmanuel@w3.org)";
    static final String commands = "Misc. Commands\n--------------------------------------------------\nNavigation\n* Press the left or right mouse button and drag to move in the graph\n* Hold Shift, press the left or right mouse button and drag vertically to zoom/unzoom\n* Click the left or right mouse button on a node to center the view on it\n* Home (or Ctrl+G) = get a global view of the graph\n* Page Down = Zoom In\n* Page Up = Zoom Out\n* Arrows = move in the graph\n* Ctrl+B = Back to previous location\n";

    public IsvBrowser() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
    }

    public void init() {
        this.addKeyListener(this);
        previousLocations = new Vector();
        try {
            int n = Integer.parseInt(this.getParameter("width"));
            int n2 = Integer.parseInt(this.getParameter("height"));
            if (n > 0) {
                viewWidth = n;
            }
            if (n2 > 0) {
                viewHeight = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(new FlowLayout());
        vsm = new VirtualSpaceManager(true);
        vsm.setMainFont(swingFont);
        vsm.setMouseInsideGlyphColor(Color.red);
        vsm.setZoomLimit(-90);
        vsm.addVirtualSpace(rdfVS);
        vsm.addCamera(rdfVS);
        Vector<Camera> vector = new Vector<Camera>();
        vector.add(vsm.getVirtualSpace(rdfVS).getCamera(0));
        this.setSize(viewWidth - 10, viewHeight - 10);
        this.getContentPane().setSize(viewWidth, viewHeight);
        JPanel jPanel = vsm.addAppletView(vector, vtmView, viewWidth - 10, viewHeight - 60);
        jPanel.setPreferredSize(new Dimension(viewWidth - 100 - 10, viewHeight - 60));
        statusBar = new JLabel("Please Wait (this can take several minutes)...");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)statusBar, "South");
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 2), " IsaViz (ZVTM) "));
        evt = new IsvAppletEvtHdlr(this);
        vsm.getView(vtmView).setEventHandler((AppEventHandler)evt);
        vsm.getView(vtmView).setBackgroundColor(Color.white);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel3.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel4.setLayout(gridBagLayout);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(3, 3));
        jPanel5.setBackground(Color.white);
        this.mvNWBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_nw.gif")));
        this.mvNWBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvNWBt.setContentAreaFilled(false);
        this.mvNWBt.setBorderPainted(false);
        this.mvNWBt.setFocusPainted(false);
        this.mvNWBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_nw_h.gif")));
        this.mvNWBt.addActionListener(this);
        jPanel5.add(this.mvNWBt);
        this.mvNBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_n.gif")));
        this.mvNBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvNBt.setContentAreaFilled(false);
        this.mvNBt.setBorderPainted(false);
        this.mvNBt.setFocusPainted(false);
        this.mvNBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_n_h.gif")));
        this.mvNBt.addActionListener(this);
        jPanel5.add(this.mvNBt);
        this.mvNEBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_ne.gif")));
        this.mvNEBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvNEBt.setContentAreaFilled(false);
        this.mvNEBt.setBorderPainted(false);
        this.mvNEBt.setFocusPainted(false);
        this.mvNEBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_ne_h.gif")));
        this.mvNEBt.addActionListener(this);
        jPanel5.add(this.mvNEBt);
        this.mvWBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_w.gif")));
        this.mvWBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvWBt.setContentAreaFilled(false);
        this.mvWBt.setBorderPainted(false);
        this.mvWBt.setFocusPainted(false);
        this.mvWBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_w_h.gif")));
        this.mvWBt.addActionListener(this);
        jPanel5.add(this.mvWBt);
        this.mvHBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_home.gif")));
        this.mvHBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvHBt.setContentAreaFilled(false);
        this.mvHBt.setBorderPainted(false);
        this.mvHBt.setFocusPainted(false);
        this.mvHBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_home_h.gif")));
        this.mvHBt.addActionListener(this);
        jPanel5.add(this.mvHBt);
        this.mvEBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_e.gif")));
        this.mvEBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvEBt.setContentAreaFilled(false);
        this.mvEBt.setBorderPainted(false);
        this.mvEBt.setFocusPainted(false);
        this.mvEBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_e_h.gif")));
        this.mvEBt.addActionListener(this);
        jPanel5.add(this.mvEBt);
        this.mvSWBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_sw.gif")));
        this.mvSWBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvSWBt.setContentAreaFilled(false);
        this.mvSWBt.setBorderPainted(false);
        this.mvSWBt.setFocusPainted(false);
        this.mvSWBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_sw_h.gif")));
        this.mvSWBt.addActionListener(this);
        jPanel5.add(this.mvSWBt);
        this.mvSBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_s.gif")));
        this.mvSBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvSBt.setContentAreaFilled(false);
        this.mvSBt.setBorderPainted(false);
        this.mvSBt.setFocusPainted(false);
        this.mvSBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_s_h.gif")));
        this.mvSBt.addActionListener(this);
        jPanel5.add(this.mvSBt);
        this.mvSEBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/m_se.gif")));
        this.mvSEBt.setBorder(BorderFactory.createEmptyBorder());
        this.mvSEBt.setContentAreaFilled(false);
        this.mvSEBt.setBorderPainted(false);
        this.mvSEBt.setFocusPainted(false);
        this.mvSEBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/m_se_h.gif")));
        this.mvSEBt.addActionListener(this);
        jPanel5.add(this.mvSEBt);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 30);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel4.add(jPanel5);
        gridBagConstraints.anchor = 10;
        this.zmIBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/zm_i.gif")));
        this.zmIBt.setBorder(BorderFactory.createEmptyBorder());
        this.zmIBt.setContentAreaFilled(false);
        this.zmIBt.setBorderPainted(false);
        this.zmIBt.setFocusPainted(false);
        this.zmIBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/zm_i_h.gif")));
        this.zmIBt.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.zmIBt, gridBagConstraints);
        jPanel4.add(this.zmIBt);
        this.zmOBt = new JButton(new ImageIcon(this.getClass().getResource("/appimages/zm_o.gif")));
        this.zmOBt.setBorder(BorderFactory.createEmptyBorder());
        this.zmOBt.setContentAreaFilled(false);
        this.zmOBt.setBorderPainted(false);
        this.zmOBt.setFocusPainted(false);
        this.zmOBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/appimages/zm_o_h.gif")));
        this.zmOBt.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.zmOBt, gridBagConstraints);
        jPanel4.add(this.zmOBt);
        gridBagConstraints.anchor = 15;
        this.helpBt = new JButton("Help...");
        this.aboutBt = new JButton("About...");
        this.helpBt.setBackground(Color.white);
        this.helpBt.setForeground(Color.black);
        this.aboutBt.setBackground(Color.white);
        this.aboutBt.setForeground(Color.black);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.helpBt, gridBagConstraints);
        jPanel4.add(this.helpBt);
        this.helpBt.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.aboutBt, gridBagConstraints);
        jPanel4.add(this.aboutBt);
        this.aboutBt.addActionListener(this);
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel4);
        this.getContentPane().add(jPanel3);
        this.setVisible(true);
        this.validate();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                IsvBrowser.this.loadSVG();
                return null;
            }
        };
        swingWorker.start();
    }

    void loadSVG() {
        block3: {
            try {
                String string = this.getParameter("svgFile");
                Document document = IsvBrowser.parse(string, false);
                if (document != null) {
                    this.load(document, vsm, rdfVS);
                    this.getGlobalView();
                    statusBar.setText(" ");
                    break block3;
                }
                statusBar.setText("An error occured while loading file " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void getGlobalView() {
        Location location = vsm.getGlobalView(vsm.getView(vtmView).getCameraNumber(0), ANIM_MOVE_LENGTH);
        this.rememberLocation(vsm.getView(vtmView).getCameraNumber(0).getLocation());
    }

    void getHigherView() {
        Camera camera = vsm.getView(vtmView).getCameraNumber(0);
        this.rememberLocation(camera.getLocation());
        Float f = new Float(camera.getAltitude() + camera.getFocal());
        IsvBrowser.vsm.animator.createCameraAnimation((long)ANIM_MOVE_LENGTH, (int)AnimManager.CA_ALT_SIG, (Object)f, camera.getID());
    }

    void getLowerView() {
        Camera camera = vsm.getView(vtmView).getCameraNumber(0);
        this.rememberLocation(camera.getLocation());
        Float f = new Float(-(camera.getAltitude() + camera.getFocal()) / 2.0f);
        IsvBrowser.vsm.animator.createCameraAnimation((long)ANIM_MOVE_LENGTH, (int)AnimManager.CA_ALT_SIG, (Object)f, camera.getID());
    }

    void translateView(short s) {
        LongPoint longPoint;
        Camera camera = vsm.getView(vtmView).getCameraNumber(0);
        this.rememberLocation(camera.getLocation());
        long[] lArray = vsm.getView(vtmView).getVisibleRegion(camera);
        if (s == MOVE_UP) {
            long l = Math.round((double)(lArray[1] - lArray[3]) / 2.4);
            longPoint = new LongPoint(0L, l);
        } else if (s == MOVE_DOWN) {
            long l = Math.round((double)(lArray[3] - lArray[1]) / 2.4);
            longPoint = new LongPoint(0L, l);
        } else if (s == MOVE_RIGHT) {
            long l = Math.round((double)(lArray[2] - lArray[0]) / 2.4);
            longPoint = new LongPoint(l, 0L);
        } else if (s == MOVE_LEFT) {
            long l = Math.round((double)(lArray[0] - lArray[2]) / 2.4);
            longPoint = new LongPoint(l, 0L);
        } else if (s == MOVE_UP_LEFT) {
            long l = Math.round((double)(lArray[3] - lArray[1]) / 2.4);
            long l2 = Math.round((double)(lArray[2] - lArray[0]) / 2.4);
            longPoint = new LongPoint(l, l2);
        } else if (s == MOVE_UP_RIGHT) {
            long l = Math.round((double)(lArray[1] - lArray[3]) / 2.4);
            long l3 = Math.round((double)(lArray[2] - lArray[0]) / 2.4);
            longPoint = new LongPoint(l, l3);
        } else if (s == MOVE_DOWN_RIGHT) {
            long l = Math.round((double)(lArray[1] - lArray[3]) / 2.4);
            long l4 = Math.round((double)(lArray[0] - lArray[2]) / 2.4);
            longPoint = new LongPoint(l, l4);
        } else {
            long l = Math.round((double)(lArray[3] - lArray[1]) / 2.4);
            long l5 = Math.round((double)(lArray[0] - lArray[2]) / 2.4);
            longPoint = new LongPoint(l, l5);
        }
        IsvBrowser.vsm.animator.createCameraAnimation((long)ANIM_MOVE_LENGTH, (int)AnimManager.CA_TRANS_SIG, (Object)longPoint, camera.getID());
    }

    void rememberLocation(Location location) {
        if (previousLocations.size() >= 10) {
            previousLocations.removeElementAt(0);
        }
        if (previousLocations.size() > 0) {
            if (!Location.equals((Location)((Location)previousLocations.lastElement()), (Location)location)) {
                previousLocations.add(location);
            }
        } else {
            previousLocations.add(location);
        }
    }

    void moveBack() {
        if (previousLocations.size() > 0) {
            Location location = (Location)previousLocations.lastElement();
            Location location2 = vsm.getView(vtmView).getCameraNumber(0).getLocation();
            Vector vector = Location.getDifference((Location)location2, (Location)location);
            IsvBrowser.vsm.animator.createCameraAnimation((long)ANIM_MOVE_LENGTH, (int)AnimManager.CA_ALT_TRANS_SIG, (Object)vector, vsm.getView(vtmView).getCameraNumber(0).getID());
            previousLocations.removeElementAt(previousLocations.size() - 1);
        }
    }

    void load(Document document, VirtualSpaceManager virtualSpaceManager, String string) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                this.processNode((Element)node, virtualSpaceManager, string);
            }
            ++n;
        }
    }

    void processNode(Element element, VirtualSpaceManager virtualSpaceManager, String string) {
        String string2 = element.getTagName();
        if (string2.equals(SVGReader._ellipse)) {
            VEllipse vEllipse = SVGReader.createEllipse((Element)element);
            virtualSpaceManager.addGlyph((Glyph)vEllipse, string);
            vEllipse.setFill(true);
            vEllipse.setColor(resourceColorF);
            vEllipse.setBorderColor(resourceColorTB);
        } else if (string2.equals(SVGReader._path)) {
            VPath vPath = SVGReader.createPath((Element)element, (VPath)new VPath());
            virtualSpaceManager.addGlyph((Glyph)vPath, string);
            vPath.setColor(propertyColorB);
        } else if (string2.equals(SVGReader._text)) {
            VText vText = SVGReader.createText((Element)element, (VirtualSpaceManager)virtualSpaceManager);
            vText.setSpecialFont(swingFont);
            virtualSpaceManager.addGlyph((Glyph)vText, string);
        } else if (string2.equals(SVGReader._polygon)) {
            VRectangleOr vRectangleOr = SVGReader.createRectangleFromPolygon((Element)element);
            if (vRectangleOr != null) {
                virtualSpaceManager.addGlyph((Glyph)vRectangleOr, string);
                vRectangleOr.setFill(true);
                vRectangleOr.setColor(literalColorF);
                vRectangleOr.setBorderColor(literalColorTB);
            } else {
                vRectangleOr = SVGReader.createPolygon((Element)element);
                vRectangleOr.setSensitivity(false);
                virtualSpaceManager.addGlyph((Glyph)vRectangleOr, string);
                vRectangleOr.setFill(true);
                vRectangleOr.setColor(propertyColorB);
                vRectangleOr.setBorderColor(propertyColorB);
            }
        } else if (string2.equals(SVGReader._g)) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    this.processNode((Element)node, virtualSpaceManager, string);
                }
                ++n;
            }
        } else if (string2.equals(SVGReader._a)) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    this.processNode((Element)node, virtualSpaceManager, string);
                }
                ++n;
            }
        } else if (!string2.equals(SVGReader._title)) {
            if (string2.equals(SVGReader._rect)) {
                VRectangleOr vRectangleOr = SVGReader.createRectangle((Element)element);
                virtualSpaceManager.addGlyph((Glyph)vRectangleOr, string);
                vRectangleOr.setFill(true);
                vRectangleOr.setColor(literalColorF);
                vRectangleOr.setBorderColor(literalColorTB);
            } else {
                System.err.println("SVGReader: unsupported element: " + string2);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.zmIBt) {
            this.getLowerView();
        } else if (object == this.zmOBt) {
            this.getHigherView();
        } else if (object == this.mvHBt) {
            this.getGlobalView();
        } else if (object == this.mvNBt) {
            this.translateView(MOVE_UP);
        } else if (object == this.mvSBt) {
            this.translateView(MOVE_DOWN);
        } else if (object == this.mvEBt) {
            this.translateView(MOVE_RIGHT);
        } else if (object == this.mvWBt) {
            this.translateView(MOVE_LEFT);
        } else if (object == this.mvNWBt) {
            this.translateView(MOVE_UP_LEFT);
        } else if (object == this.mvNEBt) {
            this.translateView(MOVE_UP_RIGHT);
        } else if (object == this.mvSWBt) {
            this.translateView(MOVE_DOWN_LEFT);
        } else if (object == this.mvSEBt) {
            this.translateView(MOVE_DOWN_RIGHT);
        } else if (object == this.helpBt) {
            new TextViewer(new StringBuffer(commands), "Help", 0);
        } else if (object == this.aboutBt) {
            this.about();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 33) {
            this.getHigherView();
        } else if (n == 34) {
            this.getLowerView();
        } else if (n == 36) {
            this.getGlobalView();
        } else if (n == 66) {
            this.moveBack();
        } else if (n == 38) {
            this.translateView(MOVE_UP);
        } else if (n == 40) {
            this.translateView(MOVE_DOWN);
        } else if (n == 37) {
            this.translateView(MOVE_LEFT);
        } else if (n == 39) {
            this.translateView(MOVE_RIGHT);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void about() {
        JOptionPane.showMessageDialog(this, aboutMsg);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public static Document parse(String string, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            if (!bl) {
                documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
            }
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStream inputStream = new URL(string).openStream();
            if (inputStream != null) {
                Document document = documentBuilder.parse(inputStream);
                return document;
            }
            return null;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    static {
        rdfVS = "rdfvs";
        vtmView = "IsaViz Applet Browser";
        viewWidth = 640;
        viewHeight = 480;
        ANIM_MOVE_LENGTH = 300;
        MOVE_UP = 0;
        MOVE_DOWN = 1;
        MOVE_LEFT = (short)2;
        MOVE_RIGHT = (short)3;
        MOVE_UP_LEFT = (short)4;
        MOVE_UP_RIGHT = (short)5;
        MOVE_DOWN_LEFT = (short)6;
        MOVE_DOWN_RIGHT = (short)7;
    }
}

