/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.CharFormatter;
import antlr.collections.impl.IntRange;
import antlr.collections.impl.Vector;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int NIBBLE = 4;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public void add(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(el);
    }

    public BitSet and(BitSet a) {
        BitSet s = (BitSet)this.clone();
        s.andInPlace(a);
        return s;
    }

    public void andInPlace(BitSet a) {
        int min = Math.min(this.bits.length, a.bits.length);
        int i = min - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] & a.bits[i];
            --i;
        }
        int i2 = min;
        while (i2 < this.bits.length) {
            this.bits[i2] = 0L;
            ++i2;
        }
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public void clear() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            this.bits[i] = 0L;
            --i;
        }
    }

    public void clear(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet s;
        try {
            s = (BitSet)super.clone();
            s.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return s;
    }

    public int degree() {
        int deg = 0;
        int i = this.bits.length - 1;
        while (i >= 0) {
            long word = this.bits[i];
            if (word != 0L) {
                int bit = 63;
                while (bit >= 0) {
                    if ((word & 1L << bit) != 0L) {
                        ++deg;
                    }
                    --bit;
                }
            }
            --i;
        }
        return deg;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BitSet) {
            int n;
            BitSet set = (BitSet)obj;
            int i = n = Math.min(this.bits.length, set.bits.length);
            while (i-- > 0) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            if (this.bits.length > n) {
                int i2 = this.bits.length;
                while (i2-- > n) {
                    if (this.bits[i2] == 0L) continue;
                    return false;
                }
            } else if (set.bits.length > n) {
                int i3 = set.bits.length;
                while (i3-- > n) {
                    if (set.bits[i3] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Vector getRanges(int[] elems) {
        if (elems.length == 0) {
            return null;
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        if (elems.length <= 2) {
            return null;
        }
        Vector ranges = new Vector(5);
        int i = 0;
        while (i < elems.length - 2) {
            int lastInRange = elems.length - 1;
            int j = i + 1;
            while (j < elems.length) {
                if (elems[j] != elems[j - 1] + 1) {
                    lastInRange = j - 1;
                    break;
                }
                ++j;
            }
            if (lastInRange - i > 2) {
                ranges.appendElement(new IntRange(elems[i], elems[lastInRange]));
            }
            ++i;
        }
        return ranges;
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public boolean member(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        return (this.bits[n] & BitSet.bitMask(el)) != 0L;
    }

    public boolean nil() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) {
                return false;
            }
            --i;
        }
        return true;
    }

    public BitSet not() {
        BitSet s = (BitSet)this.clone();
        s.notInPlace();
        return s;
    }

    public void notInPlace() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            --i;
        }
    }

    public void notInPlace(int maxBit) {
        this.notInPlace(0, maxBit);
    }

    public void notInPlace(int minBit, int maxBit) {
        this.growToInclude(maxBit);
        int i = minBit;
        while (i <= maxBit) {
            int n;
            int n2 = n = BitSet.wordNumber(i);
            this.bits[n2] = this.bits[n2] ^ BitSet.bitMask(i);
            ++i;
        }
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public static BitSet of(int el) {
        BitSet s = new BitSet(el + 1);
        s.add(el);
        return s;
    }

    public BitSet or(BitSet a) {
        BitSet s = (BitSet)this.clone();
        s.orInPlace(a);
        return s;
    }

    public void orInPlace(BitSet a) {
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min = Math.min(this.bits.length, a.bits.length);
        int i = min - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] | a.bits[i];
            --i;
        }
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet a) {
        if (a == null || !(a instanceof BitSet)) {
            return false;
        }
        return this.and(a).equals(this);
    }

    public void subtractInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        int i = 0;
        while (i < this.bits.length && i < a.bits.length) {
            int n = i;
            this.bits[n] = this.bits[n] & (a.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public int[] toArray() {
        int[] elems = new int[this.degree()];
        int en = 0;
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                elems[en++] = i;
            }
            ++i;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String separator) {
        String str = "";
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                if (str.length() > 0) {
                    str = str + separator;
                }
                str = str + i;
            }
            ++i;
        }
        return str;
    }

    public String toString(String separator, CharFormatter formatter) {
        String str = "";
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                if (str.length() > 0) {
                    str = str + separator;
                }
                str = str + formatter.literalChar(i);
            }
            ++i;
        }
        return str;
    }

    public String toString(String separator, Vector vocabulary) {
        if (vocabulary == null) {
            return this.toString(separator);
        }
        String str = "";
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                if (str.length() > 0) {
                    str = str + separator;
                }
                str = i >= vocabulary.size() ? str + "<bad element " + i + ">" : (vocabulary.elementAt(i) == null ? str + "<" + i + ">" : str + (String)vocabulary.elementAt(i));
            }
            ++i;
        }
        return str;
    }

    public String toStringOfHalfWords() {
        String s = new String();
        int i = 0;
        while (i < this.bits.length) {
            if (i != 0) {
                s = s + ", ";
            }
            long tmp = this.bits[i];
            s = s + (tmp &= 0xFFFFFFFFL) + "UL";
            s = s + ", ";
            tmp = this.bits[i] >>> 32;
            s = s + (tmp &= 0xFFFFFFFFL) + "UL";
            ++i;
        }
        return s;
    }

    public String toStringOfWords() {
        String s = new String();
        int i = 0;
        while (i < this.bits.length) {
            if (i != 0) {
                s = s + ", ";
            }
            s = s + this.bits[i] + "L";
            ++i;
        }
        return s;
    }

    public String toStringWithRanges(String separator, CharFormatter formatter) {
        String str = "";
        int[] elems = this.toArray();
        if (elems.length == 0) {
            return "";
        }
        int i = 0;
        while (i < elems.length) {
            int lastInRange = 0;
            int j = i + 1;
            while (j < elems.length) {
                if (elems[j] != elems[j - 1] + 1) break;
                lastInRange = j++;
            }
            if (str.length() > 0) {
                str = str + separator;
            }
            if (lastInRange - i >= 2) {
                str = str + formatter.literalChar(elems[i]);
                str = str + "..";
                str = str + formatter.literalChar(elems[lastInRange]);
                i = lastInRange;
            } else {
                str = str + formatter.literalChar(elems[i]);
            }
            ++i;
        }
        return str;
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }
}

