/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.util.Currency;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Currency
implements Serializable {
    private String isoCode;
    private static ICULocaleService service;
    private static final Integer[] LAST_RESORT_DATA;
    private static final int[] POW10;
    static /* synthetic */ Class class$com$ibm$icu$util$Currency;

    private static ICULocaleService getService() {
        if (service == null) {
            ICULocaleService newService = new ICULocaleService("Currency");
            class CurrencyFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                CurrencyFactory() {
                }

                protected Object handleCreate(Locale loc, int kind, ICUService service) {
                    ResourceBundle bundle = ICULocaleData.getLocaleElements(loc);
                    String[] ce = bundle.getStringArray("CurrencyElements");
                    return new Currency(ce[1]);
                }
            }
            newService.registerFactory(new CurrencyFactory());
            Class clazz = class$com$ibm$icu$util$Currency == null ? (class$com$ibm$icu$util$Currency = Currency.class$("com.ibm.icu.util.Currency")) : class$com$ibm$icu$util$Currency;
            synchronized (clazz) {
                if (service == null) {
                    service = newService;
                }
            }
        }
        return service;
    }

    public static Currency getInstance(Locale locale) {
        return (Currency)Currency.getService().get(locale);
    }

    public static Currency getInstance(String theISOCode) {
        return new Currency(theISOCode);
    }

    static Object register(Currency currency, Locale locale) {
        return Currency.getService().registerObject((Object)currency, locale);
    }

    static boolean unregister(Object registryKey) {
        return Currency.getService().unregisterFactory((ICUService.Factory)registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (service == null) {
            return ICULocaleData.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        try {
            return this.equals((Currency)rhs);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equals(Currency c) {
        if (c == null) {
            return false;
        }
        if (c == this) {
            return true;
        }
        return c.getClass() == (class$com$ibm$icu$util$Currency == null ? (class$com$ibm$icu$util$Currency = Currency.class$("com.ibm.icu.util.Currency")) : class$com$ibm$icu$util$Currency) && this.isoCode.equals(c.isoCode);
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getSymbol(Locale locale) {
        ResourceBundle rb = ICULocaleData.getLocaleElements(locale);
        try {
            Object[][] currencies = (Object[][])rb.getObject("Currencies");
            int i = 0;
            while (i < currencies.length) {
                if (this.isoCode.equals((String)currencies[i][0])) {
                    return (String)currencies[i][1];
                }
                ++i;
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String[] currencyElements = rb.getStringArray("CurrencyElements");
            if (currencyElements[1].equals(this.isoCode)) {
                return currencyElements[0];
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.isoCode;
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        Integer[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    private Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private Integer[] findData() {
        try {
            ResourceBundle root = ICULocaleData.getLocaleElements("");
            Object[][] currencyMeta = (Object[][])root.getObject("CurrencyMeta");
            Integer[] i = null;
            int defaultPos = -1;
            int j = 0;
            while (j < currencyMeta.length) {
                Object[] row = currencyMeta[j];
                String s = (String)row[0];
                int c = this.isoCode.compareToIgnoreCase(s);
                if (c == 0) {
                    i = (Integer[])row[1];
                    break;
                }
                if ("DEFAULT".equalsIgnoreCase(s)) {
                    defaultPos = j;
                }
                if (c < 0 && defaultPos >= 0) break;
                ++j;
            }
            if (i == null && defaultPos >= 0) {
                i = (Integer[])currencyMeta[defaultPos][1];
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return LAST_RESORT_DATA;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LAST_RESORT_DATA = new Integer[]{new Integer(2), new Integer(0)};
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

