/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class schemagen {
    public static void main(String[] stringArray) {
        if (stringArray.length < 4 || stringArray.length > 5) {
            schemagen.usage();
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = "RDF/XML";
        if (stringArray.length > 4) {
            string5 = stringArray[4];
        }
        try {
            ModelMem modelMem = new ModelMem();
            schemagen.read(modelMem, string3, string5);
            PrintStream printStream = null;
            printStream = string4.equals("-") ? System.out : new PrintStream(new FileOutputStream(string4));
            schemagen.renderVocabularyClass(string, string2, modelMem, printStream);
        }
        catch (Exception exception) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + exception.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.schemagen name schemaURIRef input output [lang]");
        System.err.println();
        System.err.println("    name is the name of the vocabulary");
        System.err.println("         It may be simple, e.g. RDF, or it may be fully qualified");
        System.err.println("    input can be URL's or filenames");
        System.err.println("    lang can take values");
        System.err.println("      RDF/XML");
        System.err.println("      N-TRIPLE");
        System.err.println("    lang defaults to RDF/XML");
        System.err.println();
    }

    protected static void read(Model model, String string, String string2) throws RDFException, FileNotFoundException {
        try {
            URL uRL = new URL(string);
            model.read(string, string2);
        }
        catch (MalformedURLException malformedURLException) {
            model.read(new FileReader(string), "", string2);
        }
    }

    protected static void renderVocabularyClass(String string, String string2, Model model, PrintStream printStream) throws RDFException {
        Set set = schemagen.listNames(string2, model, RDFS.Class);
        Set set2 = schemagen.listNames(string2, model, RDF.Property);
        schemagen.renderPreamble(string, string2, printStream);
        schemagen.renderDeclarations(set, "Resource", printStream);
        schemagen.renderDeclarations(set2, "Property", printStream);
        schemagen.renderInitializer(set, set2, printStream);
        schemagen.renderPostamble(printStream);
    }

    protected static Set listNames(String string, Model model, Resource resource) throws RDFException {
        HashSet<String> hashSet = new HashSet<String>();
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, RDF.type, resource));
        while (stmtIterator.hasNext()) {
            String string2;
            Resource resource2 = stmtIterator.nextStatement().getSubject();
            if (resource2.isAnon() || !(string2 = resource2.getURI()).startsWith(string)) continue;
            hashSet.add(string2.substring(string.length()));
        }
        return hashSet;
    }

    protected static void renderDeclarations(Set set, String string, PrintStream printStream) throws RDFException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = schemagen.makeJavaLegalId(string2);
            printStream.println("           static String n" + string3 + " = \"" + string2 + "\";");
            printStream.println("    public static " + string + " " + string3 + ";");
        }
    }

    protected static void renderInitializer(Set set, Set set2, PrintStream printStream) throws RDFException {
        printStream.println();
        printStream.println("    static {");
        printStream.println("        try {");
        schemagen.renderTypedInitializer(set, "Resource", printStream);
        schemagen.renderTypedInitializer(set2, "Property", printStream);
        printStream.println("        } catch (Exception e) {");
        printStream.println("            ErrorHelper.logInternalError(\"RDF\", 1, e);");
        printStream.println("        }");
        printStream.println("    }");
    }

    protected static void renderTypedInitializer(Set set, String string, PrintStream printStream) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = schemagen.makeJavaLegalId((String)iterator.next());
            printStream.println("            " + string2 + " = ResourceFactory.create" + string + "(uri + n" + string2 + ");");
        }
    }

    protected static void renderPreamble(String string, String string2, PrintStream printStream) {
        String string3;
        if (string.indexOf(46) == -1) {
            string3 = "com.hp.hpl.jena.vocabulary";
        } else {
            string3 = string.substring(0, string.lastIndexOf(46));
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        printStream.println("/* Vocabulary Class generated by Jena vocabulary generator");
        printStream.println(" *");
        printStream.println(" * On: " + new Date().toString());
        printStream.println(" * Version $Id$");
        printStream.println(" */");
        printStream.println("package " + string3 + ";");
        printStream.println();
        printStream.println("import com.hp.hpl.jena.rdf.model.impl.ErrorHelper;");
        printStream.println("import com.hp.hpl.jena.rdf.model.Model;");
        printStream.println("import com.hp.hpl.jena.rdf.model.Resource;");
        printStream.println("import com.hp.hpl.jena.rdf.model.ResourceFactory;");
        printStream.println("import com.hp.hpl.jena.rdf.model.Property;");
        printStream.println("import com.hp.hpl.jena.rdf.model.RDFException;");
        printStream.println();
        printStream.println("/** " + string + " vocabulary class for namespace " + string2);
        printStream.println(" */");
        printStream.println("public class " + string + " {");
        printStream.println();
        printStream.println("    protected static final String uri =\"" + string2 + "\";");
        printStream.println();
        printStream.println("    /** returns the URI for this schema");
        printStream.println("     * @return the URI for this schema");
        printStream.println("     */");
        printStream.println("    public static String getURI() {");
        printStream.println("          return uri;");
        printStream.println("    }");
    }

    protected static void renderPostamble(PrintStream printStream) {
        printStream.println("}");
    }

    protected static String makeJavaLegalId(String string) {
        string = Util.replace(string, "-", "_");
        return Util.replace(string, ".", "_");
    }
}

