/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.rdql.test.QueryTestProgrammatic;
import com.hp.hpl.jena.rdql.test.QueryTestScripts;
import com.hp.hpl.jena.rdql.test.TestExpressions;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.PlainLogHandler;
import com.hp.hpl.jena.vocabulary.ResultSet;
import java.io.PrintWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class rdfquery {
    public static boolean displayTime = false;
    public static int messageLevel = 0;
    public static boolean debug = false;
    public static boolean dumpModel = false;
    static final int FMT_NONE = -1;
    static final int FMT_TUPLES = 0;
    static final int FMT_TEXT = 1;
    static final int FMT_HTML = 2;
    static final int FMT_DUMP = 3;
    public static int outputFormat = 1;
    static String dbUser = "";
    static String dbPassword = "";
    static String vocabularyURI = null;
    static Model vocabulary = null;
    static boolean applyRDFS = false;

    public static void main(String[] stringArray) {
        String string;
        Log.getInstance().setHandler(new PlainLogHandler());
        if (stringArray.length == 0) {
            rdfquery.usage();
            System.exit(0);
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        displayTime = false;
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (!string.startsWith("-")) break;
            if (!string.startsWith("--")) {
                string = "-" + string;
            }
            if (string.equalsIgnoreCase("--test")) {
                if (++n == stringArray.length) {
                    rdfquery.allTests();
                    System.exit(0);
                } else {
                    QueryTestScripts.doTests(stringArray[n], messageLevel > 0, displayTime);
                    System.exit(0);
                }
            } else if (string.equalsIgnoreCase("--help") || string.equalsIgnoreCase("--h")) {
                rdfquery.usage();
                System.exit(0);
            } else if (string.equalsIgnoreCase("--debug")) {
                debug = true;
            } else if (string.equalsIgnoreCase("--quiet") || string.equalsIgnoreCase("--q")) {
                --messageLevel;
            } else if (string.equalsIgnoreCase("--verbose") || string.equalsIgnoreCase("--v")) {
                ++messageLevel;
            } else if (string.equalsIgnoreCase("--format")) {
                if (++n == stringArray.length) {
                    System.err.println("Error: no output format given");
                    System.exit(1);
                }
                if ((string = stringArray[n]).equalsIgnoreCase("none")) {
                    outputFormat = -1;
                } else if (string.equalsIgnoreCase("tuples")) {
                    outputFormat = 0;
                } else if (string.equalsIgnoreCase("tuple")) {
                    outputFormat = 0;
                } else if (string.equalsIgnoreCase("text")) {
                    outputFormat = 1;
                } else if (string.equalsIgnoreCase("html")) {
                    outputFormat = 2;
                } else if (string.equalsIgnoreCase("dump")) {
                    outputFormat = 3;
                } else {
                    System.err.println("Unrecognized output format: " + string);
                    System.exit(1);
                }
            } else if (string.equalsIgnoreCase("--vocabulary") || string.equalsIgnoreCase("--vocab")) {
                if (++n == stringArray.length) {
                    System.err.println("Error: no vocabulary specified");
                    System.exit(1);
                }
                vocabularyURI = stringArray[n];
            } else if (string.equalsIgnoreCase("--rdfs")) {
                applyRDFS = true;
            } else if (string.equalsIgnoreCase("--time")) {
                displayTime = true;
            } else if (string.equalsIgnoreCase("--noarp")) {
                ModelLoader.useARP = false;
            } else if (string.equalsIgnoreCase("--xml")) {
                string3 = "RDF/XML";
            } else if (string.equalsIgnoreCase("--ntriple")) {
                string3 = "N-TRIPLE";
            } else if (string.equalsIgnoreCase("--n3")) {
                string3 = "N3";
            } else if (string.equalsIgnoreCase("--bdb")) {
                string3 = "RDF/BDB";
            } else if (string.equalsIgnoreCase("--user")) {
                if (++n == stringArray.length) {
                    System.err.println("Error: no user name  specified");
                    System.exit(1);
                }
                dbUser = stringArray[n];
            } else if (string.equalsIgnoreCase("--password")) {
                if (++n == stringArray.length) {
                    System.err.println("Error: no password  specified");
                    System.exit(1);
                }
                dbPassword = stringArray[n];
            } else if (string.equalsIgnoreCase("--data")) {
                if (string2 != null) {
                    System.err.println("Error: source already specified");
                    System.exit(1);
                }
                if (++n == stringArray.length) {
                    System.err.println("Error: no data file specified");
                    System.exit(1);
                }
                string2 = stringArray[n];
            } else if (string.equalsIgnoreCase("--query")) {
                if (++n == stringArray.length) {
                    System.err.println("Error: no query file specified");
                    System.exit(1);
                }
                string4 = stringArray[n];
            } else {
                System.err.println("Unrecognized option: " + string);
                rdfquery.usage();
                System.exit(1);
            }
            ++n;
        }
        if (messageLevel >= 3) {
            dumpModel = true;
        }
        if (debug) {
            Log.getInstance().setLevel(3);
            Log.debug("Debug on");
        }
        string = null;
        if (string4 != null) {
            try {
                string = FileUtils.readWholeFile(string4);
            }
            catch (Exception exception) {
                System.err.println("Error: failed to read file: " + exception);
                System.exit(1);
            }
        } else {
            if (n >= stringArray.length) {
                System.err.println("Error: No query supplied");
                System.exit(1);
            }
            string = stringArray[n];
        }
        rdfquery.query(string, string2, string3);
    }

    static void allTests() {
        TestSuite testSuite = new TestSuite("RDQL");
        testSuite.addTest((Test)TestExpressions.suite());
        testSuite.addTest((Test)QueryTestProgrammatic.suite());
        TestRunner.run((Test)testSuite);
    }

    public static void query(String string, String string2, String string3) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean bl = false;
            if (messageLevel >= 2) {
                System.out.println("Query:");
                System.out.println(string);
                if (!string.endsWith("\n")) {
                    System.out.println();
                }
                bl = true;
            }
            long l = System.currentTimeMillis();
            long l2 = -1L;
            Query query = new Query(string);
            if (displayTime) {
                query = new Query(string);
            }
            if (messageLevel > 0) {
                System.out.println("Parsed query:");
                object4 = query.toString();
                System.out.print((String)object4);
                if (!((String)object4).endsWith("\n")) {
                    System.out.println();
                }
                bl = true;
            }
            if (string2 == null && query.getSourceURL() == null) {
                System.err.println("RDQL: no data source");
                return;
            }
            if (string2 != null) {
                long l3 = System.currentTimeMillis();
                query.setSource(ModelLoader.loadModel(string2, string3, dbUser, dbPassword));
                object3 = query.getSource();
                if (applyRDFS) {
                    object2 = null;
                    if (vocabularyURI != null) {
                        vocabulary = ModelLoader.loadModel(vocabularyURI, null);
                        object2 = ModelFactory.createRDFSModel((Model)object3, vocabulary);
                    } else {
                        object2 = ModelFactory.createRDFSModel((Model)object3);
                    }
                    query.setSource((Model)object2);
                }
                query.loadTime = l2 = System.currentTimeMillis() - l3;
            }
            object4 = new QueryEngine(query);
            object4.init();
            if (dumpModel) {
                try {
                    if (bl) {
                        System.out.println();
                    }
                    bl = true;
                    object = query.getSource();
                    object3 = object.getWriter("N-TRIPLE");
                    object2 = new PrintWriter(System.out);
                    ((PrintWriter)object2).println("# Model --------------------------------------------------------------------------------");
                    object3.write((Model)object, (Writer)object2, "http://unset/");
                    ((PrintWriter)object2).println("# Model --------------------------------------------------------------------------------");
                    ((PrintWriter)object2).flush();
                }
                catch (RDFException rDFException) {
                    Log.severe("rdfquery: Failed to write model");
                    System.exit(1);
                }
            }
            object = object4.exec();
            object3 = new QueryResultsFormatter((QueryResults)object);
            if (outputFormat == -1) {
                ((QueryResultsFormatter)object3).consume();
            } else {
                if (bl) {
                    System.out.println();
                }
                if (outputFormat == 3) {
                    object2 = ((QueryResultsFormatter)object3).toModel();
                    RDFWriter rDFWriter = object2.getWriter("N3");
                    rDFWriter.setNsPrefix("rs", ResultSet.getURI());
                    rDFWriter.write((Model)object2, System.out, null);
                } else {
                    object2 = new PrintWriter(System.out);
                    switch (outputFormat) {
                        case 1: {
                            ((QueryResultsFormatter)object3).printAll((PrintWriter)object2);
                            break;
                        }
                        case 2: {
                            ((QueryResultsFormatter)object3).printHTML((PrintWriter)object2);
                            break;
                        }
                        case 0: {
                            ((QueryResultsFormatter)object3).dump((PrintWriter)object2, true);
                            break;
                        }
                    }
                    ((PrintWriter)object2).flush();
                }
                bl = true;
            }
            ((QueryResultsFormatter)object3).close();
            object.close();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            if (messageLevel > 0) {
                if (bl) {
                    System.out.println();
                }
                System.out.println("Results: " + ((QueryResultsFormatter)object3).numRows());
                bl = true;
            }
            if (displayTime) {
                if (bl) {
                    System.out.println();
                }
                System.out.println("Query parse:     " + rdfquery.formatlong(query.parseTime) + " ms");
                System.out.println("Query build:     " + rdfquery.formatlong(query.buildTime) + " ms");
                System.out.println("Data load time:  " + rdfquery.formatlong(query.loadTime) + " ms");
                System.out.println("Query execute:   " + rdfquery.formatlong(query.executeTime) + " ms");
                System.out.println("Query misc:      " + rdfquery.formatlong(l5 - query.parseTime - query.buildTime - query.loadTime - query.executeTime) + " ms");
                System.out.println("Query total:     " + rdfquery.formatlong(l5) + " ms");
                bl = true;
            }
            if (query.getSource() != null) {
                query.getSource().close();
            }
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            System.exit(9);
        }
    }

    static String formatlong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(l));
        int n = stringBuffer.length();
        while (n < 4) {
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    static void usage() {
        System.out.println("Usage: [--rdfs] [--data URL] [queryString | --query file]");
        System.out.println("   --query file         Read one query from a file");
        System.out.println("   --rdfs               Use an RDFS reasoner around the data");
        System.out.println("   --vocab URL | File   Specify a separate vocabulary (may also be in the data)");
        System.out.println("   --xml                Data source is XML (default)");
        System.out.println("   --ntriple            Data source is n-triple");
        System.out.println("   --n3                 Data source is N3");
        System.out.println("   --data URL           Data source (can also be part of query)");
        System.out.println("   --time               Print some time information");
        System.out.println("   --test [file]        Run the test suite");
        System.out.println("   --format FMT         One of text, html, tuples, dump or none");
        System.out.println("   --verbose            Verbose - more messages");
        System.out.println("   --quiet              Quiet - less messages");
    }
}

