/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.impl.NTripleWriter;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Basic;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;

public class testWriterInterface
extends TestCase {
    private String lang;

    public testWriterInterface(String string, String string2) {
        super(string);
        this.lang = string2;
    }

    public void testInterface() {
        ModelMem modelMem = new ModelMem();
        Object var2_2 = null;
        Object var3_3 = null;
        Assert.assertTrue((String)"Default writer should be Basic.", (boolean)(modelMem.getWriter() instanceof Basic));
        Assert.assertTrue((String)"RDF/XML writer should be Basic.", (boolean)(modelMem.getWriter() instanceof Basic));
        Assert.assertTrue((String)"RDF/XML-ABBREV writer should be Abbreviated.", (boolean)(modelMem.getWriter("RDF/XML-ABBREV") instanceof Abbreviated));
        Assert.assertTrue((String)"N-TRIPLE writer should be NTripleWriter.", (boolean)(modelMem.getWriter("N-TRIPLE") instanceof NTripleWriter));
    }

    public void testNoWriter() {
        ModelMem modelMem = new ModelMem();
        try {
            modelMem.setWriterClassName("foobar", "");
            modelMem.getWriter("foobar");
            Assert.fail((String)"Missing Writer undetected.");
        }
        catch (RDFException rDFException) {
            Assert.assertEquals((String)"Missing Writer misdiagnosed", (int)rDFException.getErrorCode(), (int)21);
        }
    }

    public void testAnotherWriter() {
        ModelMem modelMem = new ModelMem();
        modelMem.setWriterClassName("foobar", "com.hp.hpl.jena.xmloutput.impl.Basic");
        Assert.assertTrue((String)"Failed to access set writer", (boolean)(modelMem.getWriter("foobar") instanceof Basic));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriting() {
        File file = null;
        OutputStream outputStream = null;
        ModelMem modelMem = new ModelMem();
        try {
            file = File.createTempFile("~jena", ".rdf");
            outputStream = new FileOutputStream(file);
            modelMem.write(outputStream, this.lang);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (file != null) {
                file.delete();
            }
        }
    }
}

