/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.RDFException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.oro.text.awk.AwkCompiler;
import org.apache.oro.text.awk.AwkMatcher;
import org.apache.oro.text.regex.MalformedPatternException;

public class PrettyWriterTest
extends TestCase {
    static AwkCompiler awk = new AwkCompiler();
    static AwkMatcher matcher = new AwkMatcher();

    public PrettyWriterTest(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String string, String string2) throws IOException, MalformedPatternException {
        String string3 = null;
        try {
            ModelMem modelMem = new ModelMem();
            modelMem.read(string);
            StringWriter stringWriter = new StringWriter();
            modelMem.write(stringWriter, "RDF/XML-ABBREV", string);
            stringWriter.close();
            string3 = stringWriter.toString();
            ModelMem modelMem2 = new ModelMem();
            modelMem2.read(new StringReader(string3), string);
            Assert.assertTrue((boolean)modelMem.isIsomorphicWith(modelMem2));
            Assert.assertTrue((String)("Looking for /" + string2 + "/"), (boolean)matcher.contains(string3, awk.compile(string2)));
            string3 = null;
            Object var8_7 = null;
            if (string3 != null) {
                System.err.println("Incorrect contents:");
                System.err.println(string3);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (string3 != null) {
                System.err.println("Incorrect contents:");
                System.err.println(string3);
            }
            throw throwable;
        }
    }

    public void testAnonDamlClass() throws IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/daml.rdf", "rdf:parseType=[\"']daml:collection[\"']");
    }

    public void testRDFCollection() throws IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/collection.rdf", "rdf:parseType=[\"']Collection[\"']");
    }

    public void testOWLPrefix() throws RDFException, IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/collection.rdf", "xmlns:owl=[\"']http://www.w3.org/2002/07/owl#[\"']");
    }

    public void testLi() throws RDFException, IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/container.rdf", "<rdf:li.*<rdf:li.*<rdf:li.*<rdf:li");
    }
}

