/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.iterator.ArrayIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.IteratorIterator;
import com.hp.hpl.jena.util.iterator.LateBindingIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Relation;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.util.XMLChar;

class Unparser {
    private static Property LI = new PropertyImpl(RDF.getURI(), "li");
    private static Property DESCRIPTION = new PropertyImpl(RDF.getURI(), "Description");
    private String xmlBase;
    private static final String rdfns = RDF.type.getNameSpace();
    private static final Integer one = new Integer(1);
    private String localName;
    private Map objectTable;
    private Model model;
    private PrintWriter out;
    private Set doing = new HashSet();
    private Set doneSet = new HashSet();
    private Set haveReified = new HashSet();
    private Resource[] pleasingTypes = null;
    private Set pleasingTypeSet = new HashSet();
    private final Abbreviated prettyWriter;
    private boolean avoidExplicitReification = true;
    Map res2statement;
    Map statement2res;
    private static int RDF_HASH = RDF.getURI().length();
    private WType wdesc = new WType(){

        void wTypeStart(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.rdfEl(resource.getURI().substring(RDF_HASH)));
        }

        void wTypeEnd(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.rdfEl(resource.getURI().substring(RDF_HASH)));
        }
    };
    private WType wtype = new WType(){

        void wTypeStart(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.startElementTag(resource.getURI()));
        }

        void wTypeEnd(Resource resource) {
            Unparser.this.print(Unparser.this.prettyWriter.endElementTag(resource.getURI()));
        }
    };
    private Set idDone = new HashSet();
    int[] codeCoverage = new int[8];
    private int indentLevel = 0;
    private int currentColumn = 0;
    private Set infinite;
    private Set openResIterators = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Unparser(Abbreviated abbreviated, String string, Model model, PrintWriter printWriter) throws RDFException {
        Statement statement;
        RDFNode rDFNode;
        Object object;
        this.setLocalName(string);
        this.prettyWriter = abbreviated;
        this.out = printWriter;
        this.model = model;
        this.addTypeNameSpaces();
        this.objectTable = new HashMap();
        StmtIterator stmtIterator = model.listStatements();
        try {
            while (stmtIterator.hasNext()) {
                object = stmtIterator.nextStatement();
                rDFNode = object.getObject();
                if (!(rDFNode instanceof Resource)) continue;
                this.increaseObjectCount((Resource)rDFNode);
            }
            statement = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        try {
            this.res2statement = new HashMap();
            this.statement2res = new HashMap();
            object = new MapFilterIterator(new MapFilter(){

                public Object accept(Object object) {
                    Resource resource = (Resource)object;
                    return resource.hasProperty(RDF.subject) && resource.hasProperty(RDF.object) && resource.hasProperty(RDF.predicate) ? resource : null;
                }
            }, this.model.listSubjectsWithProperty(RDF.type, RDF.Statement));
            while (object.hasNext()) {
                rDFNode = (Resource)object.next();
                try {
                    Statement statement2 = rDFNode.getProperty(RDF.subject);
                    statement = rDFNode.getProperty(RDF.predicate);
                    Statement statement3 = rDFNode.getProperty(RDF.object);
                    RDFNode rDFNode2 = statement3.getObject();
                    Resource resource = (Resource)statement2.getObject();
                    Resource resource2 = (Resource)statement.getObject();
                    Property property = this.model.createProperty(resource2.getURI());
                    Statement statement4 = this.model.createStatement(resource, property, rDFNode2);
                    this.res2statement.put(rDFNode, statement4);
                    this.statement2res.put(statement4, rDFNode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
    }

    private void setLocalName(String string) {
        if (string.equals("")) {
            this.localName = "";
        } else {
            try {
                URI uRI = new URI(string);
                uRI.setFragment(null);
                this.localName = uRI.toString();
            }
            catch (MalformedURIException malformedURIException) {
                throw new RDFException(malformedURIException);
            }
        }
    }

    void write() throws RDFException {
        this.prettyWriter.workOutNamespaces();
        this.wRDF();
    }

    void setTopLevelTypes(Resource[] resourceArray) {
        this.pleasingTypes = resourceArray;
        this.pleasingTypeSet = new HashSet<Resource>(Arrays.asList(resourceArray));
    }

    void setXMLBase(String string) {
        this.xmlBase = string;
    }

    private void wRDF() throws RDFException {
        this.tab();
        this.print("<");
        this.print(this.prettyWriter.rdfEl("RDF"));
        this.indentPlus();
        this.printNameSpaceDefn();
        if (this.xmlBase != null) {
            this.setLocalName(this.xmlBase);
            this.tab();
            this.print("xml:base=" + this.quote(this.xmlBase));
        }
        this.print(">");
        this.wObjStar();
        this.indentMinus();
        this.tab();
        this.print("</");
        this.print(this.prettyWriter.rdfEl("RDF"));
        this.print(">");
        this.tab();
    }

    private void wObjStar() throws RDFException {
        Iterator iterator = this.listSubjects();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            this.increaseObjectCount(resource);
            this.wObj(resource, true);
        }
        this.closeAllResIterators();
    }

    private boolean wPropertyElt(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        return this.wPropertyEltCompact(wType, property, statement, rDFNode) || this.wPropertyEltDamlCollection(wType, property, statement, rDFNode) || this.wPropertyEltLiteral(wType, property, statement, rDFNode) || this.wPropertyEltResource(wType, property, statement, rDFNode) || this.wPropertyEltDatatype(wType, property, statement, rDFNode) || this.wPropertyEltValue(wType, property, statement, rDFNode);
    }

    private boolean wPropertyEltCompact(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        if (!(rDFNode instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!this.allPropsAreAttr(resource) && !this.doing.contains(resource)) {
            return false;
        }
        if (!this.hasProperties(resource) && this.isGenuineAnon(resource)) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.indentPlus();
        this.wIdRefAttrOpt(statement, resource);
        if (!this.doing.contains(resource)) {
            this.wPropAttrAll(resource);
        } else if (this.isGenuineAnon(resource)) {
            this.error("Genuine anon resource in cycle?");
        }
        this.indentMinus();
        this.print("/>");
        return true;
    }

    private boolean wPropertyEltLiteral(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        if (this.prettyWriter.sParseTypeLiteralPropertyElt) {
            return false;
        }
        if (!(rDFNode instanceof Literal) || !((Literal)rDFNode).getWellFormed()) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.wIdAttrReified(statement);
        this.wParseLiteral();
        this.print(">");
        this.print(rDFNode.toString());
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltDatatype(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        if (!(rDFNode instanceof Literal) || ((Literal)rDFNode).getDatatypeURI() == null) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.wIdAttrReified(statement);
        this.wDatatype(((Literal)rDFNode).getDatatypeURI());
        this.print(">");
        this.print(Util.substituteEntitiesInElementContent(((Literal)rDFNode).getLexicalForm()));
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltResource(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        if (this.prettyWriter.sParseTypeResourcePropertyElt) {
            return false;
        }
        if (rDFNode instanceof Literal) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!this.isGenuineAnon(resource)) {
            return false;
        }
        if (this.getType(resource) != null) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.indentPlus();
        this.wIdAttrReified(statement);
        this.wParseResource();
        this.print(">");
        this.wPropertyEltStar(resource);
        this.indentMinus();
        this.tab();
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltValue(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        return this.wPropertyEltValueString(wType, property, statement, rDFNode) || this.wPropertyEltValueObj(wType, property, statement, rDFNode);
    }

    private boolean wPropertyEltValueString(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Literal) {
            this.done(statement);
            Literal literal = (Literal)rDFNode;
            String string = literal.getLanguage();
            this.tab();
            this.print("<");
            wType.wTypeStart(property);
            this.wIdAttrReified(statement);
            if (string != null && string.length() > 0) {
                this.print(" xml:lang=" + this.q(string));
            }
            this.print(">");
            this.wValueString(literal);
            this.print("</");
            wType.wTypeEnd(property);
            this.print(">");
            return true;
        }
        return false;
    }

    private void wValueString(Literal literal) throws RDFException {
        String string = literal.getString();
        this.print(Util.substituteEntitiesInElementContent(string));
    }

    private boolean wPropertyEltValueObj(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Resource && !this.prettyWriter.sResourcePropertyElt) {
            Resource resource = (Resource)rDFNode;
            this.done(statement);
            this.tab();
            this.print("<");
            wType.wTypeStart(property);
            this.wIdAttrReified(statement);
            this.print(">");
            this.tab();
            this.indentPlus();
            this.wObj(resource, false);
            this.indentMinus();
            this.tab();
            this.print("</");
            wType.wTypeEnd(property);
            this.print(">");
            return true;
        }
        return false;
    }

    private boolean wPropertyEltDamlCollection(WType wType, Property property, Statement statement, RDFNode rDFNode) throws RDFException {
        boolean bl = true;
        Statement[][] statementArray = this.getDamlList(rDFNode);
        if (statementArray == null) {
            bl = false;
            statementArray = this.getRDFList(rDFNode);
        }
        if (statementArray == null) {
            return false;
        }
        this.done(statement);
        int n = 0;
        while (n < statementArray.length) {
            this.done(statementArray[n][0]);
            this.done(statementArray[n][1]);
            this.done(statementArray[n][2]);
            ++n;
        }
        this.tab();
        this.print("<");
        wType.wTypeStart(property);
        this.indentPlus();
        this.wIdAttrReified(statement);
        if (bl) {
            this.wParseDamlCollection();
        } else {
            this.wParseCollection();
        }
        this.print(">");
        int n2 = 0;
        while (n2 < statementArray.length) {
            this.wObj((Resource)statementArray[n2][0].getObject(), false);
            ++n2;
        }
        this.indentMinus();
        this.tab();
        this.print("</");
        wType.wTypeEnd(property);
        this.print(">");
        return true;
    }

    private void wPropAttrAll(Resource resource) throws RDFException {
        this.wPropAttrSome(resource);
        if (this.hasProperties(resource)) {
            this.error("Bad call to wPropAttrAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wPropAttrSome(Resource resource) throws RDFException {
        ClosableIterator closableIterator = this.listProperties(resource);
        try {
            HashSet hashSet = new HashSet();
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                RDFNode rDFNode = statement.getObject();
                if (!this.canBeAttribute(statement, hashSet)) continue;
                this.done(statement);
                this.wPropAttr(statement.getPredicate(), statement.getObject());
            }
            Object var7_6 = null;
            closableIterator.close();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            closableIterator.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wObj(Resource resource, boolean bl) throws RDFException {
        block4: {
            block5: {
                boolean bl2;
                try {
                    this.doing.add(resource);
                    Statement statement = this.getType(resource);
                    if (statement == null) break block4;
                    Resource resource2 = statement.getResource();
                    if (bl || !this.pleasingTypeSet.contains(resource2) || this.isGenuineAnon(resource)) break block5;
                    bl2 = this.wTypedNodeNoProperties(resource);
                    Object var7_8 = null;
                    this.doing.remove(resource);
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.doing.remove(resource);
                    throw throwable;
                }
                return bl2;
            }
            boolean bl3 = this.wTypedNode(resource) || this.wDescription(resource);
            Object var7_9 = null;
            this.doing.remove(resource);
            return bl3;
        }
        boolean bl4 = this.wDescription(resource);
        Object var7_10 = null;
        this.doing.remove(resource);
        return bl4;
    }

    private boolean wDescription(Resource resource) throws RDFException {
        return this.wTypedNodeOrDescription(this.wdesc, DESCRIPTION, resource);
    }

    private boolean wTypedNode(Resource resource) throws RDFException {
        Statement statement = this.getType(resource);
        if (statement == null) {
            return false;
        }
        Resource resource2 = statement.getResource();
        this.done(statement);
        return this.wTypedNodeOrDescription(this.wtype, resource2, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wTypedNodeOrDescription(WType wType, Resource resource, Resource resource2) throws RDFException {
        Object object;
        int n;
        Vector<Object> vector = new Vector<Object>();
        ClosableIterator closableIterator = this.listProperties(resource2);
        try {
            n = 0;
            if (!this.prettyWriter.sListExpand) {
                while (closableIterator.hasNext()) {
                    object = (Statement)closableIterator.next();
                    int n2 = object.getPredicate().getOrdinal();
                    if (n2 == 0) continue;
                    if (n2 > n) {
                        vector.setSize(n2);
                    }
                    vector.set(n2 - 1, object);
                }
            }
            Object var10_9 = null;
            closableIterator.close();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            closableIterator.close();
            throw throwable;
        }
        n = vector.indexOf(null);
        object = n == -1 ? vector : vector.subList(0, n);
        return this.wTypedNodeOrDescriptionCompact(wType, resource, resource2, (List)object) || this.wTypedNodeOrDescriptionLong(wType, resource, resource2, (List)object);
    }

    private boolean wTypedNodeOrDescriptionCompact(WType wType, Resource resource, Resource resource2, List list) throws RDFException {
        if (!list.isEmpty() || !this.allPropsAreAttr(resource2)) {
            return false;
        }
        this.tab();
        this.print("<");
        wType.wTypeStart(resource);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource2);
        this.wPropAttrAll(resource2);
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeNoProperties(Resource resource) throws RDFException {
        if (this.isGenuineAnon(resource)) {
            return false;
        }
        Statement statement = this.getType(resource);
        if (statement == null) {
            return false;
        }
        Resource resource2 = statement.getResource();
        this.done(statement);
        this.tab();
        this.print("<");
        this.wtype.wTypeStart(resource2);
        this.indentPlus();
        if (this.hasProperties(resource)) {
            this.wAboutAttr(resource);
        } else {
            this.wIdAboutAttrOpt(resource);
        }
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeOrDescriptionLong(WType wType, Resource resource, Resource resource2, List list) throws RDFException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.done((Statement)iterator.next());
        }
        this.tab();
        this.print("<");
        wType.wTypeStart(resource);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource2);
        this.wPropAttrSome(resource2);
        this.print(">");
        this.wLiEltStar(list.iterator());
        this.wPropertyEltStar(resource2);
        this.indentMinus();
        this.tab();
        this.print("</");
        wType.wTypeEnd(resource);
        this.print(">");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wPropertyEltStar(Resource resource) throws RDFException {
        ClosableIterator closableIterator = this.listProperties(resource);
        try {
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                this.wPropertyElt(this.wtype, statement.getPredicate(), statement, statement.getObject());
            }
            Object var5_4 = null;
            closableIterator.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            closableIterator.close();
            throw throwable;
        }
    }

    private void wLiEltStar(Iterator iterator) throws RDFException {
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            this.wPropertyElt(this.wdesc, LI, statement, statement.getObject());
        }
    }

    private boolean wIdAboutAttrOpt(Resource resource) throws RDFException {
        return this.wIdAttrOpt(resource) || this.wNodeIDAttr(resource) || this.wAboutAttr(resource);
    }

    private boolean wIdAttrOpt(Resource resource) throws RDFException {
        if (this.isGenuineAnon(resource)) {
            return true;
        }
        if (this.prettyWriter.sIdAttr) {
            return false;
        }
        if (resource.isAnon()) {
            return false;
        }
        if (this.isLocalReference(resource)) {
            if (this.wantReification(resource)) {
                return false;
            }
            if (this.idDone.contains(resource)) {
                return false;
            }
            this.idDone.add(resource);
            this.print(" ");
            this.printRdfAt("ID");
            this.print("=");
            this.print(this.quote(this.getLocalName(resource)));
            return true;
        }
        return false;
    }

    private boolean wAboutAttr(Resource resource) throws RDFException {
        this.print(" ");
        this.printRdfAt("about");
        this.print("=");
        this.wURIreference(resource);
        return true;
    }

    private void wURIreference(String string) throws RDFException {
        this.print(this.quote(this.prettyWriter.relativize(string)));
    }

    private void wURIreference(Resource resource) throws RDFException {
        this.wURIreference(resource.getURI());
    }

    private void wIdRefAttrOpt(Statement statement, Resource resource) throws RDFException {
        this.wIdAttrReified(statement);
        if (!this.isGenuineAnon(resource)) {
            this.wResourceNodeIDAttr(resource);
        }
    }

    private void wIdAttrReified(Statement statement) throws RDFException {
        if (this.wantReification(statement)) {
            Statement[] statementArray = this.reification(statement);
            Resource resource = (Resource)this.statement2res.get(statement);
            this.idDone.add(resource);
            int n = 0;
            while (n < statementArray.length) {
                this.done(statementArray[n]);
                ++n;
            }
            this.print(" ");
            this.printRdfAt("ID");
            this.print("=");
            this.print(this.quote(this.getLocalName(resource)));
            this.haveReified.add(resource);
        }
    }

    private boolean wResourceNodeIDAttr(Resource resource) throws RDFException {
        return this.wNodeIDAttr(resource) || this.wResourceAttr(resource);
    }

    private boolean wNodeIDAttr(Resource resource) throws RDFException {
        if (!resource.isAnon()) {
            return false;
        }
        this.print(" ");
        this.printRdfAt("nodeID");
        this.print("=");
        this.print(this.q(this.prettyWriter.anonId(resource)));
        return true;
    }

    private boolean wResourceAttr(Resource resource) throws RDFException {
        if (resource.isAnon()) {
            return false;
        }
        this.print(" ");
        this.printRdfAt("resource");
        this.print("=");
        this.wURIreference(resource);
        return true;
    }

    private void wQnameStart(String string, String string2) throws RDFException {
        this.print(this.prettyWriter.startElementTag(string, string2));
    }

    private void wQnameEnd(String string, String string2) throws RDFException {
        this.print(this.prettyWriter.endElementTag(string, string2));
    }

    private void wQNameAttr(Property property) throws RDFException {
        this.print(this.prettyWriter.attributeTag(property.getURI()));
    }

    private void printRdfAt(String string) {
        this.print(this.prettyWriter.rdfAt(string));
    }

    private void wPropAttr(Property property, RDFNode rDFNode) throws RDFException {
        this.tab();
        if (property.equals(RDF.type)) {
            this.wTypeAttr((Resource)rDFNode);
        } else {
            this.wPropAttrString(property, (Literal)rDFNode);
        }
    }

    private void wTypeAttr(Resource resource) throws RDFException {
        this.print(" ");
        this.printRdfAt("type");
        this.print("=");
        this.wURIreference(resource);
    }

    private void wPropAttrString(Property property, Literal literal) throws RDFException {
        this.print(" ");
        this.wQNameAttr(property);
        this.print("=" + this.quote(literal.getString()));
    }

    private void wParseDamlCollection() throws RDFException {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("daml:collection"));
    }

    private void wParseCollection() throws RDFException {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Collection"));
    }

    private void wParseLiteral() throws RDFException {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Literal"));
    }

    private void wDatatype(String string) throws RDFException {
        this.print(" ");
        this.printRdfAt("datatype");
        this.print("=");
        this.wURIreference(string);
    }

    private void wParseResource() throws RDFException {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Resource"));
    }

    private void printNameSpaceDefn() {
        this.print(this.prettyWriter.xmlnsDecl());
    }

    private static String filler(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private void tab() {
        int n = this.prettyWriter.tab * this.indentLevel;
        if (n == 0 && this.currentColumn == 0 || n > this.currentColumn) {
            String string = Unparser.filler(n - this.currentColumn);
            this.out.print(string);
        } else {
            this.out.println();
            this.out.print(Unparser.filler(n));
        }
        this.currentColumn = n;
    }

    private String quote(String string) {
        return this.prettyWriter.qq(string);
    }

    private String q(String string) {
        return this.prettyWriter.q(string);
    }

    private void print(String string) {
        this.out.print(string);
        int n = string.lastIndexOf(10);
        this.currentColumn = n == -1 ? (this.currentColumn += string.length()) : string.length() - n - 1;
    }

    private void indentPlus() {
        ++this.indentLevel;
    }

    private void indentMinus() {
        --this.indentLevel;
    }

    private void error(String string) {
        RuntimeException runtimeException = new RuntimeException("Internal error in Unparser: " + string);
        this.prettyWriter.fatalError(runtimeException);
        throw runtimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTypeNameSpaces() {
        NodeIterator nodeIterator = this.model.listObjectsOfProperty(RDF.type);
        try {
            while (nodeIterator.hasNext()) {
                RDFNode rDFNode = nodeIterator.nextNode();
                int n = this.isOKType(rDFNode);
                if (n == -1) continue;
                this.prettyWriter.addNameSpace(((Resource)rDFNode).getURI().substring(0, n));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            nodeIterator.close();
            throw throwable;
        }
        nodeIterator.close();
    }

    private String getNameSpace(Resource resource) {
        if (resource.isAnon()) {
            Log.severe("Internal error - giving up", "Unparser", "getNameSpace");
            throw new RuntimeException("Internal error");
        }
        String string = resource.getURI();
        int n = Util.splitNamespace(string);
        return string.substring(0, n);
    }

    private boolean isGenuineAnon(Resource resource) {
        if (!resource.isAnon()) {
            return false;
        }
        Integer n = (Integer)this.objectTable.get(resource);
        return n == null || !this.prettyWriter.sResourcePropertyElt && n <= 1 && !this.haveReified.contains(resource);
    }

    private boolean isLocalReference(Resource resource) throws RDFException {
        return !resource.isAnon() && this.getNameSpace(resource).equals(this.localName + "#") && XMLChar.isValidNCName((String)this.getLocalName(resource));
    }

    private static String getSuffix(int n) {
        if (n == 0) {
            return "";
        }
        int n2 = --n / 26;
        return Unparser.getSuffix(n2) + new Character((char)(97 + n % 26));
    }

    private String getLocalName(Resource resource) throws RDFException {
        if (resource.isAnon()) {
            Log.severe("Internal error - giving up", "Unparser", "getLocalName");
            throw new RuntimeException("Internal error");
        }
        String string = resource.getURI();
        int n = Util.splitNamespace(string);
        return string.substring(n);
    }

    private void increaseObjectCount(Resource resource) {
        Integer n = (Integer)this.objectTable.get(resource);
        n = n == null ? one : new Integer(n + 1);
        this.objectTable.put(resource, n);
    }

    private boolean wantReification(Statement statement) {
        return this.wantReification(statement, (Resource)this.statement2res.get(statement));
    }

    private boolean wantReification(Resource resource) {
        return this.wantReification((Statement)this.res2statement.get(resource), resource);
    }

    private boolean wantReification(Statement statement, Resource resource) throws RDFException {
        if (statement == null || resource == null || resource.isAnon() || this.prettyWriter.sReification) {
            return false;
        }
        if (!this.isLocalReference(resource)) {
            return false;
        }
        Statement[] statementArray = this.reification(statement);
        int n = 0;
        while (n < statementArray.length) {
            if (this.doneSet.contains(statementArray[n]) || !this.model.contains(statementArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Statement[] reification(Statement statement) throws RDFException {
        Model model = statement.getModel();
        Resource resource = (Resource)this.statement2res.get(statement);
        return new Statement[]{model.createStatement(resource, RDF.type, RDF.Statement), model.createStatement(resource, RDF.subject, statement.getSubject()), model.createStatement(resource, RDF.predicate, statement.getPredicate()), model.createStatement(resource, RDF.object, statement.getObject())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProperties(Resource resource) throws RDFException {
        ClosableIterator closableIterator = this.listProperties(resource);
        if (this.avoidExplicitReification && !resource.isAnon() && this.isLocalReference(resource) && this.res2statement.containsKey(resource)) {
            closableIterator = new MapFilterIterator(new MapFilter(){

                public Object accept(Object object) {
                    Statement statement = (Statement)object;
                    Property property = statement.getPredicate();
                    String string = property.getLocalName();
                    return !property.getNameSpace().equals(rdfns) || (!RDF.type.equals(property) || !statement.getObject().equals(RDF.Statement)) && !RDF.object.equals(property) && !RDF.predicate.equals(property) && !RDF.subject.equals(property) ? object : null;
                }
            }, closableIterator);
        }
        try {
            boolean bl = closableIterator.hasNext();
            Object var5_4 = null;
            closableIterator.close();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            closableIterator.close();
            throw throwable;
        }
    }

    private ClosableIterator listProperties(Resource resource) throws RDFException {
        return new MapFilterIterator(new MapFilter(){

            public Object accept(Object object) {
                return Unparser.this.doneSet.contains(object) ? null : object;
            }
        }, resource.listProperties());
    }

    private boolean canBeAttribute(Statement statement, Set set) throws RDFException {
        Property property = statement.getPredicate();
        if (this.prettyWriter.sPropertyAttr || set.contains(property)) {
            return false;
        }
        set.add(property);
        if (property.equals(RDF.type)) {
            RDFNode rDFNode = statement.getObject();
            return rDFNode instanceof Resource && !((Resource)rDFNode).isAnon();
        }
        if (statement.getObject() instanceof Literal) {
            String string;
            Literal literal = statement.getLiteral();
            if (literal.getDatatypeURI() != null) {
                return false;
            }
            if (literal.getLanguage().equals("") && (string = literal.getString()).length() < 40) {
                char[] cArray = string.toCharArray();
                int n = 0;
                while (n < cArray.length) {
                    if (cArray[n] <= ' ') {
                        return false;
                    }
                    ++n;
                }
                return !this.wantReification(statement);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean allPropsAreAttr(Resource resource) throws RDFException {
        ClosableIterator closableIterator = this.listProperties(resource);
        HashSet hashSet = new HashSet();
        try {
            block3: {
                Statement statement;
                do {
                    if (!closableIterator.hasNext()) break block3;
                } while (this.canBeAttribute(statement = (Statement)closableIterator.next(), hashSet));
                boolean bl = false;
                Object var7_6 = null;
                closableIterator.close();
                return bl;
            }
            Object var7_7 = null;
            closableIterator.close();
            return true;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            closableIterator.close();
            throw throwable;
        }
    }

    private void done(Statement statement) {
        this.doneSet.add(statement);
    }

    private Statement[][] getDamlList(RDFNode rDFNode) {
        return this.prettyWriter.sDamlCollection ? null : this.getList(rDFNode, DAML_OIL.List, DAML_OIL.first, DAML_OIL.rest, DAML_OIL.nil);
    }

    private Statement[][] getRDFList(RDFNode rDFNode) {
        return this.prettyWriter.sParseTypeCollectionPropertyElt ? null : this.getList(rDFNode, RDF.List, RDF.first, RDF.rest, RDF.nil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Statement[][] getList(RDFNode rDFNode, Resource resource, Property property, Property property2, Resource resource2) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        RDFNode rDFNode2 = rDFNode;
        block2: while (true) {
            Object var19_17;
            StmtIterator stmtIterator;
            block21: {
                Statement[][] statementArray;
                block26: {
                    Statement[][] statementArray2;
                    block25: {
                        Statement[][] statementArray3;
                        block24: {
                            Statement[][] statementArray4;
                            block23: {
                                Statement[][] statementArray5;
                                if (rDFNode2.equals(resource2)) {
                                    if (vector.size() != 0) break;
                                    return null;
                                }
                                objectArray = new Statement[3];
                                if (rDFNode2 instanceof Literal) {
                                    return null;
                                }
                                Resource resource3 = (Resource)rDFNode2;
                                if (!this.isGenuineAnon(resource3)) {
                                    return null;
                                }
                                if (hashSet.contains(rDFNode2)) {
                                    return null;
                                }
                                hashSet.add(rDFNode2);
                                stmtIterator = resource3.listProperties();
                                try {
                                    while (true) {
                                        int n;
                                        if (!stmtIterator.hasNext()) {
                                            break block21;
                                        }
                                        Statement statement = stmtIterator.nextStatement();
                                        Property property3 = statement.getPredicate();
                                        RDFNode rDFNode3 = statement.getObject();
                                        if (this.doneSet.contains(statement)) {
                                            statementArray5 = null;
                                            var19_17 = null;
                                            break;
                                        }
                                        if (!(rDFNode3 instanceof Resource)) {
                                            statementArray4 = null;
                                            break block23;
                                        }
                                        if (property3.equals(RDF.type)) {
                                            n = 2;
                                            if (!rDFNode3.equals(resource)) {
                                                statementArray3 = null;
                                                break block24;
                                            }
                                        } else if (property3.equals(property)) {
                                            n = 0;
                                        } else {
                                            if (!property3.equals(property2)) {
                                                statementArray2 = null;
                                                break block25;
                                            }
                                            n = 1;
                                            rDFNode2 = rDFNode3;
                                        }
                                        if (objectArray[n] != null) {
                                            statementArray = null;
                                            break block26;
                                        }
                                        objectArray[n] = statement;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var19_17 = null;
                                    stmtIterator.close();
                                    throw throwable;
                                }
                                stmtIterator.close();
                                return statementArray5;
                            }
                            var19_17 = null;
                            stmtIterator.close();
                            return statementArray4;
                        }
                        var19_17 = null;
                        stmtIterator.close();
                        return statementArray3;
                    }
                    var19_17 = null;
                    stmtIterator.close();
                    return statementArray2;
                }
                var19_17 = null;
                stmtIterator.close();
                return statementArray;
            }
            var19_17 = null;
            stmtIterator.close();
            int n = 0;
            while (true) {
                if (n >= 3) {
                    vector.add(objectArray);
                    continue block2;
                }
                if (objectArray[n] == null) {
                    return null;
                }
                ++n;
            }
            break;
        }
        objectArray = new Statement[vector.size()][];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Statement getType(Resource resource) throws RDFException {
        Statement statement;
        try {
            if (resource instanceof Statement) {
                statement = ((Statement)((Object)resource)).getStatementProperty(RDF.type);
                if (statement == null || !statement.getObject().equals(RDF.Statement)) {
                    this.error("Statement type problem");
                }
            } else {
                statement = resource.getProperty(RDF.type);
            }
        }
        catch (RDFException rDFException) {
            if (rDFException.getErrorCode() == 6) {
                if (resource instanceof Statement) {
                    this.error("Statement type problem");
                }
                statement = null;
            }
            throw rDFException;
        }
        if (statement == null || this.isOKType(statement.getObject()) == -1) {
            return null;
        }
        return statement;
    }

    private int isOKType(RDFNode rDFNode) {
        if (!(rDFNode instanceof Resource)) {
            return -1;
        }
        if (((Resource)rDFNode).isAnon()) {
            return -1;
        }
        String string = ((Resource)rDFNode).getURI();
        int n = Util.splitNamespace(string);
        if (n == 0 || n == string.length()) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInfiniteCycles() throws RDFException {
        StmtIterator stmtIterator = this.model.listStatements();
        Relation relation = new Relation();
        try {
            while (stmtIterator.hasNext()) {
                RDFNode rDFNode;
                Statement statement = stmtIterator.nextStatement();
                if (this.doneSet.contains(statement) || !((rDFNode = statement.getObject()) instanceof Resource)) continue;
                relation.set(statement.getSubject(), rDFNode);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        relation.transitiveClosure();
        this.infinite = relation.getDiagonal();
    }

    private Iterator allInfiniteLeft() {
        return new LateBindingIterator(){

            public Iterator create() {
                return Unparser.this.infinite.iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator pleasingTypeIterator() throws RDFException {
        if (this.pleasingTypes == null) {
            return new NullIterator();
        }
        HashMap<Resource, Set> hashMap = new HashMap<Resource, Set>();
        Set[] setArray = new Set[this.pleasingTypes.length];
        int n = 0;
        while (n < this.pleasingTypes.length) {
            setArray[n] = new HashSet();
            hashMap.put(this.pleasingTypes[n], setArray[n]);
            ++n;
        }
        ResIterator resIterator = this.model.listSubjects();
        try {
            while (resIterator.hasNext()) {
                Integer n2;
                Set set;
                Resource resource = resIterator.nextResource();
                Statement statement = this.getType(resource);
                if (statement == null || (set = (Set)hashMap.get(statement.getObject())) == null || this.isGenuineAnon(resource) && (n2 = (Integer)this.objectTable.get(resource)) != null && n2 == 1) continue;
                set.add(resource);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            resIterator.close();
            throw throwable;
        }
        resIterator.close();
        return new IteratorIterator(new Map1Iterator(new Map1(){

            public Object map1(Object object) {
                return ((Set)object).iterator();
            }
        }, new ArrayIterator(setArray)));
    }

    private Iterator listSubjects() throws RDFException {
        ArrayIterator arrayIterator = new ArrayIterator(new Resource[]{this.model.createResource(this.localName)});
        Iterator iterator = this.pleasingTypeIterator();
        NullIterator nullIterator = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.pleasingTypeSet = new HashSet();
                return false;
            }
        };
        FilterIterator filterIterator = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                return !Unparser.this.objectTable.containsKey(object) && !Unparser.this.wantReification((Resource)object);
            }
        }, this.modelListSubjects());
        NullIterator nullIterator2 = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.findInfiniteCycles();
                return false;
            }
        };
        FilterIterator filterIterator2 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Resource resource = (Resource)object;
                Unparser.this.codeCoverage[4] = Unparser.this.codeCoverage[4] + 1;
                if (resource.isAnon()) {
                    return false;
                }
                Integer n = (Integer)Unparser.this.objectTable.get(resource);
                return n != null && n > 1;
            }
        }, this.allInfiniteLeft());
        FilterIterator filterIterator3 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Unparser.this.codeCoverage[5] = Unparser.this.codeCoverage[5] + 1;
                Resource resource = (Resource)object;
                return !Unparser.this.isGenuineAnon(resource);
            }
        }, this.allInfiniteLeft());
        Iterator iterator2 = this.allInfiniteLeft();
        NullIterator nullIterator3 = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.avoidExplicitReification = false;
                return false;
            }
        };
        FilterIterator filterIterator4 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Unparser.this.codeCoverage[6] = Unparser.this.codeCoverage[6] + 1;
                return Unparser.this.res2statement.containsKey(object);
            }
        }, this.allInfiniteLeft());
        Iterator iterator3 = this.modelListSubjects();
        Iterator[] iteratorArray = new Iterator[]{arrayIterator, iterator, nullIterator, filterIterator, nullIterator2, filterIterator2, filterIterator3, iterator2, nullIterator3, filterIterator4, new NullIterator(){

            public boolean hasNext() {
                if (Unparser.this.modelListSubjects().hasNext()) {
                    Unparser.this.codeCoverage[7] = Unparser.this.codeCoverage[7] + 1;
                }
                return false;
            }
        }, iterator3};
        IteratorIterator iteratorIterator = new IteratorIterator(new ArrayIterator(iteratorArray));
        return new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                return Unparser.this.hasProperties((Resource)object);
            }
        }, iteratorIterator);
    }

    private synchronized void close(ResIterator resIterator) throws RDFException {
        resIterator.close();
        this.openResIterators.remove(resIterator);
    }

    private synchronized void closeAllResIterators() throws RDFException {
        Iterator iterator = this.openResIterators.iterator();
        while (iterator.hasNext()) {
            ((ResIterator)iterator.next()).close();
        }
        this.openResIterators = new HashSet();
    }

    private Iterator modelListSubjects() {
        ResIterator resIterator = this.model.listSubjects();
        this.openResIterators.add(resIterator);
        return resIterator;
    }

    private abstract class WType {
        private WType() {
        }

        abstract void wTypeStart(Resource var1);

        abstract void wTypeEnd(Resource var1);
    }
}

