/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import java.io.PrintWriter;

public class Basic
extends BaseXMLWriter {
    static String RDFNS = RDF.getURI();
    private String space;
    private boolean blockLiterals = false;

    void writeBody(Model model, PrintWriter printWriter, String string, boolean bl) {
        this.space = "";
        int n = 0;
        while (n < this.tab) {
            this.space = this.space + " ";
            ++n;
        }
        this.writeRDFHeader(model, printWriter);
        this.writeRDFStatements(model, printWriter);
        this.writeRDFTrailer(printWriter, string);
        printWriter.flush();
    }

    private void writeRDFHeader(Model model, PrintWriter printWriter) {
        String string = this.xmlnsDecl();
        NsIterator nsIterator = model.listNameSpaces();
        printWriter.print("<" + this.rdfEl("RDF") + string);
        if (null != this.xmlBase && this.xmlBase.length() > 0) {
            printWriter.print("\n  xml:base=" + this.qq(this.xmlBase));
        }
        printWriter.println(" >");
    }

    protected void writeRDFStatements(Model model, PrintWriter printWriter) throws RDFException {
        ResIterator resIterator = model.listSubjects();
        while (resIterator.hasNext()) {
            this.writeRDFStatements(model, resIterator.nextResource(), printWriter);
        }
    }

    protected void writeRDFTrailer(PrintWriter printWriter, String string) {
        printWriter.println("</" + this.rdfEl("RDF") + ">");
    }

    protected void writeRDFStatements(Model model, Resource resource, PrintWriter printWriter) throws RDFException {
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(resource, null, (RDFNode)null));
        this.writeDescriptionHeader(resource, printWriter);
        while (stmtIterator.hasNext()) {
            this.writePredicate(stmtIterator.nextStatement(), printWriter);
        }
        this.writeDescriptionTrailer(printWriter);
    }

    protected void writeDescriptionHeader(Resource resource, PrintWriter printWriter) throws RDFException {
        printWriter.print(this.space + "<" + this.rdfEl("Description") + " ");
        this.writeResourceId(resource, printWriter);
        printWriter.println(">");
    }

    protected void writePredicate(Statement statement, PrintWriter printWriter) throws RDFException {
        Property property = statement.getPredicate();
        RDFNode rDFNode = statement.getObject();
        printWriter.print(this.space + this.space + "<" + this.startElementTag(property.getNameSpace(), property.getLocalName()));
        if (rDFNode instanceof Resource) {
            printWriter.print(" ");
            this.writeResourceReference((Resource)rDFNode, printWriter);
            printWriter.println("/>");
        } else {
            this.writeLiteral((Literal)rDFNode, printWriter);
            printWriter.println("</" + this.endElementTag(property.getNameSpace(), property.getLocalName()) + ">");
        }
    }

    void unblockAll() {
        this.blockLiterals = false;
    }

    void blockRule(Resource resource) {
        if (resource.equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.blockLiterals = true;
        } else {
            BaseXMLWriter.logger.warn((Object)("Cannot block rule <" + resource.getURI() + ">"));
        }
    }

    protected void writeDescriptionTrailer(PrintWriter printWriter) {
        printWriter.println(this.space + "</" + this.rdfEl("Description") + ">");
    }

    protected void writeResourceId(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource.isAnon()) {
            printWriter.print(this.rdfAt("nodeID") + "=" + this.q(this.anonId(resource)));
        } else {
            printWriter.print(this.rdfAt("about") + "=" + this.qq(this.relativize(resource.getURI())));
        }
    }

    protected void writeResourceReference(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource.isAnon()) {
            printWriter.print(this.rdfAt("nodeID") + "=" + this.q(this.anonId(resource)));
        } else {
            printWriter.print(this.rdfAt("resource") + "=" + this.qq(this.relativize(resource.getURI())));
        }
    }

    protected void writeLiteral(Literal literal, PrintWriter printWriter) {
        String string = literal.getLanguage();
        if (!string.equals("")) {
            printWriter.print(" xml:lang=" + this.q(string));
        }
        if (literal.getWellFormed() && !this.blockLiterals) {
            printWriter.print(" " + this.rdfAt("parseType") + "=" + this.q("Literal") + ">");
            printWriter.print(literal.toString());
        } else {
            String string2 = literal.getDatatypeURI();
            if (string2 != null) {
                printWriter.print(" " + this.rdfAt("datatype") + "=" + this.qq(string2) + ">");
                printWriter.print(Util.substituteEntitiesInElementContent(literal.getLexicalForm()));
            } else {
                printWriter.print(">");
                printWriter.print(Util.substituteEntitiesInElementContent(literal.toString()));
            }
        }
    }
}

