/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheManager;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCache
extends TestCase {
    public TestCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("Cache");
        testSuite.addTest((Test)new CacheTestCase("RAND"));
        return testSuite;
    }

    public void assertFalse(String string, boolean bl) {
        Assert.assertTrue((String)string, (!bl ? 1 : 0) != 0);
    }

    private void assertDiffer(String string, Object object, Object object2) {
        this.assertFalse(string, object.equals(object2));
    }

    static class CacheTestCase
    extends TestCase {
        String cacheType;

        CacheTestCase(String string) {
            super(string);
            this.cacheType = string;
        }

        protected void runTest() {
            this.testCache();
        }

        public void testCache() {
            this.testCacheCreation(this.cacheType);
            this.testCacheSimpleReturn(this.cacheType);
            this.testFillTheCache(this.cacheType);
        }

        public void testCacheCreation(String string) {
            Cache cache = CacheManager.createCache(string, "c1", 100);
            try {
                Cache cache2 = CacheManager.createCache(string, "c2", 1);
                Assert.assertTrue((String)("Missing error on bad cache size: " + string), (boolean)false);
            }
            catch (Error error) {}
        }

        public void testCacheSimpleReturn(String string) {
            Integer n;
            Integer n2;
            String string2;
            String string3;
            int n4 = 100;
            Cache cache = CacheManager.createCache(string, "c1", n4);
            String string4 = string3 = (string2 = "one");
            Integer n5 = n2 = (n = new Integer(-1));
            cache.put(string2, n);
            int n6 = 0;
            while (n6 < n4) {
                string2 = string3;
                n = n2;
                Object object = cache.get(string2);
                Assert.assertTrue((String)"expected a hit", (object != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"should be the expected object", (Object)object, (Object)n);
                string3 = string4;
                n2 = n5;
                object = cache.get(string3);
                Assert.assertTrue((String)"expected a hit", (object != null ? 1 : 0) != 0);
                Assert.assertEquals((String)"should be the expected object", (Object)object, (Object)n2);
                string4 = "T" + n6;
                n5 = new Integer(n6);
                cache.put(string4, n5);
                ++n6;
            }
        }

        public void testFillTheCache(String string) {
            Cache cache = CacheManager.createCache(string, "c1", 100);
            String[] stringArray = new String[100];
            String[] stringArray2 = new String[100];
            int n = 0;
            while (n < 100) {
                stringArray[n] = "K" + n;
                stringArray2[n] = "V" + n;
                cache.put(stringArray[n], stringArray2[n]);
                ++n;
            }
            int n2 = 0;
            int n4 = 0;
            while (n4 < 100) {
                if (cache.get(stringArray[n4]) != null) {
                    ++n2;
                }
                ++n4;
            }
            Assert.assertTrue((String)("too low a hit rate: " + string + " = " + n2), (n2 > 50 ? 1 : 0) != 0);
            Assert.assertEquals((String)"count puts", (long)100L, (long)cache.getPuts());
            Assert.assertEquals((String)"count gets", (long)100L, (long)cache.getGets());
            Assert.assertEquals((String)"count hits", (long)n2, (long)cache.getHits());
        }
    }
}

