/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;

public abstract class ClosableWrapper
extends NiceIterator
implements Iterator {
    protected Iterator iterator;

    public ClosableWrapper(Iterator iterator) {
        this.iterator = iterator;
    }

    public boolean hasNext() {
        return this.mustBeUnclosed().hasNext();
    }

    public void remove() {
        this.mustBeUnclosed().remove();
    }

    public Object next() {
        return this.mustBeUnclosed().next();
    }

    protected Iterator mustBeUnclosed() {
        if (this.iterator == null) {
            throw new RDFException(8);
        }
        return this.iterator;
    }

    public void close() {
        if (this.iterator != null) {
            WrappedIterator.close(this.iterator);
        }
        this.iterator = null;
    }
}

