/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.cache;

import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheControl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class RandCache
implements Cache,
CacheControl {
    int size;
    int threshhold;
    boolean enabled = true;
    String name;
    HashMap map;
    Collection collection;
    long gets = 0L;
    long puts = 0L;
    long hits = 0L;

    RandCache(String string, int n) {
        this.size = n;
        this.map = new HashMap(n * 100 / 75);
        this.threshhold = n;
        if (this.threshhold < 2) {
            throw new Error("Cache size too small: " + n);
        }
        this.collection = this.map.values();
    }

    public Object get(Object object) {
        if (this.enabled) {
            if (this.gets == Long.MAX_VALUE) {
                this.forgetStats();
            }
            ++this.gets;
            Object v = this.map.get(object);
            if (v != null) {
                ++this.hits;
            }
            return v;
        }
        return null;
    }

    public void put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        if (this.enabled) {
            if (this.puts == Long.MAX_VALUE) {
                this.forgetStats();
            }
            ++this.puts;
            if (this.map.size() >= this.threshhold) {
                this.makeSpace();
            }
            this.map.put(object, object2);
        }
    }

    protected void makeSpace() {
        Iterator iterator = this.collection.iterator();
        int n = this.map.size();
        int n2 = 3;
        while (n2 < n) {
            iterator.next();
            iterator.remove();
            iterator.next();
            iterator.next();
            n2 += 3;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean bl) {
        boolean bl2 = bl;
        this.enabled = bl;
        return bl2;
    }

    public void clear() {
        this.map.clear();
    }

    public long getHits() {
        return this.hits;
    }

    public long getGets() {
        return this.gets;
    }

    public long getPuts() {
        return this.puts;
    }

    protected void forgetStats() {
        this.gets /= 2L;
        this.puts /= 2L;
        this.hits /= 2L;
    }
}

