/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class ModelLoader {
    static Logger logger = Logger.getLogger((String)(class$com$hp$hpl$jena$util$ModelLoader == null ? (class$com$hp$hpl$jena$util$ModelLoader = ModelLoader.class$("com.hp.hpl.jena.util.ModelLoader")) : class$com$hp$hpl$jena$util$ModelLoader).getName());
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langBDB = "RDF/BDB";
    public static final String langSQL = "RDF/SQL";
    public static String defaultLanguage = "RDF/XML";
    public static String basename = null;
    public static boolean useARP = true;
    static /* synthetic */ Class class$com$hp$hpl$jena$util$ModelLoader;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$JenaReader;

    public static Model loadModel(String string) {
        return ModelLoader.loadModel(string, null);
    }

    public static Model loadModel(String string, String string2) {
        return ModelLoader.loadModel(string, string2, "", "");
    }

    public static Model loadModel(String string, String string2, String string3, String string4) {
        if (string2 == null) {
            string2 = ModelLoader.guessLang(string);
        }
        if (string2 == null) {
            string2 = defaultLanguage;
        }
        if (string2.equals(langBDB)) {
            Log.severe("Failed to open Berkeley database", "ModelLoader", "loadModel");
            System.exit(1);
        }
        if (string2.equals(langSQL)) {
            if (basename != null) {
                string = basename + File.separator + string;
            }
            Log.debug("SQL: file=" + string, "ModelLoader", "loadModel");
            Log.severe("Failed to open SQL database", "ModelLoader", "loadModel");
            System.exit(1);
        }
        ModelMem modelMem = new ModelMem();
        modelMem.setReaderClassName(langXML, (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = ModelLoader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
        modelMem.setReaderClassName(langXMLAbbrev, (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = ModelLoader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
        try {
            ModelLoader.loadModel(modelMem, string, string2);
        }
        catch (RDFException rDFException) {
            Log.warning("Error loading data source", "ModelLoader", "loadModel", rDFException);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.warning("No such data source: " + string, "ModelLoader", "loadModel", fileNotFoundException);
            return null;
        }
        return modelMem;
    }

    public static Model loadModel(Model model, String string, String string2) throws RDFException, FileNotFoundException {
        Object object;
        if (string2 == null) {
            string2 = ModelLoader.guessLang(string);
        }
        if (string2.equals(langBDB) || string2.equals(langSQL)) {
            Log.severe("Can't load data into existing model from a persistent database", "ModelLoader", "loadModel");
            return null;
        }
        String string3 = "file://unknown.net/";
        BufferedReader bufferedReader = null;
        try {
            object = new URL(string);
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            string3 = string;
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = string;
            File file = basename != null ? new File(basename, string4) : new File(string4);
            string3 = ("file:///" + file.getAbsolutePath()).replace('\\', '/');
            FileReader fileReader = ModelLoader.tryFile(basename, string4);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            Log.severe("IOException: " + iOException, "ModelLoader", "loadModel", iOException);
            return null;
        }
        object = model.getReader(string2);
        if (object instanceof JenaReader) {
            object.setProperty("error-mode", "lax");
        }
        object.read(model, bufferedReader, string3);
        try {
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            logger.warn((Object)"IOException closing reader", (Throwable)iOException);
        }
        return model;
    }

    private static FileReader tryFile(String string, String string2) throws FileNotFoundException {
        try {
            return new FileReader(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new FileReader(new File(string, string2));
        }
    }

    public static String guessLang(String string) {
        String string2 = null;
        if (string.startsWith("jdbc:") || string.startsWith("JDBC:")) {
            return langSQL;
        }
        String string3 = ModelLoader.getFilenameExt(string);
        if (string3 != null && string3.length() > 0) {
            if (string3.equalsIgnoreCase("rdf")) {
                string2 = langXML;
            } else if (string3.equalsIgnoreCase("nt")) {
                string2 = langNTriple;
            } else if (string3.equalsIgnoreCase("n3")) {
                string2 = langN3;
            } else if (string3.equalsIgnoreCase("bdb")) {
                string2 = langBDB;
            }
        }
        return string2;
    }

    public static void setFileBase(String string) {
        basename = string;
    }

    private static String getFilenameExt(String string) {
        int n = 0;
        int n2 = 0;
        n = string.lastIndexOf(47);
        int n4 = string.lastIndexOf(92);
        if (n4 > n) {
            n = n4;
        }
        if ((n2 = string.lastIndexOf(46)) > n) {
            String string2 = string.substring(n2 + 1).toLowerCase();
            return string2;
        }
        return "";
    }

    private static String getDirname(String string) {
        File file = new File(string);
        return file.getParent();
    }

    private static String getBasename(String string) {
        File file = new File(string);
        return file.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

