/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.LogFileHandler;
import com.hp.hpl.jena.util.LogHandler;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    public static final int SEVERE = 7;
    public static final int WARNING = 6;
    public static final int INFO = 5;
    public static final int CONFIG = 4;
    public static final int FINE = 3;
    public static final int FINER = 2;
    public static final int FINEST = 1;
    public static final int OFF = 8;
    public static final int DEBUG = 3;
    public static final String DEFAULT_LOG_FILE_NAME = "jena.log";
    public static final int DEFAULT_LEVEL = 4;
    public static final String[] LEVEL_NAMES = new String[]{"OFF", "FINEST", "FINER", "FINE", "CONFIG", "INFO", "WARNING", "SEVERE"};
    private static Log s_instance = new Log();
    private static SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z ");
    private static boolean s_showDate = true;
    private LogHandler m_handler = null;
    private int m_logLevel = 4;

    private Log() {
        this.setConsoleHandler();
    }

    public static final Log getInstance() {
        return s_instance;
    }

    public void setLevel(int n) {
        this.m_logLevel = n;
    }

    public int getLevel() {
        return this.m_logLevel;
    }

    public static String getLevelName(int n) {
        if (n >= 8 && n <= 7) {
            return LEVEL_NAMES[n];
        }
        return "UNKNOWN";
    }

    public void setHandler(LogHandler logHandler) {
        if (this.m_handler != null) {
            this.m_handler.close();
        }
        this.m_handler = logHandler;
    }

    public void setDefaultFileHandler() throws IOException {
        this.setFileHandler(DEFAULT_LOG_FILE_NAME);
    }

    public void setDefaultFileHandler(boolean bl) throws IOException {
        this.setFileHandler(DEFAULT_LOG_FILE_NAME, bl);
    }

    public void setFileHandler(String string) throws IOException {
        this.setFileHandler(string, false);
    }

    public void setFileHandler(String string, boolean bl) throws IOException {
        LogFileHandler logFileHandler = new LogFileHandler(string, bl);
        this.setHandler(logFileHandler);
    }

    public void setConsoleHandler() {
        LogHandler logHandler = new LogHandler(){

            public void publish(int n, String string, String string2, String string3, Throwable throwable) {
                System.err.print(Log.getLevelName(n));
                System.err.print(' ');
                System.err.print(Log.formatDate());
                if (string2 != null) {
                    System.err.print("In " + string2 + "." + string3 + "(): ");
                }
                System.err.println(string);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }

            public void close() {
            }
        };
        this.setHandler(logHandler);
    }

    public void setShowDate(boolean bl) {
        s_showDate = bl;
    }

    public boolean getShowDate() {
        return s_showDate;
    }

    public static String formatDate() {
        if (s_showDate) {
            return s_dateFormat.format(new Date());
        }
        return "";
    }

    public static void severe(String string) {
        Log.getInstance().logMessage(string, 7, null, null, null);
    }

    public static void severe(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 7, null, null, throwable);
    }

    public static void severe(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 7, string2, string3, null);
    }

    public static void severe(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 7, string2, string3, throwable);
    }

    public static void warning(String string) {
        Log.getInstance().logMessage(string, 6, null, null, null);
    }

    public static void warning(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 6, null, null, throwable);
    }

    public static void warning(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 6, string2, string3, null);
    }

    public static void warning(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 6, string2, string3, throwable);
    }

    public static void info(String string) {
        Log.getInstance().logMessage(string, 5, null, null, null);
    }

    public static void info(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 5, null, null, throwable);
    }

    public static void info(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 5, string2, string3, null);
    }

    public static void info(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 5, string2, string3, throwable);
    }

    public static void config(String string) {
        Log.getInstance().logMessage(string, 4, null, null, null);
    }

    public static void config(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 4, null, null, throwable);
    }

    public static void config(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 4, string2, string3, null);
    }

    public static void config(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 4, string2, string3, throwable);
    }

    public static void fine(String string) {
        Log.getInstance().logMessage(string, 3, null, null, null);
    }

    public static void fine(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 3, null, null, throwable);
    }

    public static void fine(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 3, string2, string3, null);
    }

    public static void fine(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 3, string2, string3, throwable);
    }

    public static void finer(String string) {
        Log.getInstance().logMessage(string, 2, null, null, null);
    }

    public static void finer(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 2, null, null, throwable);
    }

    public static void finer(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 2, string2, string3, null);
    }

    public static void finer(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 2, string2, string3, throwable);
    }

    public static void finest(String string) {
        Log.getInstance().logMessage(string, 1, null, null, null);
    }

    public static void finest(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 1, null, null, throwable);
    }

    public static void finest(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 1, string2, string3, null);
    }

    public static void finest(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 1, string2, string3, throwable);
    }

    public static void debug(String string) {
        Log.getInstance().logMessage(string, 3, null, null, null);
    }

    public static void debug(String string, Throwable throwable) {
        Log.getInstance().logMessage(string, 3, null, null, throwable);
    }

    public static void debug(String string, String string2, String string3) {
        Log.getInstance().logMessage(string, 3, string2, string3, null);
    }

    public static void debug(String string, String string2, String string3, Throwable throwable) {
        Log.getInstance().logMessage(string, 3, string2, string3, throwable);
    }

    private synchronized void logMessage(String string, int n, String string2, String string3, Throwable throwable) {
        if (n >= this.m_logLevel) {
            this.m_handler.publish(n, string, string2, string3, throwable);
        }
    }
}

