/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ErrorHelper;
import com.hp.hpl.jena.regression.ResourceReader;

public class testModelEquals {
    private boolean inError = false;

    protected static void doTest(Model model, Model model2) {
        new testModelEquals().test(model, model2);
    }

    void test(Model model, Model model2) {
        String string = "testModelEquals";
        String string2 = "modules/rdf/regression/" + string + "/";
        boolean[] blArray = new boolean[]{false, true, true, true, true, false, false, true, false};
        int n = 0;
        try {
            n = 1;
            while (n < 7) {
                testModelEquals.empty(model);
                testModelEquals.empty(model2);
                model.read(ResourceReader.getInputStream(string2 + Integer.toString(n) + "-1.rdf"), "");
                model2.read(ResourceReader.getInputStream(string2 + Integer.toString(n) + "-2.rdf"), "");
                if (model.isIsomorphicWith(model2) != blArray[n]) {
                    this.error(string, n);
                    System.out.println("m1:");
                    model.write(System.out, "N-TRIPLE");
                    System.out.println("m2:");
                    model2.write(System.out, "N-TRIPLE");
                }
                ++n;
            }
            n = 7;
            while (n < 9) {
                testModelEquals.empty(model);
                testModelEquals.empty(model2);
                model.read(ResourceReader.getInputStream(string2 + Integer.toString(n) + "-1.nt"), "", "N-TRIPLE");
                model2.read(ResourceReader.getInputStream(string2 + Integer.toString(n) + "-2.nt"), "", "N-TRIPLE");
                if (model.isIsomorphicWith(model2) != blArray[n]) {
                    this.error(string, n);
                    System.out.println("m1:");
                    model.write(System.out, "N-TRIPLE");
                    System.out.println("m2:");
                    model2.write(System.out, "N-TRIPLE");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.inError = true;
            ErrorHelper.logInternalError(" test " + string, n, exception);
        }
    }

    protected static void empty(Model model) throws RDFException {
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            stmtIterator.remove();
        }
    }

    protected void error(String string, int n) {
        System.out.println(string + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }

    public static void main(String[] stringArray) throws RDFException {
        testModelEquals.doTest(new ModelMem(), new ModelMem());
    }
}

