/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.StandardTripleMatch;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;

public class TransitiveReasoner
implements Reasoner {
    protected TransitiveGraphCache subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
    protected TransitiveGraphCache subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
    protected Finder tbox = null;
    public static Node directSubPropertyOf = ReasonerRegistry.makeDirect(RDFS.subPropertyOf.getNode());
    public static Node directSubClassOf = ReasonerRegistry.makeDirect(RDFS.subClassOf.getNode());
    public static Node subPropertyOf = RDFS.subPropertyOf.getNode();
    public static Node subClassOf = RDFS.subClassOf.getNode();

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        return this.bindSchema(new FGraph(graph));
    }

    Reasoner bindSchema(Finder finder) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        this.tbox = finder;
        TransitiveReasoner.cacheSubProp(finder, this.subPropertyCache);
        TransitiveReasoner.cacheSubClass(finder, this.subPropertyCache, this.subClassCache);
        return this;
    }

    public static boolean cacheSubProp(Finder finder, TransitiveGraphCache transitiveGraphCache) {
        if (finder == null) {
            return false;
        }
        transitiveGraphCache.cacheAll(finder, subPropertyOf);
        boolean bl = false;
        boolean bl2 = false;
        HashSet<Node> hashSet = new HashSet<Node>();
        do {
            ExtendedIterator extendedIterator = transitiveGraphCache.find(new TriplePattern(null, subPropertyOf, subPropertyOf));
            while (extendedIterator.hasNext()) {
                bl2 = false;
                Triple triple = (Triple)extendedIterator.next();
                Node node = triple.getSubject();
                if (node.equals(subPropertyOf) || hashSet.contains(node)) continue;
                bl = true;
                hashSet.add(node);
                transitiveGraphCache.cacheAll(finder, node);
                bl2 = true;
            }
        } while (bl2);
        return bl;
    }

    public static boolean cacheSubClass(Finder finder, TransitiveGraphCache transitiveGraphCache, TransitiveGraphCache transitiveGraphCache2) {
        if (finder == null) {
            return false;
        }
        transitiveGraphCache2.cacheAll(finder, subClassOf);
        boolean bl = false;
        ExtendedIterator extendedIterator = transitiveGraphCache.find(new TriplePattern(null, subPropertyOf, subClassOf));
        while (extendedIterator.hasNext()) {
            bl = true;
            Triple triple = (Triple)extendedIterator.next();
            Node node = triple.getSubject();
            if (node.equals(subClassOf)) continue;
            transitiveGraphCache2.cacheAll(finder, node);
        }
        return bl;
    }

    public static boolean checkOccurance(Node node, Graph graph, TransitiveGraphCache transitiveGraphCache) {
        boolean bl = false;
        ExtendedIterator extendedIterator = graph.find(new StandardTripleMatch(null, node, null));
        bl = extendedIterator.hasNext();
        extendedIterator.close();
        if (bl) {
            return bl;
        }
        ExtendedIterator extendedIterator2 = transitiveGraphCache.find(new TriplePattern(null, subPropertyOf, node));
        while (extendedIterator2.hasNext() && !bl) {
            Triple triple = (Triple)extendedIterator2.next();
            Node node2 = triple.getSubject();
            extendedIterator = graph.find(new StandardTripleMatch(null, node2, null));
            bl = extendedIterator.hasNext();
            extendedIterator.close();
        }
        extendedIterator2.close();
        return bl;
    }

    public static void addGraph(Graph graph, Graph graph2) {
        ExtendedIterator extendedIterator = graph2.find(null, null, null);
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
        extendedIterator.close();
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        return new TransitiveInfGraph(graph, this);
    }
}

