/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class WGReasonerTester {
    public static final String NS = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
    public static final String BASE_URI = "http://www.w3.org/2000/10/rdf-tests/rdfcore/";
    public static final String baseDir = "testing/wg/";
    public static final Resource PositiveEntailmentTest;
    public static final Resource NegativeEntailmentTest;
    public static final Resource FalseDocument;
    public static final Property descriptionP;
    public static final Property statusP;
    public static final Property entailmentRulesP;
    public static final Property premiseDocumentP;
    public static final Property conclusionDocumentP;
    public static final String[] blockedTests;
    protected Model testManifest;
    protected static Logger logger;
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$WGReasonerTester;

    public WGReasonerTester(String string) throws IOException {
        this.testManifest = WGReasonerTester.loadFile(string);
    }

    public static Model loadFile(String string) throws IOException {
        String string2 = "RDF/XML";
        if (string.endsWith(".nt")) {
            string2 = "N-TRIPLE";
        } else if (string.endsWith("n3")) {
            string2 = "N3";
        }
        Model model = ModelFactory.createNonreifyingModel();
        String string3 = string;
        if (string3.startsWith(BASE_URI)) {
            string3 = string3.substring(BASE_URI.length());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(baseDir + string3));
        model.read(bufferedReader, BASE_URI + string3, string2);
        return model;
    }

    private Graph loadTestFile(Resource resource, Property property) throws IOException {
        if (resource.hasProperty(property)) {
            String string = resource.getProperty(property).getObject().toString();
            return WGReasonerTester.loadFile(string).getGraph();
        }
        return new GraphMem();
    }

    public boolean runTests(ReasonerFactory reasonerFactory, TestCase testCase, Model model) throws IOException {
        String string;
        ResIterator resIterator = this.testManifest.listSubjectsWithProperty(RDF.type, PositiveEntailmentTest);
        while (resIterator.hasNext()) {
            string = resIterator.next().toString();
            if (this.runTest(string, reasonerFactory, testCase, model)) continue;
            return false;
        }
        resIterator = this.testManifest.listSubjectsWithProperty(RDF.type, NegativeEntailmentTest);
        while (resIterator.hasNext()) {
            string = resIterator.next().toString();
            if (this.runTest(string, reasonerFactory, testCase, model)) continue;
            return false;
        }
        return true;
    }

    public boolean runTest(String string, ReasonerFactory reasonerFactory, TestCase testCase, Model model) throws IOException {
        Resource resource = this.testManifest.getResource(string);
        Resource resource2 = (Resource)resource.getProperty(RDF.type).getObject();
        if (!resource2.equals(NegativeEntailmentTest) && !resource2.equals(PositiveEntailmentTest)) {
            throw new RDFException("Can't find test: " + string);
        }
        String string2 = resource.getProperty(descriptionP).getObject().toString();
        String string3 = resource.getProperty(statusP).getObject().toString();
        logger.debug((Object)("WG test " + resource.getURI() + " - " + string3));
        int n = 0;
        while (n < blockedTests.length) {
            if (resource.getURI().equals(blockedTests[n])) {
                return true;
            }
            ++n;
        }
        Model model2 = ModelFactory.createNonreifyingModel();
        StmtIterator stmtIterator = resource.listProperties(premiseDocumentP);
        while (stmtIterator.hasNext()) {
            model2.add(WGReasonerTester.loadFile(stmtIterator.nextStatement().getObject().toString()));
        }
        Model model3 = null;
        Resource resource3 = (Resource)resource.getProperty(conclusionDocumentP).getObject();
        Resource resource4 = (Resource)resource3.getProperty(RDF.type).getObject();
        if (!resource4.equals(FalseDocument)) {
            model3 = WGReasonerTester.loadFile(resource3.toString());
        }
        Reasoner reasoner = reasonerFactory.create(model);
        InfGraph infGraph = reasoner.bind(model2.getGraph());
        Model model4 = ModelFactory.createModelForGraph(infGraph);
        boolean bl = true;
        if (resource2.equals(PositiveEntailmentTest)) {
            if (model3 == null) {
                bl = !infGraph.validate().isValid();
            } else {
                bl = this.testConclusions(model3.getGraph(), model4.getGraph());
                if (!infGraph.validate().isValid()) {
                    bl = false;
                }
            }
        } else {
            boolean bl2 = bl = !this.testConclusions(model3.getGraph(), model4.getGraph());
        }
        if (!bl) {
            logger.debug((Object)"Premises: ");
            StmtIterator stmtIterator2 = model2.listStatements();
            while (stmtIterator2.hasNext()) {
                logger.debug((Object)("  - " + stmtIterator2.nextStatement()));
            }
            logger.debug((Object)"Conclusions: ");
            StmtIterator stmtIterator3 = model3.listStatements();
            while (stmtIterator3.hasNext()) {
                logger.debug((Object)("  - " + stmtIterator3.nextStatement()));
            }
        }
        if (testCase != null) {
            TestCase.assertTrue((String)("Test: " + resource + "\n" + string2), (boolean)bl);
        }
        return bl;
    }

    private boolean testConclusions(Graph graph, Graph graph2) {
        QueryHandler queryHandler = graph2.queryHandler();
        Query query = WGReasonerTester.graphToQuery(graph);
        ExtendedIterator extendedIterator = queryHandler.prepareBindings(query, new Node[0]).executeBindings();
        return extendedIterator.hasNext();
    }

    public static Query graphToQuery(Graph graph) {
        HashMap hashMap = new HashMap();
        Query query = new Query();
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            query.addMatch(WGReasonerTester.translate(triple.getSubject(), hashMap), WGReasonerTester.translate(triple.getPredicate(), hashMap), WGReasonerTester.translate(triple.getObject(), hashMap));
        }
        return query;
    }

    private static Node translate(Node node, HashMap hashMap) {
        String string = "abcdefghijklmnopqrstuvwxyz";
        if (node.isBlank()) {
            Node node2 = (Node)hashMap.get(node);
            if (node2 == null) {
                int n = hashMap.size();
                if (n > string.length()) {
                    throw new ReasonerException("Too many bnodes in query");
                }
                node2 = Node.createVariable(string.substring(n, n + 1));
                hashMap.put(node, node2);
            }
            return node2;
        }
        return node;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        blockedTests = new String[]{"http://www.w3.org/2000/10/rdf-tests/rdfcore/datatypes/Manifest.rdf#language-important-for-non-dt-entailment-1", "http://www.w3.org/2000/10/rdf-tests/rdfcore/datatypes/Manifest.rdf#language-important-for-non-dt-entailment-2"};
        PositiveEntailmentTest = new ResourceImpl(NS, "PositiveEntailmentTest");
        NegativeEntailmentTest = new ResourceImpl(NS, "NegativeEntailmentTest");
        FalseDocument = new ResourceImpl(NS, "False-Document");
        descriptionP = new PropertyImpl(NS, "description");
        statusP = new PropertyImpl(NS, "status");
        entailmentRulesP = new PropertyImpl(NS, "entailmentRules");
        premiseDocumentP = new PropertyImpl(NS, "premiseDocument");
        conclusionDocumentP = new PropertyImpl(NS, "conclusionDocument");
        logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$test$WGReasonerTester == null ? (class$com$hp$hpl$jena$reasoner$test$WGReasonerTester = WGReasonerTester.class$("com.hp.hpl.jena.reasoner.test.WGReasonerTester")) : class$com$hp$hpl$jena$reasoner$test$WGReasonerTester));
    }
}

