/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestReasoners
extends TestCase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$test$TestReasoners == null ? (class$com$hp$hpl$jena$reasoner$test$TestReasoners = TestReasoners.class$("com.hp.hpl.jena.reasoner.test.TestReasoners")) : class$com$hp$hpl$jena$reasoner$test$TestReasoners));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$TestReasoners;

    public TestReasoners(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$test$TestReasoners == null ? (class$com$hp$hpl$jena$reasoner$test$TestReasoners = TestReasoners.class$("com.hp.hpl.jena.reasoner.test.TestReasoners")) : class$com$hp$hpl$jena$reasoner$test$TestReasoners);
    }

    public void testTransitiveReasoner() throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester("transitive/manifest.rdf");
        ReasonerFactory reasonerFactory = TransitiveReasonerFactory.theInstance();
        Assert.assertTrue((String)"transitive reasoner tests", (boolean)reasonerTester.runTests(reasonerFactory, this, null));
    }

    public void testRDFSReasoner() throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester("rdfs/manifest.rdf");
        ReasonerFactory reasonerFactory = RDFSReasonerFactory.theInstance();
        Assert.assertTrue((String)"RDFS reasoner tests", (boolean)reasonerTester.runTests(reasonerFactory, this, null));
        ModelMem modelMem = new ModelMem();
        modelMem.createResource("http://www.hpl.hp.com/semweb/2003/RDFSReasoner1").addProperty(RDFSReasonerFactory.scanProperties, "false");
        Assert.assertTrue((String)"RDFS reasoner tests", (!reasonerTester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test17", reasonerFactory, null, modelMem) ? (byte)1 : 0) != 0);
    }

    public void testRDFSDTRange() throws IOException {
        Assert.assertTrue((!this.doTestRDFSDTRange("dttest1.nt") ? (byte)1 : 0) != 0);
        Assert.assertTrue((!this.doTestRDFSDTRange("dttest2.nt") ? (byte)1 : 0) != 0);
        Assert.assertTrue((boolean)this.doTestRDFSDTRange("dttest3.nt"));
    }

    private boolean doTestRDFSDTRange(String string) throws IOException {
        Model model = WGReasonerTester.loadFile("../reasoners/rdfs/" + string);
        ReasonerFactory reasonerFactory = RDFSReasonerFactory.theInstance();
        InfGraph infGraph = reasonerFactory.create(null).bind(model.getGraph());
        ValidityReport validityReport = infGraph.validate();
        if (!validityReport.isValid()) {
            logger.debug((Object)"Validation error report:");
            int n = 0;
            while (n < validityReport.size()) {
                logger.debug((Object)validityReport.get(n).toString());
                ++n;
            }
        }
        return validityReport.isValid();
    }

    public void testWGRDFStests() throws IOException {
        WGReasonerTester wGReasonerTester = new WGReasonerTester("Manifest.rdf");
        ReasonerFactory reasonerFactory = RDFSReasonerFactory.theInstance();
        wGReasonerTester.runTests(reasonerFactory, this, null);
    }

    public void testModelFactoryRDFS() {
        Model model = ModelFactory.createDefaultModel();
        Property property = model.createProperty("urn:x-hp:ex/p");
        Resource resource = model.createResource("urn:x-hp:ex/a");
        Resource resource2 = model.createResource("urn:x-hp:ex/b");
        Resource resource3 = model.createResource("urn:x-hp:ex/c");
        model.add((Resource)property, RDFS.range, resource3).add(resource, property, resource2);
        Model model2 = ModelFactory.createRDFSModel(model);
        StmtIterator stmtIterator = model2.listStatements(new SimpleSelector(resource2, RDF.type, (RDFNode)null));
        TestUtil.assertIteratorValues(this, stmtIterator, new Object[]{new StatementImpl(resource2, RDF.type, RDFS.Resource), new StatementImpl(resource2, RDF.type, resource3)});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

