/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasoner;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;

public class RDFSReasonerFactory
implements ReasonerFactory {
    private static ReasonerFactory theInstance = new RDFSReasonerFactory();
    public static final String URI = "http://www.hpl.hp.com/semweb/2003/RDFSReasoner1";
    public static final Property scanProperties = new PropertyImpl("http://www.hpl.hp.com/semweb/2003/RDFSReasoner1#", "scanProperties");
    public static final Property checkDTRange = new PropertyImpl("http://www.hpl.hp.com/semweb/2003/RDFSReasoner1#", "checkDTRange");

    public static ReasonerFactory theInstance() {
        return theInstance;
    }

    public Reasoner create(Model model) {
        return new RDFSReasoner(model);
    }

    public Model getCapabilities() {
        ModelMem modelMem = new ModelMem();
        Resource resource = modelMem.createResource(this.getURI());
        resource.addProperty(ReasonerRegistry.nameP, "RDFS Reasoner 1").addProperty(ReasonerRegistry.descriptionP, "Complete RDFS implementation supporting metalevel statements.\nEager caching of schema information, back chaining for most entailments\nCan separate tbox and abox data if desired to reuse tbox caching or mix them.").addProperty(ReasonerRegistry.configurationP, scanProperties).addProperty(ReasonerRegistry.supportsP, RDFS.subClassOf).addProperty(ReasonerRegistry.supportsP, RDFS.subPropertyOf).addProperty(ReasonerRegistry.supportsP, RDFS.member).addProperty(ReasonerRegistry.supportsP, RDFS.range).addProperty(ReasonerRegistry.supportsP, RDFS.domain).addProperty(ReasonerRegistry.supportsP, TransitiveReasoner.directSubClassOf).addProperty(ReasonerRegistry.supportsP, TransitiveReasoner.directSubPropertyOf).addProperty(ReasonerRegistry.versionP, "0.1");
        return modelMem;
    }

    public String getURI() {
        return URI;
    }

    public static void main(String[] stringArray) {
        Resource resource = ReasonerRegistry.theRegistry().getDescription(URI);
        System.out.println("Reasoner: " + resource);
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            System.out.println(statement.getPredicate().getLocalName() + " = " + statement.getObject());
        }
    }
}

