/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;

public class RDFSReasoner
extends TransitiveReasoner
implements Reasoner {
    public static Node domainP = RDFS.domain.getNode();
    public static Node rangeP = RDFS.range.getNode();
    protected boolean scanProperties = true;
    protected boolean checkDTRange = false;

    public RDFSReasoner() {
    }

    public RDFSReasoner(Model model) {
        if (model != null) {
            Boolean bl = this.checkBinaryPredicate(RDFSReasonerFactory.scanProperties, model);
            if (bl != null) {
                this.scanProperties = bl;
            }
            if ((bl = this.checkBinaryPredicate(RDFSReasonerFactory.checkDTRange, model)) != null) {
                this.checkDTRange = bl;
            }
        }
    }

    private Boolean checkBinaryPredicate(Property property, Model model) {
        Resource resource = model.getResource("http://www.hpl.hp.com/semweb/2003/RDFSReasoner1");
        StmtIterator stmtIterator = resource.listProperties(RDFSReasonerFactory.scanProperties);
        if (stmtIterator.hasNext()) {
            return new Boolean(stmtIterator.nextStatement().getObject().toString().equalsIgnoreCase("true"));
        }
        return null;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        super.bindSchema(graph);
        this.subPropertyCache.setCaching(true);
        return this;
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        return new RDFSInfGraph(this.tbox, graph, this.subPropertyCache, this.subClassCache, this);
    }
}

