/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;

public class PropertyBRWRule
extends BRWRule {
    public PropertyBRWRule() {
        super(new TriplePattern(Node.createVariable("p"), RDF.type.getNode(), RDF.Property.getNode()), new TriplePattern(null, Node.createVariable("s"), null));
    }

    public ExtendedIterator execute(TriplePattern triplePattern, InfGraph infGraph, Finder finder, HashSet hashSet) {
        RDFSInfGraph rDFSInfGraph = (RDFSInfGraph)infGraph;
        Node node = triplePattern.getSubject();
        if (rDFSInfGraph.getScanProperties()) {
            return new NiceIterator();
        }
        TriplePattern triplePattern2 = BRWRule.instantiate(this.body, triplePattern);
        return new BRWRule.RewriteIterator(rDFSInfGraph.findRawWithContinuation(this.body, finder), this);
    }

    static class PropertyNodeIterator
    extends UniqueExtendedIterator {
        public PropertyNodeIterator(Iterator iterator) {
            super(iterator);
        }

        protected Object nextIfNew() {
            Node node = (Node)this.underlying.next();
            if (this.seen.add(node)) {
                return new Triple(node, RDF.type.getNode(), RDF.Property.getNode());
            }
            return null;
        }
    }
}

