/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class BaseFRule {
    protected TriplePattern head;
    protected TriplePattern[] body;

    public BaseFRule(TriplePattern triplePattern, TriplePattern[] triplePatternArray) {
        this.head = triplePattern;
        this.body = triplePatternArray;
    }

    public BaseFRule(String string) {
        List list = BaseFRule.parseTripleSequence(string);
        this.head = (TriplePattern)list.get(0);
        this.body = new TriplePattern[list.size() - 1];
        int n = 1;
        while (n < list.size()) {
            this.body[n - 1] = (TriplePattern)list.get(n);
            ++n;
        }
    }

    public void bindAndFire(Triple triple, RDFSInfGraph rDFSInfGraph) {
        if ((triple.getPredicate().equals(TransitiveReasoner.subPropertyOf) || triple.getPredicate().equals(TransitiveReasoner.subClassOf)) && triple.getSubject().equals(triple.getObject())) {
            return;
        }
        HashMap hashMap = new HashMap();
        BaseFRule.matchNode(triple.getSubject(), this.head.getSubject(), hashMap);
        BaseFRule.matchNode(triple.getPredicate(), this.head.getPredicate(), hashMap);
        BaseFRule.matchNode(triple.getObject(), this.head.getObject(), hashMap);
        TriplePattern[] triplePatternArray = new TriplePattern[this.body.length];
        int n = 0;
        while (n < this.body.length) {
            triplePatternArray[n] = new TriplePattern(BaseFRule.instantiate(this.body[n].getSubject(), hashMap), BaseFRule.instantiate(this.body[n].getPredicate(), hashMap), BaseFRule.instantiate(this.body[n].getObject(), hashMap));
            ++n;
        }
        this.fire(triplePatternArray, rDFSInfGraph);
    }

    void fire(TriplePattern[] triplePatternArray, RDFSInfGraph rDFSInfGraph) {
    }

    static void matchNode(Node node, Node node2, Map map) {
        if (node2.isVariable()) {
            map.put(node2.getName(), node);
        }
    }

    static Node instantiate(Node node, Map map) {
        Node node2;
        if (node.isVariable() && (node2 = (Node)map.get(node.getName())) != null) {
            return node2;
        }
        return node;
    }

    public static Triple parseTriple(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            Node node = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node2 = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node3 = BRWRule.parseNode(stringTokenizer.nextToken());
            return new Triple(node, node2, node3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ReasonerException("Illegal triple: " + string);
        }
    }

    private static TriplePattern parseTriplePattern(StringTokenizer stringTokenizer) {
        try {
            Node node = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node2 = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node3 = BRWRule.parseNode(stringTokenizer.nextToken());
            return new TriplePattern(node, node2, node3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ReasonerException("Illegal triple in rule");
        }
    }

    public static List parseTripleSequence(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<TriplePattern> arrayList = new ArrayList<TriplePattern>();
        while (stringTokenizer.hasMoreElements()) {
            String string2;
            arrayList.add(BaseFRule.parseTriplePattern(stringTokenizer));
            if (!stringTokenizer.hasMoreElements() || (string2 = stringTokenizer.nextToken()).equals("|") || string2.equals("->") || string2.equals("<-")) continue;
            throw new ReasonerException("Illegal FRUle spec: " + string);
        }
        return arrayList;
    }

    public TriplePattern getHead() {
        return this.head;
    }
}

