/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.util.iterator.BaseExtendedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class BRWRule {
    protected TriplePattern head;
    protected TriplePattern body;

    public BRWRule(TriplePattern triplePattern, TriplePattern triplePattern2) {
        this.head = triplePattern;
        this.body = triplePattern2;
    }

    public static BRWRule makeRule(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            Node node = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node2 = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node3 = BRWRule.parseNode(stringTokenizer.nextToken());
            TriplePattern triplePattern = new TriplePattern(node, node2, node3);
            if (!stringTokenizer.nextToken().equals("<-")) {
                throw new NoSuchElementException();
            }
            Node node4 = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node5 = BRWRule.parseNode(stringTokenizer.nextToken());
            Node node6 = BRWRule.parseNode(stringTokenizer.nextToken());
            TriplePattern triplePattern2 = new TriplePattern(node4, node5, node6);
            return new BRWRule(triplePattern, triplePattern2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ReasonerException("Illegal BRWRule: " + string);
        }
    }

    public ExtendedIterator execute(TriplePattern triplePattern, InfGraph infGraph, Finder finder, HashSet hashSet) {
        TriplePattern triplePattern2 = BRWRule.instantiate(this.body, triplePattern);
        BRWRule bRWRule = new BRWRule(this.head, triplePattern2);
        if (hashSet.contains(bRWRule)) {
            return new NiceIterator();
        }
        hashSet.add(bRWRule);
        ExtendedIterator extendedIterator = ((RDFSInfGraph)infGraph).findNested(triplePattern2, finder, hashSet);
        hashSet.remove(bRWRule);
        return new RewriteIterator(extendedIterator, bRWRule);
    }

    public boolean completeFor(TriplePattern triplePattern) {
        return false;
    }

    protected static TriplePattern instantiate(TriplePattern triplePattern, TriplePattern triplePattern2) {
        return new TriplePattern(BRWRule.instantiate(triplePattern.getSubject(), triplePattern2), BRWRule.instantiate(triplePattern.getPredicate(), triplePattern2), BRWRule.instantiate(triplePattern.getObject(), triplePattern2));
    }

    protected static Node instantiate(Node node, TriplePattern triplePattern) {
        if (node.isVariable()) {
            String string = node.getName();
            if (string.equals("s")) {
                return triplePattern.getSubject();
            }
            if (string.equals("p")) {
                return triplePattern.getPredicate();
            }
            if (string.equals("o")) {
                return triplePattern.getObject();
            }
        }
        return node;
    }

    protected static Node instantiate(Node node, Triple triple) {
        if (node.isVariable()) {
            String string = node.getName();
            if (string.equals("s")) {
                return triple.getSubject();
            }
            if (string.equals("p")) {
                return triple.getPredicate();
            }
            if (string.equals("o")) {
                return triple.getObject();
            }
        }
        return node;
    }

    public static Node parseNode(String string) {
        if (string.startsWith("?")) {
            return Node.createVariable(string.substring(1));
        }
        if (string.equals("_")) {
            return Node.createVariable("*");
        }
        if (string.indexOf(58) != -1) {
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equalsIgnoreCase("rdf")) {
                return Node.createURI(RDF.getURI() + string3);
            }
            if (string2.equalsIgnoreCase("rdfs")) {
                return Node.createURI(RDFS.getURI() + string3);
            }
            return Node.createURI(string);
        }
        return Node.createURI(string);
    }

    public String toString() {
        return this.head.toString() + " <- " + this.body.toString();
    }

    public TriplePattern getBody() {
        return this.body;
    }

    public TriplePattern getHead() {
        return this.head;
    }

    public boolean equals(Object object) {
        return object instanceof BRWRule && this.head.equals(((BRWRule)object).head) && this.body.equals(((BRWRule)object).body);
    }

    public int hashCode() {
        return this.head.hashCode() >> 1 ^ this.body.hashCode();
    }

    static class RewriteIterator
    extends BaseExtendedIterator {
        TriplePattern head;

        public RewriteIterator(Iterator iterator, BRWRule bRWRule) {
            super(iterator);
            this.head = bRWRule.head;
        }

        public Object next() {
            Triple triple = (Triple)this.underlying.next();
            return new Triple(BRWRule.instantiate(this.head.getSubject(), triple), BRWRule.instantiate(this.head.getPredicate(), triple), BRWRule.instantiate(this.head.getObject(), triple));
        }
    }
}

