/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.StandardTripleMatch;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class TriplePattern {
    protected Node subject;
    protected Node predicate;
    protected Node object;
    public static final Node nodeWildcard = Node.createVariable("*");

    public TriplePattern(Node node, Node node2, Node node3) {
        this.subject = TriplePattern.normalize(node);
        this.predicate = TriplePattern.normalize(node2);
        this.object = TriplePattern.normalize(node3);
    }

    public TriplePattern(TripleMatch tripleMatch) {
        this.subject = TriplePattern.normalize(tripleMatch.getSubject());
        this.predicate = TriplePattern.normalize(tripleMatch.getPredicate());
        this.object = TriplePattern.normalize(tripleMatch.getObject());
    }

    public Node getObject() {
        return this.object;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getSubject() {
        return this.subject;
    }

    public TripleMatch asTripleMatch() {
        return new StandardTripleMatch(TriplePattern.toMatch(this.subject), TriplePattern.toMatch(this.predicate), TriplePattern.toMatch(this.object));
    }

    public Triple asTriple() {
        return new Triple(this.subject, this.predicate, this.object);
    }

    public boolean compatibleWith(TriplePattern triplePattern) {
        return !(!this.subject.isVariable() && !triplePattern.subject.isVariable() && !this.subject.equals(triplePattern.subject) || !this.predicate.isVariable() && !triplePattern.predicate.isVariable() && !this.predicate.equals(triplePattern.predicate) || !this.object.isVariable() && !triplePattern.object.isVariable() && !this.object.equals(triplePattern.object));
    }

    public boolean subsumes(TriplePattern triplePattern) {
        return !(!this.subject.isVariable() && !this.subject.equals(triplePattern.subject) || !this.predicate.isVariable() && !this.predicate.equals(triplePattern.predicate) || !this.object.isVariable() && !this.object.equals(triplePattern.object));
    }

    public String toString() {
        return TriplePattern.simplePrintString(this.subject) + " @" + TriplePattern.simplePrintString(this.predicate) + " " + TriplePattern.simplePrintString(this.object);
    }

    public static String simplePrintString(Triple triple) {
        return TriplePattern.simplePrintString(triple.getSubject()) + " @" + TriplePattern.simplePrintString(triple.getPredicate()) + " " + TriplePattern.simplePrintString(triple.getObject());
    }

    public static String simplePrintString(Node node) {
        if (node instanceof Node_URI) {
            String string = node.getURI();
            int n = string.lastIndexOf(35);
            if (n == -1 && (n = string.lastIndexOf(47)) == -1) {
                n = -1;
            }
            String string2 = string.substring(0, n + 1);
            String string3 = "";
            if (string2.equals(RDF.getURI())) {
                string3 = "rdf:";
            } else if (string2.equals(RDFS.getURI())) {
                string3 = "rdfs:";
            }
            return string3 + string.substring(n + 1);
        }
        return node.toString();
    }

    private static Node normalize(Node node) {
        return node == null ? nodeWildcard : node;
    }

    private static Node toMatch(Node node) {
        return node.isVariable() ? null : node;
    }

    public boolean equals(Object object) {
        return object instanceof TriplePattern && this.subject.equals(((TriplePattern)object).subject) && this.predicate.equals(((TriplePattern)object).predicate) && this.object.equals(((TriplePattern)object).object);
    }

    public int hashCode() {
        return this.subject.hashCode() >> 1 ^ this.predicate.hashCode() ^ this.object.hashCode() << 1;
    }
}

