/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;

public class ReasonerRegistry {
    protected static ReasonerRegistry theRegistry;
    protected Map reasonerFactories = new HashMap();
    protected Model allDescriptions = new ModelMem();
    public static String JenaReasonerNS;
    public static Resource ReasonerClass;
    public static Property nameP;
    public static Property descriptionP;
    public static Property versionP;
    public static Property supportsP;
    public static Property configurationP;

    private ReasonerRegistry() {
        this.register(TransitiveReasonerFactory.theInstance());
        this.register(RDFSReasonerFactory.theInstance());
    }

    public static ReasonerRegistry theRegistry() {
        if (theRegistry == null) {
            theRegistry = new ReasonerRegistry();
        }
        return theRegistry;
    }

    public void register(ReasonerFactory reasonerFactory) {
        this.reasonerFactories.put(reasonerFactory.getURI(), reasonerFactory);
        Model model = reasonerFactory.getCapabilities();
        if (model != null) {
            this.allDescriptions.add(model);
        }
        this.allDescriptions.createResource(reasonerFactory.getURI()).addProperty(RDF.type, ReasonerClass);
    }

    public void register(String string, ReasonerFactory reasonerFactory) {
        this.reasonerFactories.put(string, reasonerFactory);
        this.allDescriptions.createResource(string).addProperty(RDF.type, ReasonerClass);
    }

    public Model getAllDescriptions() {
        return this.allDescriptions;
    }

    public Resource getDescription(String string) {
        Resource resource = this.allDescriptions.getResource(string);
        if (this.allDescriptions.contains(resource, RDF.type, ReasonerClass)) {
            return resource;
        }
        return null;
    }

    public ReasonerFactory getFactory(String string) {
        return (ReasonerFactory)this.reasonerFactories.get(string);
    }

    public Reasoner create(String string, Model model) throws ReasonerException {
        ReasonerFactory reasonerFactory = this.getFactory(string);
        if (reasonerFactory != null) {
            return reasonerFactory.create(model);
        }
        throw new ReasonerException("Attempted to instantiate an unknown reasoner: " + string);
    }

    public static Node makeDirect(Node node) {
        String string = "urn:x-hp-direct-predicate:" + node.getURI().replace(':', '_');
        return Node.createURI(string);
    }

    static {
        JenaReasonerNS = "http://www.hpl.hp.com/semweb/2003/JenaReasoner#";
        ReasonerClass = new ResourceImpl(JenaReasonerNS + "ReasonerClass");
        nameP = new PropertyImpl(JenaReasonerNS, "name");
        descriptionP = new PropertyImpl(JenaReasonerNS, "description");
        versionP = new PropertyImpl(JenaReasonerNS, "version");
        supportsP = new PropertyImpl(JenaReasonerNS, "supports");
        configurationP = new PropertyImpl(JenaReasonerNS, "configurationProperty");
    }
}

