/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PatternRouter {
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$PatternRouter == null ? (class$com$hp$hpl$jena$reasoner$PatternRouter = PatternRouter.class$("com.hp.hpl.jena.reasoner.PatternRouter")) : class$com$hp$hpl$jena$reasoner$PatternRouter));
    Map patternIndex = new HashMap();
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$PatternRouter;

    public void register(TransitiveGraphCache transitiveGraphCache) {
        this.register(new TriplePattern(null, transitiveGraphCache.getClosedPredicate(), null), transitiveGraphCache);
        this.register(new TriplePattern(null, transitiveGraphCache.getDirectPredicate(), null), transitiveGraphCache);
    }

    public void register(BRWRule bRWRule) {
        this.register(bRWRule.getHead(), bRWRule);
    }

    public void register(TriplePattern triplePattern, Object object) {
        PatternEntry patternEntry = new PatternEntry(triplePattern, object);
        Node node = triplePattern.getPredicate();
        if (node.isVariable()) {
            throw new ReasonerException("PatternRouter can't handle non-ground predicates in patterns: " + triplePattern);
        }
        HashSet<PatternEntry> hashSet = (HashSet<PatternEntry>)this.patternIndex.get(node);
        if (hashSet == null) {
            hashSet = new HashSet<PatternEntry>();
            this.patternIndex.put(node, hashSet);
        }
        hashSet.add(patternEntry);
    }

    public ExtendedIterator find(TriplePattern triplePattern, Finder finder, Finder finder2, InfGraph infGraph) {
        return this.find(triplePattern, finder, finder2, infGraph, new HashSet());
    }

    public ExtendedIterator find(TriplePattern triplePattern, Finder finder, Finder finder2, InfGraph infGraph, HashSet hashSet) {
        ExtendedIterator extendedIterator = finder.findWithContinuation(triplePattern, finder2);
        Node node = triplePattern.getPredicate();
        if (node.isVariable()) {
            Iterator iterator = this.patternIndex.values().iterator();
            while (iterator.hasNext()) {
                HashSet hashSet2 = (HashSet)iterator.next();
                extendedIterator = this.doFind(hashSet2, extendedIterator, triplePattern, finder, finder2, infGraph, hashSet);
            }
            return extendedIterator;
        }
        HashSet hashSet3 = (HashSet)this.patternIndex.get(node);
        return this.doFind(hashSet3, extendedIterator, triplePattern, finder, finder2, infGraph, hashSet);
    }

    private ExtendedIterator doFind(HashSet hashSet, ExtendedIterator extendedIterator, TriplePattern triplePattern, Finder finder, Finder finder2, InfGraph infGraph, HashSet hashSet2) {
        if (hashSet != null) {
            Object object;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (PatternEntry)iterator.next();
                if (!((PatternEntry)object).completeFor(triplePattern)) continue;
                return ((PatternEntry)object).fire(triplePattern, finder2, infGraph, hashSet2);
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                PatternEntry patternEntry = (PatternEntry)object.next();
                if (!patternEntry.shouldFire(triplePattern)) continue;
                extendedIterator = extendedIterator.andThen(patternEntry.fire(triplePattern, finder2, infGraph, hashSet2));
            }
        }
        return extendedIterator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.patternIndex.values().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet = (HashSet)iterator.next();
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append(iterator2.next().toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class PatternEntry {
        TriplePattern pattern;
        Object action;

        PatternEntry(TriplePattern triplePattern, Object object) {
            this.pattern = triplePattern;
            this.action = object;
        }

        public boolean completeFor(TriplePattern triplePattern) {
            if (this.action instanceof BRWRule) {
                return ((BRWRule)this.action).completeFor(triplePattern);
            }
            if (this.action instanceof TransitiveGraphCache) {
                TransitiveGraphCache transitiveGraphCache = (TransitiveGraphCache)this.action;
                Node node = triplePattern.getPredicate();
                return node.equals(transitiveGraphCache.getDirectPredicate()) || node.equals(transitiveGraphCache.getClosedPredicate());
            }
            return false;
        }

        boolean shouldFire(TriplePattern triplePattern) {
            return this.pattern.compatibleWith(triplePattern);
        }

        public ExtendedIterator fire(TriplePattern triplePattern, Finder finder, InfGraph infGraph, HashSet hashSet) {
            TriplePattern triplePattern2 = triplePattern;
            if (triplePattern2.getPredicate().isVariable()) {
                triplePattern2 = new TriplePattern(triplePattern.getSubject(), this.pattern.getPredicate(), triplePattern.getObject());
            }
            if (this.action instanceof TransitiveGraphCache) {
                return ((TransitiveGraphCache)this.action).find(triplePattern2);
            }
            if (this.action instanceof BRWRule) {
                logger.debug((Object)("Fire rule: " + this.action));
                return ((BRWRule)this.action).execute(triplePattern2, infGraph, finder, hashSet);
            }
            throw new ReasonerException("Illegal router action entry");
        }

        public String toString() {
            return this.pattern.toString() + " <- " + this.action;
        }

        public boolean equals(Object object) {
            return object instanceof PatternEntry && this.pattern.equals(((PatternEntry)object).pattern) && this.action.equals(((PatternEntry)object).action);
        }

        public int hashCode() {
            return this.pattern.hashCode() >> 1 ^ this.action.hashCode();
        }
    }
}

