/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class BaseInfGraph
extends GraphBase
implements InfGraph {
    protected Reasoner reasoner;
    protected FGraph fdata;

    public BaseInfGraph(Graph graph, Reasoner reasoner) {
        this.fdata = new FGraph(graph);
        this.reasoner = reasoner;
    }

    public Graph getRawGraph() {
        return this.fdata.getGraph();
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public Node getGlobalProperty(Node node) {
        throw new ReasonerException("Global property not implemented: " + node);
    }

    public boolean testGlobalProperty(Node node) {
        Object object;
        Node node2 = this.getGlobalProperty(node);
        if (node2.isLiteral() && (object = node2.getLiteral().getValue()) instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ReasonerException("Global property test returned non-boolean value\nTest was: " + node + "\nResult was: " + node2);
    }

    public ValidityReport validate() {
        return new StandardValidityReport();
    }

    public ExtendedIterator find(Node node, Node node2, Node node3, Graph graph) {
        return this.find(node, node2, node3);
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.find(tripleMatch.getSubject(), tripleMatch.getPredicate(), tripleMatch.getObject()).filterKeep(new TripleMatchFilter(tripleMatch));
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), this.fdata);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        return this.findWithContinuation(triplePattern, null);
    }

    public abstract ExtendedIterator findWithContinuation(TriplePattern var1, Finder var2);

    public Reifier getReifier() {
        return null;
    }
}

