/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNumeric;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import java.io.ByteArrayInputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExpressions
extends TestSuite {
    static final String testSetName = "RDQL - Expressions";

    public static TestSuite suite() {
        return new TestExpressions(testSetName);
    }

    private TestExpressions(String string) {
        super(string);
        String string2 = "http://www.w3.org/2001/XMLSchema#";
        this.addTest((Test)new TestNumeric("7", 7L));
        this.addTest((Test)new TestNumeric("-3", -3L));
        this.addTest((Test)new TestNumeric("3+4+5", 12L));
        this.addTest((Test)new TestNumeric("(3+4)+5", 12L));
        this.addTest((Test)new TestNumeric("3+(4+5)", 12L));
        this.addTest((Test)new TestNumeric("3*4+5", 17L));
        this.addTest((Test)new TestNumeric("3*(4+5)", 27L));
        this.addTest((Test)new TestNumeric("10-3-5", 2L));
        this.addTest((Test)new TestNumeric("(10-3)-5", 2L));
        this.addTest((Test)new TestNumeric("10-(3-5)", 12L));
        this.addTest((Test)new TestNumeric("10-3+5", 12L));
        this.addTest((Test)new TestNumeric("10-(3+5)", 2L));
        this.addTest((Test)new TestNumeric("1<<2", 4L));
        this.addTest((Test)new TestNumeric("1<<2<<2", 16L));
        this.addTest((Test)new TestNumeric("10000>>2", 2500L));
        this.addTest((Test)new TestNumeric("1.5 + 2.5", 4.0));
        this.addTest((Test)new TestNumeric("1.5 + 2", 3.5));
        this.addTest((Test)new TestNumeric("4111222333444", 4111222333444L));
        this.addTest((Test)new TestNumeric("1234 + 4111222333444", 4111222334678L));
        this.addTest((Test)new TestBoolean("true", false, true));
        this.addTest((Test)new TestBoolean("false", false, false));
        this.addTest((Test)new TestBoolean("false || true", false, true));
        this.addTest((Test)new TestBoolean("false && true", false, false));
        this.addTest((Test)new TestBoolean("2 < 3", false, true));
        this.addTest((Test)new TestBoolean("2 > 3", false, false));
        this.addTest((Test)new TestBoolean("(2 < 3) && (3<4)", false, true));
        this.addTest((Test)new TestBoolean("(2 < 3) && (3>=4)", false, false));
        this.addTest((Test)new TestBoolean("(2 < 3) || (3>=4)", false, true));
        this.addTest((Test)new TestBoolean("2 == 3", false, false));
        this.addTest((Test)new TestBoolean("\"fred\" ne \"joe\"", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq \"joe\"", false, false));
        this.addTest((Test)new TestBoolean("\"fred\" eq \"fred\"", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq 'fred'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq 'fr\\ed'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" ne \"fred\"", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'^^<type1>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'joe'^^<type1>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'^^<type2>", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'fred'^^<type2>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<" + string2 + "string> eq 'fred'", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'fred'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\\1\" eq 'fred1'", false, true));
        this.addTest((Test)new TestBoolean("\"fred2\" eq 'fred\\2'", false, true));
        this.addTest((Test)new TestBoolean("'fred\\\\3' ne \"fred3\"", false, true));
        this.addTest((Test)new TestBoolean("\"urn:fred\" eq <urn:fred>", false, true));
        this.addTest((Test)new TestBoolean("\"urn:fred\" ne <urn:fred>", false, false));
        this.addTest((Test)new TestBoolean("\"urn:fred/1.5\" ne <urn:fred/1.5>", false, false));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /abbc/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /a..c/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /^aabb/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /cc$/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" !~ /abbc/", false, false));
        this.addTest((Test)new TestBoolean("\"aab*bcc\" =~ /ab\\*bc/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" ~~ /ab\\\\*bc/", false, true));
        this.addTest((Test)new TestBoolean("'aabbcc' =~ /B.*B/i", false, true));
        this.addTest((Test)new TestBoolean("1.5 < 2", false, true));
        this.addTest((Test)new TestBoolean("1.5 > 2", false, false));
        this.addTest((Test)new TestBoolean("1.5 < 2.3", false, true));
        this.addTest((Test)new TestBoolean("1.5 > 2.3", false, false));
        this.addTest((Test)new TestBoolean("4111222333444 > 1234", false, true));
        this.addTest((Test)new TestBoolean("4111222333444 < 1234", false, false));
        this.addTest((Test)new TestBoolean("2 < \"fred\"", true, false));
        this.addTest((Test)new TestBoolean("2 || true", true, false));
    }

    static class TestBoolean
    extends TestCase {
        String s;
        boolean failureCorrect;
        boolean rightAnswer;

        TestBoolean(String string, boolean bl, boolean bl2) {
            super("Boolean test : " + string + " ");
            this.s = string;
            this.failureCorrect = bl;
            this.rightAnswer = bl2;
        }

        protected void runTest() throws Throwable {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser rDQLParser = new RDQLParser(byteArrayInputStream);
            l3 = System.currentTimeMillis();
            try {
                rDQLParser.Expression();
            }
            catch (Error error) {
                TestCase.fail((String)("Error throw in parse: " + this.s));
            }
            l4 = System.currentTimeMillis();
            l2 = l4 - l3;
            rDQLParser.top().fixup(null);
            Expr expr = (Expr)((Object)rDQLParser.top());
            Assert.assertTrue((String)("Expression is not ExprBoolean: " + expr.getClass().getName()), (boolean)(expr instanceof ExprBoolean));
            ExprBoolean exprBoolean = (ExprBoolean)expr;
            Value value = null;
            boolean bl = false;
            try {
                value = exprBoolean.eval(null, null);
                bl = value.getBoolean();
            }
            catch (EvalFailureException evalFailureException) {
                if (!this.failureCorrect) {
                    throw evalFailureException;
                }
                bl = false;
            }
            Assert.assertEquals((String)(this.s + " => " + bl + " [" + this.rightAnswer + "]"), (boolean)bl, (boolean)this.rightAnswer);
        }
    }

    static class TestNumeric
    extends TestCase {
        String s;
        boolean isDouble = false;
        long rightAnswer;
        double rightAnswerDouble;

        TestNumeric(String string, long l) {
            super("Numeric test : " + string + " ");
            this.s = string;
            this.rightAnswer = l;
            this.isDouble = false;
        }

        TestNumeric(String string, double d) {
            super("Numeric test : " + string + " ");
            this.s = string;
            this.rightAnswerDouble = d;
            this.isDouble = true;
        }

        protected void runTest() throws Throwable {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser rDQLParser = new RDQLParser(byteArrayInputStream);
            l3 = System.currentTimeMillis();
            try {
                rDQLParser.Expression();
            }
            catch (Error error) {
                Assert.fail((String)("Error thrown in parse: " + error));
            }
            l4 = System.currentTimeMillis();
            l2 = l4 - l3;
            rDQLParser.top().fixup(null);
            Expr expr = (Expr)((Object)rDQLParser.top());
            Assert.assertTrue((String)("Expression is not ExprNumeric: " + expr.getClass().getName()), (boolean)(expr instanceof ExprNumeric));
            ExprNumeric exprNumeric = (ExprNumeric)expr;
            Value value = exprNumeric.eval(null, null);
            if (!this.isDouble) {
                Assert.assertEquals((String)(this.s + " => " + value.getInt() + " [" + this.rightAnswer + "]"), (long)value.getInt(), (long)this.rightAnswer);
            } else {
                Assert.assertEquals((String)(this.s + " => " + value.getDouble() + " [" + this.rightAnswerDouble + "]"), (double)value.getDouble(), (double)this.rightAnswerDouble, (double)1.0E-4);
            }
        }
    }
}

