/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngineSesame;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.rdql.ResultBinding;
import java.io.PrintWriter;
import java.util.Iterator;

public class SesameQueryMain {
    static final String serverURLStr = "http://localhost:3030/sesame/";
    static final String repository = "sesame-db";

    public static void main(String[] stringArray) {
        try {
            PrintWriter printWriter = new PrintWriter(System.out);
            String string = "SELECT * WHERE (<http://foo/bar#C>, ?y, ?z)";
            Query query = new Query(string);
            QueryEngineSesame queryEngineSesame = new QueryEngineSesame(query, serverURLStr, repository);
            QueryResultsMem queryResultsMem = new QueryResultsMem(queryEngineSesame.exec());
            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResultsMem);
            queryResultsFormatter.printAll(printWriter);
            queryResultsMem.reset();
            printWriter.flush();
            System.out.println();
            QueryResultsMem queryResultsMem2 = queryResultsMem;
            while (queryResultsMem2.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResultsMem2.next();
                System.out.println(resultBinding);
                Iterator iterator = resultBinding.getTriples().iterator();
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    System.out.println("    " + statement);
                }
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("Unhandled exception: " + exception);
            exception.printStackTrace(System.err);
            return;
        }
    }
}

