/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprNumeric;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.io.PrintWriter;

class Q_UnaryPlus
extends SimpleNode
implements ExprNumeric {
    Expr expr;
    private String printName = "unaryplus";
    private String opSymbol = "+";

    Q_UnaryPlus(int n) {
        super(n);
    }

    Q_UnaryPlus(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        Value value = this.expr.eval(query, resultBinding);
        if (!value.isNumber()) {
            throw new EvalTypeException("Q_UnaryPlus: Wanted a number: got " + this.expr);
        }
        return value;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryPlus: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.expr, null, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

