/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.WorkingVar;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.io.PrintWriter;

class Q_UnaryNot
extends SimpleNode
implements Expr,
ExprBoolean {
    private String printName = "unaryminus";
    private String opSymbol = "!";
    Expr expr;

    Q_UnaryNot(int n) {
        super(n);
    }

    Q_UnaryNot(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryNot: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        Value value = this.expr.eval(query, resultBinding);
        if (!value.isBoolean()) {
            throw new EvalTypeException("Q_UnaryNot: Wanted a number: got " + this.expr);
        }
        WorkingVar workingVar = new WorkingVar();
        workingVar.setBoolean(!value.getBoolean());
        return workingVar;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.expr, null, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

