/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdql.parser.Node;
import com.hp.hpl.jena.rdql.parser.ParsedLiteral;
import com.hp.hpl.jena.rdql.parser.Q_Identifier;
import com.hp.hpl.jena.rdql.parser.Q_Query;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.RDQLParser;

class Q_TextLiteral
extends ParsedLiteral {
    Q_URI datatype = null;
    String langTag = null;
    String seen = null;

    Q_TextLiteral(int n) {
        super(n);
    }

    Q_TextLiteral(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void set(String string) {
        this.seen = string;
        string = string.substring(1, string.length() - 1);
        super.setString(Q_TextLiteral.unescape(string, '\\'));
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.jjtGetChild(n2);
            if (node instanceof Q_Identifier) {
                this.langTag = ((Q_Identifier)node).id;
            }
            if (node instanceof Q_URI) {
                this.datatype = (Q_URI)node;
            }
            ++n2;
        }
        if (this.langTag != null) {
            this.seen = this.seen + "@" + this.langTag;
        }
        if (this.datatype != null) {
            this.seen = this.seen + "^^" + this.datatype.asQuotedString();
        }
    }

    public void fixup(Q_Query q_Query) {
        String string = null;
        if (this.datatype != null) {
            if (!this.datatype.isSet) {
                this.datatype.fixup(q_Query);
            }
            string = this.datatype.valueString();
        }
        Literal literal = ParsedLiteral.model.createTypedLiteral(super.getString(), this.langTag, string);
        super.setRDFLiteral(literal);
    }

    public String asQuotedString() {
        return this.seen;
    }

    static String unescape(String string, char c) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == c && n < string.length() - 1) {
                char c2 = string.charAt(n + 1);
                if (c2 == 'n') {
                    c2 = '\n';
                }
                if (c2 == 't') {
                    c2 = '\t';
                }
                if (c2 == 'r') {
                    c2 = '\r';
                }
                if (c2 == 'b') {
                    c2 = '\b';
                }
                string = string.substring(0, n) + c2 + string.substring(n + 2);
            }
            ++n;
        }
        return string;
    }
}

