/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Settable;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.WorkingVar;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.io.PrintWriter;

class Q_StringEqual
extends SimpleNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    protected static boolean enableRDFLiteralSameValueAs = true;
    protected static String printName = "str=";
    protected static String opSymbol = "eq";

    Q_StringEqual(int n) {
        super(n);
    }

    Q_StringEqual(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    protected boolean rawEval(Value value, Value value2) {
        if (enableRDFLiteralSameValueAs && value.isRDFLiteral() && value2.isRDFLiteral()) {
            Literal literal = value.getRDFLiteral();
            Literal literal2 = value2.getRDFLiteral();
            boolean bl = literal.sameValueAs(literal2);
            return bl;
        }
        String string = value.valueString();
        String string2 = value2.valueString();
        return string.equals(string2);
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        Value value = this.left.eval(query, resultBinding);
        Value value2 = this.right.eval(query, resultBinding);
        boolean bl = this.rawEval(value, value2);
        Settable settable = value instanceof Settable ? (Settable)value : (value2 instanceof Settable ? (Settable)value2 : new WorkingVar());
        settable.setBoolean(bl);
        return settable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, printName, opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, printName, opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.left, this.right, printName, opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

