/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.EvalFailureException;
import com.hp.hpl.jena.rdql.QSys;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.parser.Expr;

public class ConstraintExpr
implements Constraint {
    Expr expr;

    ConstraintExpr(Expr expr) {
        this.expr = expr;
    }

    public boolean isSatified(Query query, ResultBinding resultBinding) {
        if (this.expr == null) {
            return false;
        }
        try {
            return this.expr.eval(query, resultBinding).getBoolean();
        }
        catch (EvalFailureException evalFailureException) {
            return false;
        }
        catch (Exception exception) {
            QSys.unhandledException(exception, "ConstraintExpr", "isSatified");
            return false;
        }
    }

    public String toString() {
        return this.expr.asInfixString();
    }
}

